/*
 * @(#)OrderAuditEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_order_audit")
public class StdOrderAuditEo extends CubeBaseEo {
    public static StdOrderAuditEo newInstance() {
        return (StdOrderAuditEo) BaseEo.newInstance(StdOrderAuditEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 订单类型
     * 父订单, 子订单, 第三方订单
     */
    @Column(name = "order_type")
    private String orderType;
    /**
     * 本地的订单流水号
     */
    @Column(name = "local_order_no")
    private String localOrderNo;
    /**
     * 新值
     */
    @Column(name = "new_value")
    private String newValue;
    /**
     * 变动说明
     */
    @Column(name = "audit_desc")
    private String auditDesc;
    /**
     * 审核人
     */
    @Column(name = "auditor")
    private String auditor;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getLocalOrderNo() {
        return this.localOrderNo;
    }

    public void setLocalOrderNo(String localOrderNo) {
        this.localOrderNo = localOrderNo;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public String getAuditDesc() {
        return this.auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public String getAuditor() {
        return this.auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }


}