package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 对账差异单Eo对象
 *
 * @author 妙才
 * @since 2021-01-19
 */
@Table(name = "tr_order_compare_diff")
public class StdOrderCompareDiffEo extends CubeBaseEo {

    /**
     * 原订单号
     */
    @Column(name = "source_order_no")
    private String sourceOrderNo;
    /**
     * 对账任务id
     */
    @Column(name = "reconciliation_task_id")
    private Long reconciliationTaskId;
    /**
     * 交易流水号
     */
    @Column(name = "source_trade_no")
    private String sourceTradeNo;
    /**
     * 交易流水号
     */
    @Column(name = "order_type")
    private Integer orderType;
    /**
     * 对账渠道ID
     */
    @Column(name = "channel_code")
    private String channelCode;
    /**
     * 对账渠道名称
     */
    @Column(name = "channel_name")
    private String channelName;
    /**
     * 店铺ID
     */
    @Column(name = "shop_code")
    private String shopCode;
    /**
     * 店铺名称
     */
    @Column(name = "shop_name")
    private String shopName;
    /**
     * 渠道销售金额
     */
    @Column(name = "channel_sell_price")
    private BigDecimal channelSellPrice;
    /**
     * 渠道应付金额
     */
    @Column(name = "channel_pay_price")
    private BigDecimal channelPayPrice;
    /**
     * 渠道支付金额
     */
    @Column(name = "channel_actual_price")
    private BigDecimal channelActualPrice;
    /**
     * 渠道支出金额
     */
    @Column(name = "channel_paid_price")
    private BigDecimal channelPaidPrice;
    /**
     * 渠道服务费
     */
    @Column(name = "channel_fee")
    private BigDecimal channelFee;
    /**
     * 比较订单号
     */
    @Column(name = "target_order_no")
    private String targetOrderNo;
    /**
     * 系统销售金额
     */
    @Column(name = "target_sell_price")
    private BigDecimal targetSellPrice;
    /**
     * 系统应付金额
     */
    @Column(name = "target_pay_price")
    private BigDecimal targetPayPrice;
    /**
     * 系统支付金额
     */
    @Column(name = "target_actual_price")
    private BigDecimal targetActualPrice;
    /**
     * 系统支出金额
     */
    @Column(name = "target_paid_price")
    private BigDecimal targetPaidPrice;
    /**
     * 差异金额
     */
    @Column(name = "diff_amount")
    private BigDecimal diffAmount;
    /**
     * 支付时间
     */
    @Column(name = "pay_time")
    private Date payTime;
    /**
     * 对账状态
     */
    @Column(name = "diff_status")
    private String diffStatus;

    /**
     * 对账时间
     */
    @Column(name = "diff_time")
    private Date diffTime;
    /**
     * 确认状态
     */
    @Column(name = "status")
    private String status;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    public Long getReconciliationTaskId() {
        return reconciliationTaskId;
    }

    public void setReconciliationTaskId(Long reconciliationTaskId) {
        this.reconciliationTaskId = reconciliationTaskId;
    }

    public void setSourceOrderNo(String sourceOrderNo) {
        this.sourceOrderNo = sourceOrderNo;
    }

    public String getSourceOrderNo() {
        return this.sourceOrderNo;
    }

    public void setSourceTradeNo(String sourceTradeNo) {
        this.sourceTradeNo = sourceTradeNo;
    }

    public String getSourceTradeNo() {
        return this.sourceTradeNo;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopName() {
        return this.shopName;
    }

    public void setChannelSellPrice(BigDecimal channelSellPrice) {
        this.channelSellPrice = channelSellPrice;
    }

    public BigDecimal getChannelSellPrice() {
        return this.channelSellPrice;
    }

    public void setChannelPayPrice(BigDecimal channelPayPrice) {
        this.channelPayPrice = channelPayPrice;
    }

    public BigDecimal getChannelPayPrice() {
        return this.channelPayPrice;
    }

    public void setChannelActualPrice(BigDecimal channelActualPrice) {
        this.channelActualPrice = channelActualPrice;
    }

    public BigDecimal getChannelActualPrice() {
        return this.channelActualPrice;
    }

    public void setChannelFee(BigDecimal channelFee) {
        this.channelFee = channelFee;
    }

    public BigDecimal getChannelFee() {
        return this.channelFee;
    }

    public void setTargetOrderNo(String targetOrderNo) {
        this.targetOrderNo = targetOrderNo;
    }

    public String getTargetOrderNo() {
        return this.targetOrderNo;
    }

    public void setTargetSellPrice(BigDecimal targetSellPrice) {
        this.targetSellPrice = targetSellPrice;
    }

    public BigDecimal getTargetSellPrice() {
        return this.targetSellPrice;
    }

    public void setTargetPayPrice(BigDecimal targetPayPrice) {
        this.targetPayPrice = targetPayPrice;
    }

    public BigDecimal getTargetPayPrice() {
        return this.targetPayPrice;
    }

    public void setTargetActualPrice(BigDecimal targetActualPrice) {
        this.targetActualPrice = targetActualPrice;
    }

    public BigDecimal getTargetActualPrice() {
        return this.targetActualPrice;
    }

    public BigDecimal getDiffAmount() {
        return diffAmount;
    }

    public void setDiffAmount(BigDecimal diffAmount) {
        this.diffAmount = diffAmount;
    }

    public void setDiffStatus(String diffStatus) {
        this.diffStatus = diffStatus;
    }

    public String getDiffStatus() {
        return this.diffStatus;
    }

    public void setDiffTime(Date diffTime) {
        this.diffTime = diffTime;
    }

    public Date getDiffTime() {
        return this.diffTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Integer getOrderType() {
        return orderType;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public BigDecimal getChannelPaidPrice() {
        return channelPaidPrice;
    }

    public void setChannelPaidPrice(BigDecimal channelPaidPrice) {
        this.channelPaidPrice = channelPaidPrice;
    }

    public BigDecimal getTargetPaidPrice() {
        return targetPaidPrice;
    }

    public void setTargetPaidPrice(BigDecimal targetPaidPrice) {
        this.targetPaidPrice = targetPaidPrice;
    }
}
