/*
 * @(#)OrderCouponEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 订单优惠券信息 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_order_coupon")
public class StdOrderCouponEo extends CubeBaseEo {
    public static StdOrderCouponEo newInstance() {
        return (StdOrderCouponEo) BaseEo.newInstance(StdOrderCouponEo.class);
    }

    /**
     * 优惠券来源系统
     */
    @Column(name = "coupon_src")
    private String couponSrc;
    /**
     * 优惠券ID
     */
    @Column(name = "coupon_serial")
    private String couponSerial;
    /**
     * 优惠券类型 1 平台优惠券 2 店铺优惠券  3 类目优惠券 4 商品优惠券
     */
    @Column(name = "coupon_type")
    private String couponType;
    /**
     * 优惠券名称
     */
    @Column(name = "coupon_name")
    private String couponName;
    /**
     * 优惠面额
     * 如果是按比例折扣, 这里字段存最大抵扣金额
     */
    @Column(name = "total_amount")
    private BigDecimal totalAmount;
    /**
     * 优惠券折扣类型 :
     * RATE :按比例折扣
     * AMOUNT: 按金额折扣
     */
    @Column(name = "discount_type")
    private String discountType;
    /**
     * 折扣值
     */
    @Column(name = "discount_value")
    private BigDecimal discountValue;
    /**
     * 最低订单金额
     */
    @Column(name = "min_order_amont")
    private BigDecimal minOrderAmont;
    /**
     * 实际折扣金额
     */
    @Column(name = "actual_discount_amount")
    private BigDecimal actualDiscountAmount;

    /**
     * 订单流水号
     */
    @Column(name = "order_no")
    private String orderNo;
    /**
     * 活动ID
     */
    @Column(name = "activity_id")
    private String activityId;

    public String getCouponSrc() {
        return this.couponSrc;
    }

    public void setCouponSrc(String couponSrc) {
        this.couponSrc = couponSrc;
    }

    public String getCouponSerial() {
        return this.couponSerial;
    }

    public void setCouponSerial(String couponSerial) {
        this.couponSerial = couponSerial;
    }

    public String getCouponType() {
        return this.couponType;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    public String getCouponName() {
        return this.couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(String discountType) {
        this.discountType = discountType;
    }

    public BigDecimal getDiscountValue() {
        return this.discountValue;
    }

    public void setDiscountValue(BigDecimal discountValue) {
        this.discountValue = discountValue;
    }

    public BigDecimal getMinOrderAmont() {
        return this.minOrderAmont;
    }

    public void setMinOrderAmont(BigDecimal minOrderAmont) {
        this.minOrderAmont = minOrderAmont;
    }

    public BigDecimal getActualDiscountAmount() {
        return this.actualDiscountAmount;
    }

    public void setActualDiscountAmount(BigDecimal actualDiscountAmount) {
        this.actualDiscountAmount = actualDiscountAmount;
    }


    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }


}