package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.enhance.flow.NameCodePair;
import com.dtyunxi.cube.enhance.flow.StatusValueInfo;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import org.apache.commons.lang3.tuple.Pair;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 发货单 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_order_delivery")
public class StdOrderDeliveryEo extends CubeBaseEo implements IFlowEntity {
    /**
     * 打印数据
     */
    @Column(name = "print_data")
    private String printData;

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;

    /**
     * 订单流水号
     */
    @Deprecated
    @Column(name = "order_no")
    private String orderNo;

    /**
     * 发货流水号
     */
    @Column(name = "delivery_no")
    private String deliveryNo;

    /**
     * 父发货单号
     */
    @Column(name = "parent_delivery_no")
    private String parentDeliveryNo;

    /**
     * 是否已拆单，0-未拆单，1-已拆单
     */
    @Column(name = "split_flag")
    private Integer splitFlag;

    /**
     * 配送人员id
     */
    @Column(name = "deliverer_id")
    private String delivererId;

    /**
     * 配送方式：（express 快递， pickup 自提，  intra-city 同城配送，clerk 店员配送） 默认是 express
     */
    @Column(name = "shipping_type")
    private String shippingType;

    /**
     * 发货仓库id
     */
    @Column(name = "warehouse_serial")
    private String warehouseSerial;

    /**
     * 发货仓库编码
     */
    @Column(name = "warehouse_code")
    private String warehouseCode;

    /**
     * 发货仓库子类型，用于区分门店仓和非门店仓，LOGICAL_SHOP_WAREHOUSE为门店仓
     */
    @Column(name = "warehouse_sub_type")
    private String warehouseSubType;

    /**
     * 所属门店编码
     */
    @Column(name = "shop_code")
    private String shopCode;

    @Column(name = "shop_id")
    private String shopId;

    /**
     * 发货仓库名称
     */
    @Column(name = "warehouse_name")
    private String warehouseName;

    /**
     * 接单时间
     */
    @Column(name = "receive_time")
    private Date receiveTime;

    /**
     * 指派时间
     */
    @Column(name = "assign_time")
    private Date assignTime;

    /**
     * 发货单类型：0 路由发货单，1 指派发货单
     */
    @Column(name = "delivery_type")
    private Integer deliveryType;

    /**
     * 自提类型：订单order  包裹pack 商品 goods
     */
    @Column(name = "pickup_type")
    private String pickupType;

    /**
     * 发货单状态 :TO_ROUTE:待路由, TO_DO:待处理，TO_ASSIGN:待指派, TO_RECEIVING: 待接单, INIT: 待发货, PARTIAL_DELIVERED: 部分发货, DELIVERED: 已发货, SIGNED: 已签收, CANCELED: 已取消, FINISHED: 已完成，CANCLE：已取消
     */
    @Column(name = "delivery_status")
    private String deliveryStatus;

    /**
     * 发货单在配送方的状态
     */
    @Column(name = "partner_delivery_status")
    private String partnerDeliveryStatus;

    /**
     * 收货人名称
     */
    @Column(name = "delivery_name")
    private String deliveryName;

    /**
     * 详细地址全称
     */
    @Column(name = "address")
    private String address;

    /**
     * 收货人手机号
     */
    @Column(name = "delivery_mobile")
    private String deliveryMobile;

    /**
     * 收货人座机号
     */
    @Column(name = "delivery_phone")
    private String deliveryPhone;

    /**
     * 国家地区编码
     */
    @Column(name = "country_code")
    private String countryCode;

    /**
     * 国家地区名称
     */
    @Column(name = "country_name")
    private String countryName;

    /**
     * 省
     */
    @Column(name = "province_code")
    private String provinceCode;

    /**
     * 省名称
     */
    @Column(name = "province_name")
    private String provinceName;

    /**
     * 市
     */
    @Column(name = "city_code")
    private String cityCode;

    /**
     * 市名称
     */
    @Column(name = "city_name")
    private String cityName;

    /**
     * 区
     */
    @Column(name = "area_code")
    private String areaCode;

    /**
     * 区名称
     */
    @Column(name = "area_name")
    private String areaName;

    /**
     * 街道
     */
    @Column(name = "street_code")
    private String streetCode;

    /**
     * 街道名称
     */
    @Column(name = "street_name")
    private String streetName;

    /**
     * 详细地址
     */
    @Column(name = "detailed")
    private String detailed;

    /**
     * 邮编
     */
    @Column(name = "postcode")
    private String postcode;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 取消方式: 0: 未取消,buyer_cancle: 买家取消,seller_cancle:卖家取消
     */
    @Column(name = "cancel_type")
    private String cancelType;

    /**
     * 取消完成的时间
     */
    @Column(name = "cancel_time")
    private Date cancelTime;

    /**
     * 取消原因
     */
    @Column(name = "cancel_desc")
    private String cancelDesc;


    /**
     * 出库单号
     */
    @Column(name = "delivery_order_code")
    private String deliveryOrderCode;

    /**
     * 出库单类型，JYCK=一般交易出库单, HHCK=换货出库 单, BFCK=补发出库单，QTCK=其他出库单
     */
    @Column(name = "order_type")
    private String orderType;

    /**
     * 操作员 (审核员) 编码
     */
    @Column(name = "operator_code")
    private String operatorCode;

    /**
     * 操作员 (审核员) 名称
     */
    @Column(name = "operator_name")
    private String operatorName;

    /**
     * 订单总金额
     */
    @Column(name = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 商品总金额 (元)
     */
    @Column(name = "item_amount")
    private BigDecimal itemAmount;

    /**
     * 订单折扣金额 (元)
     */
    @Column(name = "discount_amount")
    private BigDecimal discountAmount;

    /**
     * 快递费用 (元)
     */
    @Column(name = "freight_amount")
    private BigDecimal freightAmount;

    /**
     * 应收金额 (元)，消费者还需要支付多少（货到付款时消费者还需要支付多少约定使用这个字段）
     */
    @Column(name = "ar_amount")
    private BigDecimal arAmount;

    /**
     * 已收金额 (元)，消费者已经支付多少
     */
    @Column(name = "got_amount")
    private BigDecimal gotAmount;

    /**
     * 物流公司编码，SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、
     * BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、
     * JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)
     */
    @Column(name = "shipping_company_code")
    private String shippingCompanyCode;

    /**
     * 物流公司名称
     */
    @Column(name = "shipping_company")
    private String shippingCompany;

    /**
     * 运单号
     */
    @Column(name = "express_code")
    private String expressCode;

    /**
     * 投递时延要求，1=工作日,2=节假日,101=当日达,102=次晨达,103=次日达,104=预约达
     */
    @Column(name = "schedule_type")
    private Integer scheduleType;

    /**
     * 要求送达日期，要求送达日期，YYYY-MM-DD
     */
    @Column(name = "schedule_day")
    private String scheduleDay;

    /**
     * 投递时间范围要求(开始时间)，HH:MM:SS
     */
    @Column(name = "schedule_start_time")
    private String scheduleStartTime;

    /**
     * 投递时间范围要求(结束时间)，HH:MM:SS
     */
    @Column(name = "schedule_end_time")
    private String scheduleEndTime;

    /**
     * 发货服务方式，PTPS（普通配送），LLPS（冷链配送），HBP(环保 配)
     */
    @Column(name = "delivery_method")
    private String deliveryMethod;

    /**
     * 收件人公司名称
     */
    @Column(name = "company")
    private String company;

    /**
     * 收货人收件人证件类型，1-身份证 2-军官证 3-护照 4-其他
     */
    @Column(name = "identity_type")
    private Integer identityType;

    /**
     * 收货人收件人证件号码
     */
    @Column(name = "identity_no")
    private String identityNo;

    /**
     * 收货人电子邮箱
     */
    @Column(name = "email")
    private String email;

    /**
     * 发货时间
     */
    @Column(name = "delivery_time")
    private Date deliveryTime;

    /**
     * 第三方支付平台交易号, 淘系订单传支付宝交易号
     */
    @Column(name = "third_pay_no")
    private String thirdPayNo;

    /**
     * 业务类型 1-商城，2-全渠道
     */
    @Column(name = "biz_type")
    private Integer bizType;

    /**
     * 渠道编码，对应渠道表渠道
     */
    @Column(name = "channel")
    private String channel;


    /**
     * 单据使用的流程
     */
    @Column(name = "flow_def_id")
    private Long flowDefId;

    /**
     * 送达日期
     */
    @Column(name = "arrival_date")
    private Date arrivalDate;

    /**
     * 是否周期够商品
     */
    @Column(name = "cycle_buy", columnDefinition = "tinyint(2) default 0")
    private Boolean cycleBuy;


    /**
     * 发货单对应的配送计划ID
     */
    @Column(name = "delivery_plan_id")
    private Long deliveryPlanId;

    /**
     * 所属组织ID
     */
    @Column(name = "organization_id")
    private Long organizationId;

    /**
     * 所属组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 路由仓库对应的所属组织ID
     */
    @Column(name = "warehouse_organization_id")
    private Long warehouseOrganizationId;

    /**
     * 路由仓库对应的所属组织名称
     */
    @Column(name = "warehouse_organization_name")
    private String warehouseOrganizationName;

    /**
     * 发货单提货码
     */
    @Column(name = "pick_up_code")
    private String pickUpCode;

    /**
     * 提货时间
     */
    @Column(name = "pick_up_time")
    private String pickUpTime;

    /**
     * 拆分级别：1、交易中心拆，2、路由拆，3、交易+路由拆
     */
    @Column(name = "split_level")
    private Integer splitLevel;

    /**
     * 拆单次数
     */
    @Column(name = "split_count")
    private Integer splitCount;

    /**
     * 是否合单
     */
    @Column(name = "if_merge")
    private Integer ifMerge;

    /**
     * 合单次数
     */
    @Column(name = "merge_count")
    private Integer mergeCount;

    /**
     * 中台是否需要履约
     */
    @Column(name = "if_agreement")
    private Integer ifAgreement;

    /**
     * 履约状态
     */
    @Column(name = "agreement_status")
    private Integer agreementStatus;


    private static Map<String, StatusValueInfo> STATUS_PROP_DESC = new HashMap<>();

    static {
        STATUS_PROP_DESC.put("deliveryStatus", StatusValueInfo.generate("发货状态",
               NameCodePair.of("待发货","WAIT_DELIVERY"),
               NameCodePair.of("已发货","DELIVERY")));
    }


    @Override
    public String getEntityName() {
        return "发货单";
    }

    @Override
    public Long getFlowDefId() {
        return flowDefId;
    }

    @Override
    public void setFlowDefId(Long flowDefId) {
        this.flowDefId = flowDefId;
    }

    @Override
    public Map<String, StatusValueInfo> getStatusDesc() {
        return STATUS_PROP_DESC;
    }

    @Override
    public String getStatus(String statusField) {
        return deliveryStatus;
    }

    @Override
    public void setStatus(String statusField, String newStatus) {
        this.deliveryStatus = newStatus;
    }


    public String getDelivererId() {
        return delivererId;
    }

    public void setDelivererId(String delivererId) {
        this.delivererId = delivererId;
    }

    public String getParentDeliveryNo() {
        return parentDeliveryNo;
    }

    public void setParentDeliveryNo(String parentDeliveryNo) {
        this.parentDeliveryNo = parentDeliveryNo;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getWarehouseSerial() {
        return warehouseSerial;
    }

    public void setWarehouseSerial(String warehouseSerial) {
        this.warehouseSerial = warehouseSerial;
    }

    public String getDeliveryNo() {
        return this.deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getShippingType() {
        return shippingType;
    }

    public void setShippingType(String shippingType) {
        this.shippingType = shippingType;
    }

    public String getPickupType() {
        return this.pickupType;
    }

    public void setPickupType(String pickupType) {
        this.pickupType = pickupType;
    }

    public String getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public void setDeliveryStatus(String deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public String getPartnerDeliveryStatus() {
        return partnerDeliveryStatus;
    }

    public void setPartnerDeliveryStatus(String partnerDeliveryStatus) {
        this.partnerDeliveryStatus = partnerDeliveryStatus;
    }

    public String getDeliveryName() {
        return this.deliveryName;
    }

    public void setDeliveryName(String deliveryName) {
        this.deliveryName = deliveryName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getDeliveryMobile() {
        return this.deliveryMobile;
    }

    public void setDeliveryMobile(String deliveryMobile) {
        this.deliveryMobile = deliveryMobile;
    }

    public String getDeliveryPhone() {
        return this.deliveryPhone;
    }

    public void setDeliveryPhone(String deliveryPhone) {
        this.deliveryPhone = deliveryPhone;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getStreetCode() {
        return this.streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getDetailed() {
        return this.detailed;
    }

    public void setDetailed(String detailed) {
        this.detailed = detailed;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCancelType() {
        return this.cancelType;
    }

    public void setCancelType(String cancelType) {
        this.cancelType = cancelType;
    }

    public Date getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    public String getCancelDesc() {
        return this.cancelDesc;
    }

    public void setCancelDesc(String cancelDesc) {
        this.cancelDesc = cancelDesc;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getOperatorCode() {
        return operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getItemAmount() {
        return itemAmount;
    }

    public void setItemAmount(BigDecimal itemAmount) {
        this.itemAmount = itemAmount;
    }

    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public BigDecimal getFreightAmount() {
        return freightAmount;
    }

    public void setFreightAmount(BigDecimal freightAmount) {
        this.freightAmount = freightAmount;
    }

    public BigDecimal getArAmount() {
        return arAmount;
    }

    public void setArAmount(BigDecimal arAmount) {
        this.arAmount = arAmount;
    }

    public BigDecimal getGotAmount() {
        return gotAmount;
    }

    public void setGotAmount(BigDecimal gotAmount) {
        this.gotAmount = gotAmount;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

    public Integer getScheduleType() {
        return scheduleType;
    }

    public void setScheduleType(Integer scheduleType) {
        this.scheduleType = scheduleType;
    }

    public String getScheduleDay() {
        return scheduleDay;
    }

    public void setScheduleDay(String scheduleDay) {
        this.scheduleDay = scheduleDay;
    }

    public String getScheduleStartTime() {
        return scheduleStartTime;
    }

    public void setScheduleStartTime(String scheduleStartTime) {
        this.scheduleStartTime = scheduleStartTime;
    }

    public String getScheduleEndTime() {
        return scheduleEndTime;
    }

    public void setScheduleEndTime(String scheduleEndTime) {
        this.scheduleEndTime = scheduleEndTime;
    }

    public String getDeliveryOrderCode() {
        return deliveryOrderCode;
    }

    public void setDeliveryOrderCode(String deliveryOrderCode) {
        this.deliveryOrderCode = deliveryOrderCode;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public Date getAssignTime() {
        return assignTime;
    }

    public void setAssignTime(Date assignTime) {
        this.assignTime = assignTime;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getDeliveryMethod() {
        return deliveryMethod;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public Integer getIdentityType() {
        return identityType;
    }

    public void setIdentityType(Integer identityType) {
        this.identityType = identityType;
    }

    public String getIdentityNo() {
        return identityNo;
    }

    public void setIdentityNo(String identityNo) {
        this.identityNo = identityNo;
    }

    public String getThirdPayNo() {
        return thirdPayNo;
    }

    public void setThirdPayNo(String thirdPayNo) {
        this.thirdPayNo = thirdPayNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public StdOrderDeliveryEo setOrderNo(String orderNo) {
        this.orderNo = orderNo;
        return this;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getWarehouseSubType() {
        return warehouseSubType;
    }

    public void setWarehouseSubType(String warehouseSubType) {
        this.warehouseSubType = warehouseSubType;
    }

    public Date getArrivalDate() {
        return arrivalDate;
    }

    public void setArrivalDate(Date arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    public Boolean getCycleBuy() {
        return cycleBuy;
    }

    public void setCycleBuy(Boolean cycleBuy) {
        this.cycleBuy = cycleBuy;
    }

    public Long getDeliveryPlanId() {
        return deliveryPlanId;
    }

    public void setDeliveryPlanId(Long deliveryPlanId) {
        this.deliveryPlanId = deliveryPlanId;
    }

    public Integer getSplitFlag() {
        return splitFlag;
    }

    public void setSplitFlag(Integer splitFlag) {
        this.splitFlag = splitFlag;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Long getWarehouseOrganizationId() {
        return warehouseOrganizationId;
    }

    public void setWarehouseOrganizationId(Long warehouseOrganizationId) {
        this.warehouseOrganizationId = warehouseOrganizationId;
    }

    public String getWarehouseOrganizationName() {
        return warehouseOrganizationName;
    }

    public void setWarehouseOrganizationName(String warehouseOrganizationName) {
        this.warehouseOrganizationName = warehouseOrganizationName;
    }

    public String getPickUpCode() {
        return pickUpCode;
    }

    public void setPickUpCode(String pickUpCode) {
        this.pickUpCode = pickUpCode;
    }

    public String getPickUpTime() {
        return pickUpTime;
    }

    public void setPickUpTime(String pickUpTime) {
        this.pickUpTime = pickUpTime;
    }

    public Integer getSplitLevel() {
        return splitLevel;
    }

    public void setSplitLevel(Integer splitLevel) {
        this.splitLevel = splitLevel;
    }

    public Integer getSplitCount() {
        return splitCount;
    }

    public void setSplitCount(Integer splitCount) {
        this.splitCount = splitCount;
    }

    public Integer getIfMerge() {
        return ifMerge;
    }

    public void setIfMerge(Integer ifMerge) {
        this.ifMerge = ifMerge;
    }

    public Integer getMergeCount() {
        return mergeCount;
    }

    public void setMergeCount(Integer mergeCount) {
        this.mergeCount = mergeCount;
    }

    public Integer getIfAgreement() {
        return ifAgreement;
    }

    public void setIfAgreement(Integer ifAgreement) {
        this.ifAgreement = ifAgreement;
    }

    public Integer getAgreementStatus() {
        return agreementStatus;
    }

    public void setAgreementStatus(Integer agreementStatus) {
        this.agreementStatus = agreementStatus;
    }

    public String getPrintData() {
        return printData;
    }

    public void setPrintData(String printData) {
        this.printData = printData;
    }

    /**
     * 清除路由仓库相关信息
     */
    public void clearWarehouse(){
        this.warehouseName = "";
        this.warehouseCode = "";
        this.warehouseSerial = "";
        this.warehouseOrganizationId = 0L;
        this.warehouseOrganizationName = "";
    }
}