/*
 * @(#)OrderEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.enhance.flow.NameCodePair;
import com.dtyunxi.cube.enhance.flow.StatusValueInfo;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.tuple.Pair;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 订单 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_order")
public class StdOrderEo extends CubeBaseEo implements IFlowEntity {
    public static StdOrderEo newInstance() {
        return new StdOrderEo();
    }

    /**
     * 直接对应的交易流水号, 对应的trade_type 为 ORDER
     */
    @Column(name = "trade_no")
    @Deprecated
    private String tradeNo;

    /**
     * 订单流水号
     */
    @Column(name = "order_no")
    @LogicColumn
    private String orderNo;

    /**
     * 第三方订单流水号
     */
    @Column(name = "third_order_no")
    private String thirdOrderNo;

    /**
     * 原始单号
     */
    @Column(name = "orig_order_no")
    private String origOrderNo;

    /**
     * 第三方父订单号
     */
    @Column(name = "third_parent_order_no")
    private String thirdParentOrderNo;

    /**
     * 父订单号，0 表示顶级订单
     */
    @Column(name = "parent_order_no")
    private String parentOrderNo;

    /**
     * 渠道订单号
     */
    @Column(name = "sale_channel_order_no")
    private String saleChannelOrderNo;

    /**
     * 1、销售订单,2 换货订单
     */
    @Column(name = "source_order_type")
    private Integer sourceOrderType;

    /**
     * 是否线上订单：0否,1是
     */
    @Column(name = "online_type")
    private Integer onlineType;

    /**
     * 终端来源类型: 1: app端 2: PC端 3:微信端
     */
    @Column(name = "device_type")
    private String deviceType;

    /**
     * 商户所属系统
     */
    @Column(name = "seller_src")
    private String sellerSrc;

    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private String sellerId;

    /**
     * 店铺类型
     * online: 店铺
     * offline: 门店
     */
    @Column(name = "shop_type")
    private String shopType;

    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private String shopId;

    /**
     * 营业形态：暂无（给项目组使用，由项目组确定）
     */
    @Column(name = "shop_business_form")
    private Integer shopBusinessForm;

    /**
     * 组织Id
     */
    @Column(name = "organization_id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 用户来源系统
     */
    @Column(name = "user_src")
    private String userSrc;

    /**
     * 用户ID
     * 跟用户来源系统联合作为业务主键
     */
    @Column(name = "user_id")
    private String userId;

    /**
     * 下单用户ID
     */
    @Column(name = "place_user_id")
    private String placeUserId;

    /**
     * 推荐人id
     */
    @Column(name = "referrer_id")
    private String referrerId;

    /**
     * 代付费用户ID
     * 如果是代付订单,付款人的用户id
     * 跟用户来源系统联合作为业务主键
     */
    @Column(name = "pay_user_id")
    private String payUserId;

    /**
     * 订单状态：
     * PRE : 预处理 ，
     * INIT:待付款（默认），
     * PAYED: 已付款，(已付款+需要审核=待客审)，
     * 1ST_ADUIT: 已客审
     * 2ND_ADUIT: 已财审，
     * SUCC: 完成
     * CANCEL:取消
     */
    @Column(name = "order_status")
    private String orderStatus;

    /**
     * 订单交易状态
     */
    @Column(name = "order_trade_status")
    private String orderTradeStatus;

    /**
     * 订单业务状态
     */
    @Column(name = "biz_status")
    private String bizStatus;

    /**
     * 冻结状态
     * 0:初始状态
     * HANG_UP : 交易挂起
     * PAYING :.支付中
     * RETURNING: 退货中
     * REFUNDING: 退款中
     * UNLOCK : 解冻
     */
    @Column(name = "frozen_status")
    private String frozenStatus;

    /**
     * 按位存储的审核类型.
     * 0: 不需要审核
     * 1: 客服审核(初级审核)
     * 2: 财务审核(高级审核)
     * 可以继续扩展.
     */
    @Column(name = "audit_type")
    private Integer auditType;

    /**
     * 订单业务类型
     */
    @Column(name = "biz_type")
    private String bizType;

    /**
     * 应付金额
     */
    @Column(name = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 实付金额
     */
    @Column(name = "pay_amount")
    private BigDecimal payAmount;

    /**
     * 运费金额
     * 如果有父订单, 交易的订单运费一般为0
     */
    @Column(name = "freight_amount")
    private BigDecimal freightAmount;
    /**
     * 平台优惠总金额（平台级--会员积分+优惠券）
     */
    @Column(name = "platform_discount_amount")
    private BigDecimal platformDiscountAmount;
    /**
     * 店铺优惠总金额（店铺级--会员积分+优惠券）
     */
    @Column(name = "shop_discount_amount")
    private BigDecimal shopDiscountAmount;

    /**
     * 使用积分
     */
    @Column(name = "integral")
    private Integer integral;

    /**
     * 使用点券
     */
    @Column(name = "point_coupon")
    private Integer pointCoupon;

    /**
     * 金额详情
     * json结构的其他金额记录.
     */
    @Column(name = "amount_detail")
    private String amountDetail;

    /**
     * 销售渠道
     * 客户下单的最后一个触点
     */
    @Column(name = "sale_channel")
    private String saleChannel;

    /**
     * 推广渠道
     * 客户来源的第一个触点.
     */
    @Column(name = "mkt_channel")
    private String mktChannel;

    /**
     * 商品总数量
     * 总商品数量
     */
    @Column(name = "total_item_num")
    private Integer totalItemNum;

    /**
     * 买家备注
     */
    @Column(name = "buyer_remark")
    private String buyerRemark;

    /**
     * 卖家备注
     */
    @Column(name = "seller_remark")
    private String sellerRemark;

    /**
     * 下单时间
     */
    @Column(name = "place_time")
    private Date placeTime;

    /**
     * 订单状态变动时间
     * 最近一次业务变动时间
     */
    @Column(name = "change_time")
    private Date changeTime;

    /**
     * 取消方式: 0: 未取消,buyer_cancle: 买家取消,seller_cancle:卖家取消
     */
    @Column(name = "cancel_type")
    private String cancelType;

    /**
     * 取消完成的时间
     */
    @Column(name = "cancel_time")
    private Date cancelTime;

    /**
     *
     */
    @Column(name = "cancel_desc")
    private String cancelDesc;

    /**
     * 完成时间
     */
    @Column(name = "end_time")
    private Date endTime;

    /**
     * 收货地址
     */
    @Column(name = "delivery_address")
    private String deliveryAddress;

    /**
     * 卖家承担、买家承担、免邮
     * ,货到付款
     */
    @Column(name = "freight_payer")
    private Integer freightPayer;

    /**
     * 买家昵称
     */
    @Column(name = "buyer_nickname")
    private String buyerNickname;

    /**
     * 线上订单仓库编码
     */
    @Column(name = "warehouse_code")
    private String warehouseCode;

    /**
     * 卖家昵称
     */
    @Column(name = "seller_nickname")
    private String sellerNickname;

    /**
     * 订单总金额
     */
    @Column(name = "all_amount")
    private BigDecimal allAmount;

    /**
     * 优惠补差额
     */
    @Column(name = "discount_margin")
    private BigDecimal discountMargin;

    /**
     * 订单关闭时间
     */
    @Column(name = "close_time")
    private Date closeTime;

    /**
     * 优惠总金额
     */
    @Column(name = "discount_amount")
    private BigDecimal discountAmount;

    /**
     * 门店代码
     */
    @Column(name = "shop_code")
    private String shopCode;

    /**
     * 门店名称
     */
    @Column(name = "shop_name")
    private String shopName;

    /**
     * 是否已经拆单 ：0 未拆，1已拆
     */
    @Column(name = "is_split")
    private Integer isSplit;

    /**
     * 是否填写收货地址（未填将在中台填写） 0未填；1已填
     */
    @Column(name = "has_delivery_address")
    private Integer hasDeliveryAddress;

    /**
     * 是否紧急, 0 否  1 是
     */
    @Column(name = "is_urgent")
    private Integer isUrgent;

    /**
     * 是否需要发票, 0 否  1 是
     */
    @Column(name = "invoice_flag")
    private Integer invoiceFlag;

    /**
     * 发货时间
     */
    @Column(name = "delivery_time")
    private Date deliveryTime;

    /**
     * 收货时间
     */
    @Column(name = "receive_time")
    private Date receiveTime;

    /**
     * 支付时间
     */
    @Column(name = "pay_time")
    private Date payTime;

    /**
     * 商品分享记录id
     */
    @Column(name = "item_share_id")
    private Long itemShareId;
    /**
     * 发货备注
     */
    @Column(name = "delivery_info")
    private String deliveryInfo;

    /**
     * 货到付款  0 否  1 是
     */
    @Column(name = "cash_on_delivery")
    private Integer cashOnDelivery;

    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @Column(name = "bus_type")
    private Integer busType;

    /**
     * 订单商品类型: 1 普通 2 产品 3 组合 4 虚拟
     */
    @Column(name = "item_type")
    private Integer itemType;

    /**
     * 是否售后, 0 否  1 是
     */
    @Column(name = "is_return")
    private Integer isReturn;

    /**
     * 是否周期够商品
     */
    @Column(name = "is_cycle_buy")
    private Integer isCycleBuy;

    /**
     * 订单打标，值以逗号分隔
     */
    @Column(name = "order_tags")
    private String orderTags;

    public String getDeliveryInfo() {
        return deliveryInfo;
    }

    public void setDeliveryInfo(String deliveryInfo) {
        this.deliveryInfo = deliveryInfo;
    }

    public Integer getIsCycleBuy() {
        return isCycleBuy;
    }

    public void setIsCycleBuy(Integer isCycleBuy) {
        this.isCycleBuy = isCycleBuy;
    }

    public String getParentOrderNo() {
        return parentOrderNo;
    }

    public void setParentOrderNo(String parentOrderNo) {
        this.parentOrderNo = parentOrderNo;
    }

    /**
     * 单据使用的流程
     */
    @Column(name = "flow_def_id")
    private Long flowDefId;


    /**
     * 这个表map可以被流程引擎管理的"状态" 字段
     */
    private static Map<String, StatusValueInfo> STATUS_PROP_DESC = new HashMap<>();

    static {

        STATUS_PROP_DESC.put("orderTradeStatus", StatusValueInfo.generate("订单交易状态",
               NameCodePair.of("待支付","WAIT_PAY"),
               NameCodePair.of("待审核","WAIT_AUDIT"),
               NameCodePair.of("待发货","WAIT_DELIVERY"),
               NameCodePair.of("部分发货","PARTIAL_DELIVERED"),
               NameCodePair.of("已签收","CONFIRM"),
               NameCodePair.of("已发货","DELIVERY"),
               NameCodePair.of("已完成","COMPLETE"),
               NameCodePair.of("已取消","CANCEL")));
    }


    @Override
    public String getEntityName() {
        return "订单";
    }

    @Override
    public Long getFlowDefId() {
        return flowDefId;
    }

    @Override
    public void setFlowDefId(Long flowDefId) {
        this.flowDefId = flowDefId;
    }

    @Override
    public Map<String, StatusValueInfo> getStatusDesc() {
        return STATUS_PROP_DESC;
    }

    @Override
    public String getStatus(String statusField) {
        if ("orderStatus".equals(statusField)) {
            return orderStatus;
        } else if ("bizStatus".equals(statusField)) {
            return bizStatus;
        } else if ("frozenStatus".equals(statusField)) {
            return frozenStatus;
        } else if ("orderTradeStatus".equals(statusField)) {
            return orderTradeStatus;
        }
        return null;
    }

    @Override
    public void setStatus(String statusField, String newStatus) {
        if ("orderStatus".equals(statusField)) {
            this.orderStatus = newStatus;
        } else if ("bizStatus".equals(statusField)) {
            this.bizStatus = newStatus;
        } else if ("frozenStatus".equals(statusField)) {
            this.frozenStatus = newStatus;
        } else if ("orderTradeStatus".equals(statusField)) {
            this.orderTradeStatus = newStatus;
        }
    }

    @Deprecated
    public String getTradeNo() {
        return tradeNo;
    }

    @Deprecated
    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getThirdOrderNo() {
        return thirdOrderNo;
    }

    public void setThirdOrderNo(String thirdOrderNo) {
        this.thirdOrderNo = thirdOrderNo;
    }

    public String getOrigOrderNo() {
        return origOrderNo;
    }

    public void setOrigOrderNo(String origOrderNo) {
        this.origOrderNo = origOrderNo;
    }

    public String getThirdParentOrderNo() {
        return thirdParentOrderNo;
    }

    public void setThirdParentOrderNo(String thirdParentOrderNo) {
        this.thirdParentOrderNo = thirdParentOrderNo;
    }


    public Integer getSourceOrderType() {
        return sourceOrderType;
    }

    public void setSourceOrderType(Integer sourceOrderType) {
        this.sourceOrderType = sourceOrderType;
    }

    public Integer getOnlineType() {
        return onlineType;
    }

    public void setOnlineType(Integer onlineType) {
        this.onlineType = onlineType;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getSellerSrc() {
        return sellerSrc;
    }

    public void setSellerSrc(String sellerSrc) {
        this.sellerSrc = sellerSrc;
    }

    public String getSellerId() {
        return sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public String getShopType() {
        return shopType;
    }

    public void setShopType(String shopType) {
        this.shopType = shopType;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getUserSrc() {
        return userSrc;
    }

    public void setUserSrc(String userSrc) {
        this.userSrc = userSrc;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPlaceUserId() {
        return placeUserId;
    }

    public void setPlaceUserId(String placeUserId) {
        this.placeUserId = placeUserId;
    }

    public String getReferrerId() {
        return referrerId;
    }

    public void setReferrerId(String referrerId) {
        this.referrerId = referrerId;
    }

    public String getPayUserId() {
        return payUserId;
    }

    public void setPayUserId(String payUserId) {
        this.payUserId = payUserId;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderTradeStatus() {
        return orderTradeStatus;
    }

    public void setOrderTradeStatus(String orderTradeStatus) {
        this.orderTradeStatus = orderTradeStatus;
    }

    public String getBizStatus() {
        return bizStatus;
    }

    public void setBizStatus(String bizStatus) {
        this.bizStatus = bizStatus;
    }

    public String getFrozenStatus() {
        return frozenStatus;
    }

    public void setFrozenStatus(String frozenStatus) {
        this.frozenStatus = frozenStatus;
    }

    public Integer getAuditType() {
        return auditType;
    }

    public void setAuditType(Integer auditType) {
        this.auditType = auditType;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getFreightAmount() {
        return freightAmount;
    }

    public void setFreightAmount(BigDecimal freightAmount) {
        this.freightAmount = freightAmount;
    }

    public BigDecimal getPlatformDiscountAmount() {
        return platformDiscountAmount;
    }

    public void setPlatformDiscountAmount(BigDecimal platformDiscountAmount) {
        this.platformDiscountAmount = platformDiscountAmount;
    }

    public BigDecimal getShopDiscountAmount() {
        return shopDiscountAmount;
    }

    public void setShopDiscountAmount(BigDecimal shopDiscountAmount) {
        this.shopDiscountAmount = shopDiscountAmount;
    }

    public Integer getIntegral() {
        return integral;
    }

    public void setIntegral(Integer integral) {
        this.integral = integral;
    }

    public Integer getPointCoupon() {
        return pointCoupon;
    }

    public void setPointCoupon(Integer pointCoupon) {
        this.pointCoupon = pointCoupon;
    }

    public String getAmountDetail() {
        return amountDetail;
    }

    public void setAmountDetail(String amountDetail) {
        this.amountDetail = amountDetail;
    }

    public String getSaleChannel() {
        return saleChannel;
    }

    public void setSaleChannel(String saleChannel) {
        this.saleChannel = saleChannel;
    }

    public String getMktChannel() {
        return mktChannel;
    }

    public void setMktChannel(String mktChannel) {
        this.mktChannel = mktChannel;
    }

    public Integer getTotalItemNum() {
        return totalItemNum;
    }

    public void setTotalItemNum(Integer totalItemNum) {
        this.totalItemNum = totalItemNum;
    }

    public String getBuyerRemark() {
        return buyerRemark;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public String getSellerRemark() {
        return sellerRemark;
    }

    public void setSellerRemark(String sellerRemark) {
        this.sellerRemark = sellerRemark;
    }

    public Date getPlaceTime() {
        return placeTime;
    }

    public void setPlaceTime(Date placeTime) {
        this.placeTime = placeTime;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }

    public String getCancelType() {
        return cancelType;
    }

    public void setCancelType(String cancelType) {
        this.cancelType = cancelType;
    }

    public Date getCancelTime() {
        return cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    public String getCancelDesc() {
        return cancelDesc;
    }

    public void setCancelDesc(String cancelDesc) {
        this.cancelDesc = cancelDesc;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public Integer getFreightPayer() {
        return freightPayer;
    }

    public void setFreightPayer(Integer freightPayer) {
        this.freightPayer = freightPayer;
    }

    public String getBuyerNickname() {
        return buyerNickname;
    }

    public void setBuyerNickname(String buyerNickname) {
        this.buyerNickname = buyerNickname;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getSellerNickname() {
        return sellerNickname;
    }

    public void setSellerNickname(String sellerNickname) {
        this.sellerNickname = sellerNickname;
    }

    public BigDecimal getAllAmount() {
        return allAmount;
    }

    public void setAllAmount(BigDecimal allAmount) {
        this.allAmount = allAmount;
    }

    public BigDecimal getDiscountMargin() {
        return discountMargin;
    }

    public void setDiscountMargin(BigDecimal discountMargin) {
        this.discountMargin = discountMargin;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Integer getIsSplit() {
        return isSplit;
    }

    public void setIsSplit(Integer isSplit) {
        this.isSplit = isSplit;
    }

    public Integer getHasDeliveryAddress() {
        return hasDeliveryAddress;
    }

    public void setHasDeliveryAddress(Integer hasDeliveryAddress) {
        this.hasDeliveryAddress = hasDeliveryAddress;
    }

    public Integer getIsUrgent() {
        return isUrgent;
    }

    public void setIsUrgent(Integer isUrgent) {
        this.isUrgent = isUrgent;
    }

    public Integer getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(Integer invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }

    public void setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Long getItemShareId() {
        return itemShareId;
    }

    public void setItemShareId(Long itemShareId) {
        this.itemShareId = itemShareId;
    }

    public Integer getCashOnDelivery() {
        return cashOnDelivery;
    }

    public void setCashOnDelivery(Integer cashOnDelivery) {
        this.cashOnDelivery = cashOnDelivery;
    }

    public String getSaleChannelOrderNo() {
        return saleChannelOrderNo;
    }

    public void setSaleChannelOrderNo(String saleChannelOrderNo) {
        this.saleChannelOrderNo = saleChannelOrderNo;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getIsReturn() {
        return isReturn;
    }

    public void setIsReturn(Integer isReturn) {
        this.isReturn = isReturn;
    }

    /**
     * 判断是否使用了优惠券
     *
     * @return true : 使用了优惠券 , false : 没有使用
     */
    public boolean checkCouponUse() {
        return (discountAmount != null && discountAmount.compareTo(BigDecimal.ZERO) > 0)
                || (platformDiscountAmount != null && platformDiscountAmount.compareTo(BigDecimal.ZERO) > 0)
                || (shopDiscountAmount != null && shopDiscountAmount.compareTo(BigDecimal.ZERO) > 0);

    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Integer getShopBusinessForm() {
        return shopBusinessForm;
    }

    public void setShopBusinessForm(Integer shopBusinessForm) {
        this.shopBusinessForm = shopBusinessForm;
    }

    public String getOrderTags() {
        return orderTags;
    }

    public void setOrderTags(String orderTags) {
        this.orderTags = orderTags;
    }
}