/*
 * @(#)OrderInvoiceEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 订单发票 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_order_invoice")
public class StdOrderInvoiceEo extends CubeBaseEo {
    public static StdOrderInvoiceEo newInstance() {
        return (StdOrderInvoiceEo) BaseEo.newInstance(StdOrderInvoiceEo.class);
    }

    /**
     * 发票流水
     */
    @Column(name = "invoice_no")
    private String invoiceNo;
    /**
     * 外部发票来源
     * 支付订单, 交易订单,或支付主订单
     */
    @Column(name = "extl_invoice_src")
    private String extlInvoiceSrc;
    /**
     * 外部发票来源流水号
     */
    @Column(name = "extl_invoice_src_serial")
    private String extlInvoiceSrcSerial;
    /**
     * 外部发票来源详情
     * json结构,支持扩展其他信息
     */
    @Column(name = "extl_src_detail")
    private String extlSrcDetail;
    /**
     * 外部发票详情
     * json 结构,支持其他信息.
     */
    @Column(name = "extl_invoice_detail")
    private String extlInvoiceDetail;
    /**
     * 发票类型（1普通发票，2电子发票）
     */
    @Column(name = "invoice_type")
    private Integer invoiceType;
    /**
     * 发票抬头类型（1个人，2单位）
     */
    @Column(name = "invoice_title_type")
    private Integer invoiceTitleType;
    /**
     * 发票形式 1 增值税普通发票 2 增值税专用发票
     */
    @Column(name = "invoice_tax_type")
    private Integer invoiceTaxType;
    /**
     * 发票抬头
     */
    @Column(name = "invoice_title")
    private String invoiceTitle;
    /**
     * 电子发票收票人手机号码
     */
    @Column(name = "receiver_phone")
    private String receiverPhone;
    /**
     * 电子发票收票人邮箱
     */
    @Column(name = "receiver_email")
    private String receiverEmail;
    /**
     * 单位名称
     */
    @Column(name = "org_name")
    private String orgName;
    /**
     * 纳税人识别码
     */
    @Column(name = "tax_code")
    private String taxCode;
    /**
     * 单位注册地址
     * 注册地址
     */
    @Column(name = "register_address")
    private String registerAddress;
    /**
     * 单位注册电话
     * 注册电话
     */
    @Column(name = "register_phone")
    private String registerPhone;
    /**
     * 单位银行账号
     * 银行账号
     */
    @Column(name = "bank_account")
    private String bankAccount;
    /**
     * 单位开户银行
     * 开户银行
     */
    @Column(name = "open_bank")
    private String openBank;
    /**
     * 发票内容类型（1明细，2办公用品-附购物清单））
     */
    @Column(name = "invoice_content_type")
    private Integer invoiceContentType;
    /**
     * 发票内容
     */
    @Column(name = "invoice_content")
    private String invoiceContent;
    /**
     * 是否已生成发票
     * 是否生成发票 1生成  0 未生成
     */
    @Column(name = "is_generated")
    private Integer isGenerated;
    /**
     * 电子发票url
     */
    @Column(name = "invoice_url")
    private String invoiceUrl;
    /**
     * 发票回调信息
     */
    @Column(name = "invoice_response_data")
    private String invoiceResponseData;
    /**
     * 发票详情
     */
    @Column(name = "invoice_detail")
    private String invoiceDetail;

    public String getInvoiceNo() {
        return this.invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getExtlInvoiceSrc() {
        return this.extlInvoiceSrc;
    }

    public void setExtlInvoiceSrc(String extlInvoiceSrc) {
        this.extlInvoiceSrc = extlInvoiceSrc;
    }

    public String getExtlInvoiceSrcSerial() {
        return this.extlInvoiceSrcSerial;
    }

    public void setExtlInvoiceSrcSerial(String extlInvoiceSrcSerial) {
        this.extlInvoiceSrcSerial = extlInvoiceSrcSerial;
    }

    public String getExtlSrcDetail() {
        return this.extlSrcDetail;
    }

    public void setExtlSrcDetail(String extlSrcDetail) {
        this.extlSrcDetail = extlSrcDetail;
    }

    public String getExtlInvoiceDetail() {
        return this.extlInvoiceDetail;
    }

    public void setExtlInvoiceDetail(String extlInvoiceDetail) {
        this.extlInvoiceDetail = extlInvoiceDetail;
    }

    public Integer getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Integer getInvoiceTitleType() {
        return this.invoiceTitleType;
    }

    public void setInvoiceTitleType(Integer invoiceTitleType) {
        this.invoiceTitleType = invoiceTitleType;
    }

    public Integer getInvoiceTaxType() {
        return this.invoiceTaxType;
    }

    public void setInvoiceTaxType(Integer invoiceTaxType) {
        this.invoiceTaxType = invoiceTaxType;
    }

    public String getInvoiceTitle() {
        return this.invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getReceiverPhone() {
        return this.receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public String getReceiverEmail() {
        return this.receiverEmail;
    }

    public void setReceiverEmail(String receiverEmail) {
        this.receiverEmail = receiverEmail;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public String getRegisterAddress() {
        return this.registerAddress;
    }

    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress;
    }

    public String getRegisterPhone() {
        return this.registerPhone;
    }

    public void setRegisterPhone(String registerPhone) {
        this.registerPhone = registerPhone;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getOpenBank() {
        return this.openBank;
    }

    public void setOpenBank(String openBank) {
        this.openBank = openBank;
    }

    public Integer getInvoiceContentType() {
        return this.invoiceContentType;
    }

    public void setInvoiceContentType(Integer invoiceContentType) {
        this.invoiceContentType = invoiceContentType;
    }

    public String getInvoiceContent() {
        return this.invoiceContent;
    }

    public void setInvoiceContent(String invoiceContent) {
        this.invoiceContent = invoiceContent;
    }

    public Integer getIsGenerated() {
        return this.isGenerated;
    }

    public void setIsGenerated(Integer isGenerated) {
        this.isGenerated = isGenerated;
    }

    public String getInvoiceUrl() {
        return this.invoiceUrl;
    }

    public void setInvoiceUrl(String invoiceUrl) {
        this.invoiceUrl = invoiceUrl;
    }

    public String getInvoiceResponseData() {
        return this.invoiceResponseData;
    }

    public void setInvoiceResponseData(String invoiceResponseData) {
        this.invoiceResponseData = invoiceResponseData;
    }

    public String getInvoiceDetail() {
        return this.invoiceDetail;
    }

    public void setInvoiceDetail(String invoiceDetail) {
        this.invoiceDetail = invoiceDetail;
    }


}