/**
 * @(#) StdOrderVerifyCodeEo.java 1.0 2019-05-08
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;


import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 订单虚拟商品校验码/核销码/凭证码
 *
 * @author 仪琳
 * @since 1.0.0
 */

@Table(name = "tr_order_proof")
public class StdOrderProofEo extends CubeBaseEo {
    /**
     * 订单编号
     */
    @Column(name = "order_no")
    private String orderNo;

    /**
     * 交易号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 退款交易号
     */
    @Column(name = "return_trade_no")
    private String returnTradeNo;

    /**
     * 交易商品ID
     */
    @Column(name = "trade_item_id")
    private Long tradeItemId;

    /**
     * 核销码
     */
    @Column(name = "code")
    private String code;

    /**
     * 手机号
     */
    @Column(name = "phone")
    private String phone;

    /**
     * 有效的起始时间
     */
    @Column(name = "effective_start_time")
    private Date effectiveStartTime;

    /**
     * 有效的结束时间
     */
    @Column(name = "effective_end_time")
    private Date effectiveEndTime;

    /**
     * 退货类型(1不能退货 2手动退货 3过期自动退货)
     */
    @Column(name = "return_type")
    private Integer returnType;

    /**
     * 允许退款时间点(该时间点后不允许再退款)
     */
    @Column(name = "allow_return_time")
    private Date allowReturnTime;

    /**
     * 状态(1待使用 2已使用 3已退货 4禁用)
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 使用类型(1商品 2订单)
     */
    @Column(name = "use_type")
    private Integer useType;

    /**
     * 使用时间/核销时间
     */
    @Column(name = "usage_time")
    private Date usageTime;

    /**
     * 使用人员/核销人员
     */
    @Column(name = "user")
    private String user;

    /**
     * 使用规则/核销类型(1核销码 2订单号+核销码 3手机号+核销码)
     */
    @Column(name = "usage_rules")
    private Integer usageRules;

    /**
     * 去向系统
     */
    @Column(name = "target_system")
    private String targetSystem;

    /**
     * 去向终端
     */
    @Column(name = "target_terminal")
    private String targetTerminal;

    /**
     * 去向流水
     */
    @Column(name = "target_serial")
    private String targetSerial;

    /**
     * 退款原因
     */
    @Column(name = "return_reason")
    private String returnReason;

    /**
     * 地址
     */
    @Column(name = "url")
    private String url;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getReturnTradeNo() {
        return returnTradeNo;
    }

    public void setReturnTradeNo(String returnTradeNo) {
        this.returnTradeNo = returnTradeNo;
    }

    public Long getTradeItemId() {
        return tradeItemId;
    }

    public void setTradeItemId(Long tradeItemId) {
        this.tradeItemId = tradeItemId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Date getEffectiveStartTime() {
        return effectiveStartTime;
    }

    public void setEffectiveStartTime(Date effectiveStartTime) {
        this.effectiveStartTime = effectiveStartTime;
    }

    public Date getEffectiveEndTime() {
        return effectiveEndTime;
    }

    public void setEffectiveEndTime(Date effectiveEndTime) {
        this.effectiveEndTime = effectiveEndTime;
    }

    public Integer getReturnType() {
        return returnType;
    }

    public void setReturnType(Integer returnType) {
        this.returnType = returnType;
    }

    public Date getAllowReturnTime() {
        return allowReturnTime;
    }

    public void setAllowReturnTime(Date allowReturnTime) {
        this.allowReturnTime = allowReturnTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getUseType() {
        return useType;
    }

    public void setUseType(Integer useType) {
        this.useType = useType;
    }

    public Date getUsageTime() {
        return usageTime;
    }

    public void setUsageTime(Date usageTime) {
        this.usageTime = usageTime;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Integer getUsageRules() {
        return usageRules;
    }

    public void setUsageRules(Integer usageRules) {
        this.usageRules = usageRules;
    }

    public String getTargetSystem() {
        return targetSystem;
    }

    public void setTargetSystem(String targetSystem) {
        this.targetSystem = targetSystem;
    }

    public String getTargetTerminal() {
        return targetTerminal;
    }

    public void setTargetTerminal(String targetTerminal) {
        this.targetTerminal = targetTerminal;
    }

    public String getTargetSerial() {
        return targetSerial;
    }

    public void setTargetSerial(String targetSerial) {
        this.targetSerial = targetSerial;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
