/*
 * @(#)PackageItemEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_package_item")
public class StdPackageItemEo extends CubeBaseEo {
    public static StdPackageItemEo newInstance() {
        return (StdPackageItemEo) BaseEo.newInstance(StdPackageItemEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 所属发货记录流水号
     */
    @Column(name = "delivery_no")
    private String deliveryNo;
    /**
     * 订单商品明细id
     */
    @Column(name = "tr_order_item_no")
    private String trOrderItemNo;
    /**
     * 发货类型
     * 普通发送,发补发, 换货重发
     */
    @Column(name = "delivery_type")
    private String deliveryType;
    /**
     * 发货小类
     * 比如补发 ,可以是漏发的补发,  损坏的补发,
     * 一般可不使用
     */
    @Column(name = "delivery_sub_type")
    private String deliverySubType;
    /**
     * 商品来源系统
     */
    @Column(name = "item_src")
    private String itemSrc;
    /**
     * 实发skuId
     * 满足货品替换的场景, 比如买了5个散装, 用5连包替换.
     */
    @Column(name = "actual_sku_serial")
    private String actualSkuSerial;
    /**
     * 实发sku数量
     * 这里存实际sku的发货数量, 可以为0
     */
    @Column(name = "actual_delivery_sku_num")
    private Integer actualDeliverySkuNum;
    /**
     * 实际的sku对应的应发货数量,如 应发 5瓶酒, 实际发一箱, 可对应5瓶
     * 通过跟库存系统的对接发现发货数量不对应,可以在这个字段修改
     * 默认取应发货数量的值
     */
    @Column(name = "actual_delivery_num")
    private Integer actualDeliveryNum;
    /**
     * 配送系统
     */
    @Column(name = "package_src")
    private String packageSrc;
    /**
     * 配送系统流水号
     */
    @Column(name = "package_serial")
    private String packageSerial;
    /**
     * 物流公司
     */
    @Column(name = "shipping_company")
    private String shippingCompany;
    /**
     * 物流公司编码
     */
    @Column(name = "shipping_company_code")
    private String shippingCompanyCode;

    /**
     * 物流公司运单号
     */
    @Column(name = "shipping_serial")
    private String shippingSerial;

    /**
     * 货品id
     */
    @Column(name = "cargo_serial")
    private String cargoSerial;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getDeliveryNo() {
        return this.deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getTrOrderItemNo() {
        return this.trOrderItemNo;
    }

    public void setTrOrderItemNo(String trOrderItemNo) {
        this.trOrderItemNo = trOrderItemNo;
    }

    public String getDeliveryType() {
        return this.deliveryType;
    }

    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getDeliverySubType() {
        return this.deliverySubType;
    }

    public void setDeliverySubType(String deliverySubType) {
        this.deliverySubType = deliverySubType;
    }

    public String getItemSrc() {
        return this.itemSrc;
    }

    public void setItemSrc(String itemSrc) {
        this.itemSrc = itemSrc;
    }

    public String getActualSkuSerial() {
        return this.actualSkuSerial;
    }

    public void setActualSkuSerial(String actualSkuSerial) {
        this.actualSkuSerial = actualSkuSerial;
    }

    public Integer getActualDeliverySkuNum() {
        return this.actualDeliverySkuNum;
    }

    public void setActualDeliverySkuNum(Integer actualDeliverySkuNum) {
        this.actualDeliverySkuNum = actualDeliverySkuNum;
    }

    public Integer getActualDeliveryNum() {
        return this.actualDeliveryNum;
    }

    public void setActualDeliveryNum(Integer actualDeliveryNum) {
        this.actualDeliveryNum = actualDeliveryNum;
    }

    public String getPackageSrc() {
        return this.packageSrc;
    }

    public void setPackageSrc(String packageSrc) {
        this.packageSrc = packageSrc;
    }

    public String getPackageSerial() {
        return this.packageSerial;
    }

    public void setPackageSerial(String packageSerial) {
        this.packageSerial = packageSerial;
    }

    public String getShippingCompany() {
        return this.shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getShippingSerial() {
        return this.shippingSerial;
    }

    public void setShippingSerial(String shippingSerial) {
        this.shippingSerial = shippingSerial;
    }


    public String getCargoSerial() {
        return this.cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }
    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }
}