/*
 * @(#)PayRecordEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.enhance.flow.StatusValueInfo;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.*;

/**
 * 支付订单 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_pay_record")
public class StdPayRecordEo extends CubeBaseEo implements IFlowEntity {
    public static StdPayRecordEo newInstance() {
        return (StdPayRecordEo) BaseEo.newInstance(StdPayRecordEo.class);
    }

    /**
     * 交易流水号(支付)
     */
    @Column(name = "trade_no")
    @Deprecated
    private String tradeNo;
    /**
     * 支付流水号
     */
    @LogicColumn
    @Column(name = "pay_no")
    private String payNo;
    /**
     * 支付方式,mix表示多种支付方式混合,需要关联子订单查询
     */
    @Column(name = "pay_method")
    private String payMethod;
    /**
     * 支付金额, 如果是积分支付,则为扣除的积分
     */
    @Column(name = "pay_amount")
    private BigDecimal payAmount;

    /**
     * 积分支付时扣除的积分数
     */
    @Column(name = "integral")
    private Integer integral;

    /**
     * 退款金额
     */
    @Column(name = "refund_amount")
    private BigDecimal refundAmount;
    /**
     * 用户来源系统
     */
    @Column(name = "user_src")
    private String userSrc;
    /**
     * 付款用户ID
     * 跟用户来源系统联合作为业务主键
     */
    @Column(name = "user_id")
    private String userId;
    /**
     * 状态
     * INIT: 初始化
     * SETTED: 已选择支付方式
     * ACCEPTED: 支付渠道已受理
     * SUCC: 支付成功
     * FAIL: 支付失败
     */
    @Column(name = "pay_status")
    private String payStatus;
    /**
     * 支付发起时间
     */
    @Column(name = "pay_start_time")
    private Date payStartTime;
    /**
     * 支付渠道受理时间
     */
    @Column(name = "pay_accept_time")
    private Date payAcceptTime;
    /**
     * 是否代付0 否 1 是 默认是 0 不用tr_order.user_id 和 tr_pay.user_id是为了兼容可以自己给自己代付
     */
    @Column(name = "is_agent")
    private Integer isAgent;


    /**
     * 支付完成时间
     */
    @Column(name = "pay_finish_time")
    private Date payFinishTime;
    /**
     * 取消方式: 0: 未取消,buyer_cancle: 买家取消,seller_cancle:卖家取消
     */
    @Column(name = "cancel_type")
    private String cancelType;
    /**
     * 取消完成的时间
     */
    @Column(name = "cancel_time")
    private Date cancelTime;

    /**
     * ${item.comment}
     */
    @Column(name = "cancel_desc")
    private String cancelDesc;

    /**
     * 支付系统流水号
     */
    @Column(name = "extl_pay_serial")
    private String extlPaySerial;
    /**
     * 支付系统来源
     */
    @Column(name = "extl_pay_src")
    private String extlPaySrc;
    /**
     * 支付系统账户
     */
    @Column(name = "extl_pay_account")
    private String extlPayAccount;

    /**
     * 支付流水号
     */
    @Column(name = "parent_pay_no")
    private String parentPayNo;

    /**
     * 会员id
     */
    @Column(name = "member_id")
    private Long memberId;
    /**
     * 商家id
     */
    @Column(name = "seller_id")
    private String sellerId;


//    /**
//     * 支付单业务状态
//     */
//    @Column(name = "biz_status")
//    private String bizStatus;

    /**
     * 单据使用的流程
     */
    @Column(name = "flow_def_id")
    private Long flowDefId;

    /**
     * 对应的订单号, 如果是多个,用半角逗号分隔
     */
    @Column(name = "order_no")
    private String orderNo;

    /**
     *卡号
     */
    @Column(name = "card_no")
    private String cardNo;

    /**
     *行号
     */
    @Column(name = "line_num")
    private String lineNum;

    /**
     *门店代码
     */
    @Column(name = "shop_code")
    private String shopCode;

    /**
     * 终端来源类型
     */
    @Column(name = "device_type")
    private String deviceType;


    private static Map<String, StatusValueInfo> STATUS_PROP_DESC = new HashMap<>();

    static {
        STATUS_PROP_DESC.put("payStatus", StatusValueInfo.generate("支付状态"));
    }


    @Override
    public String getEntityName() {
        return "支付单";
    }

    @Override
    public Long getFlowDefId() {
        return flowDefId;
    }

    @Override
    public void setFlowDefId(Long flowDefId) {
        this.flowDefId = flowDefId;
    }

    @Override
    public Map<String, StatusValueInfo> getStatusDesc() {
        return STATUS_PROP_DESC;
    }

    @Override
    public String getStatus(String statusField) {
//        if("bizStatus".equals(statusField)){
//            return bizStatus;
//        }else {
            return payStatus;
//        }
        /*if ("orderStatus".equals(statusField)) {
            return orderStatus;
        } else if ("bizStatus".equals(statusField)) {
            return bizStatus;
        } else if ("frozenStatus".equals(statusField)) {
            return frozenStatus;
        }
        return null;*/
    }

    @Override
    public void setStatus(String statusField, String newStatus) {
//        if("bizStatus".equals(statusField)){
//            this.bizStatus = newStatus;
//        }else {
            this.payStatus = newStatus;
//        }
        /*if ("orderStatus".equals(statusField)) {
            this.orderStatus = newStatus;
        } else if ("bizStatus".equals(statusField)) {
            this.bizStatus = newStatus;
        } else if ("frozenStatus".equals(statusField)) {
            this.frozenStatus = newStatus;
        }*/
    }

    public List<String> readOrderNos() {
        if (StringUtils.isNotBlank(getOrderNo())) {
            if (getOrderNo().indexOf(",") > 0) {
                return Arrays.asList(getOrderNo().split(","));
            } else {
                return Collections.singletonList(getOrderNo());
            }
        } else {
            return null;
        }

    }

    public String getSellerId() {
        return sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    @Deprecated
    public String getTradeNo() {
        return this.tradeNo;
    }

    @Deprecated
    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getPayNo() {
        return this.payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public String getPayMethod() {
        return this.payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public BigDecimal getPayAmount() {
        return this.payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getUserSrc() {
        return this.userSrc;
    }

    public void setUserSrc(String userSrc) {
        this.userSrc = userSrc;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPayStatus() {
        return this.payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public Date getPayStartTime() {
        return this.payStartTime;
    }

    public void setPayStartTime(Date payStartTime) {
        this.payStartTime = payStartTime;
    }

    public Date getPayAcceptTime() {
        return this.payAcceptTime;
    }

    public void setPayAcceptTime(Date payAcceptTime) {
        this.payAcceptTime = payAcceptTime;
    }

    public Date getPayFinishTime() {
        return this.payFinishTime;
    }

    public void setPayFinishTime(Date payFinishTime) {
        this.payFinishTime = payFinishTime;
    }

    public String getCancelType() {
        return this.cancelType;
    }

    public void setCancelType(String cancelType) {
        this.cancelType = cancelType;
    }

    public Date getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    public String getCancelDesc() {
        return this.cancelDesc;
    }

    public void setCancelDesc(String cancelDesc) {
        this.cancelDesc = cancelDesc;
    }


    public String getExtlPaySerial() {
        return this.extlPaySerial;
    }

    public void setExtlPaySerial(String extlPaySerial) {
        this.extlPaySerial = extlPaySerial;
    }

    public String getExtlPaySrc() {
        return this.extlPaySrc;
    }

    public void setExtlPaySrc(String extlPaySrc) {
        this.extlPaySrc = extlPaySrc;
    }

    public String getExtlPayAccount() {
        return this.extlPayAccount;
    }

    public void setExtlPayAccount(String extlPayAccount) {
        this.extlPayAccount = extlPayAccount;
    }

    public String getParentPayNo() {
        return parentPayNo;
    }

    public Integer getIsAgent() {
        return isAgent;
    }

    public void setParentPayNo(String parentPayNo) {
        this.parentPayNo = parentPayNo;
    }

    public void setIsAgent(Integer isAgent) {
        this.isAgent = isAgent;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public StdPayRecordEo setOrderNo(String orderNo) {
        this.orderNo = orderNo;
        return this;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getLineNum() {
        return lineNum;
    }

    public void setLineNum(String lineNum) {
        this.lineNum = lineNum;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public Integer getIntegral() {
        return integral;
    }

    public void setIntegral(Integer integral) {
        this.integral = integral;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    //    public String getBizStatus() {
//        return bizStatus;
//    }
//
//    public void setBizStatus(String bizStatus) {
//        this.bizStatus = bizStatus;
//    }
}