/*
 * @(#)PickupCodeEo.java 1.0 2019-02-27
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 自提码 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_pickup_code")
public class StdPickupCodeEo extends CubeBaseEo {
    public static StdPickupCodeEo newInstance() {
        return (StdPickupCodeEo) BaseEo.newInstance(StdPickupCodeEo.class);
    }

    /**
     * 仓库id
     */
    @Column(name = "warehouse_serial")
    private String warehouseSerial;
    /**
     * 自提流水号
     */
    @Column(name = "pickup_record_no")
    private String pickupRecordNo;
    /**
     * 核销人
     */
    @Column(name = "check_person")
    private String checkPerson;
    /**
     * 核销/自提时间
     */
    @Column(name = "pickup_time")
    private Date pickupTime;
    /**
     * 自提码
     */
    @Column(name = "code")
    private String code;
    /**
     * 手机号
     */
    @Column(name = "phone")
    private String phone;
    /**
     * 状态 已生效 已自提 已失效
     */
    @Column(name = "status")
    private String status;
    /**
     * 有效截止时间
     */
    @Column(name = "valid_time")
    private Date validTime;

    public String getWarehouseSerial() {
        return this.warehouseSerial;
    }

    public void setWarehouseSerial(String warehouseSerial) {
        this.warehouseSerial = warehouseSerial;
    }

    public String getPickupRecordNo() {
        return this.pickupRecordNo;
    }

    public void setPickupRecordNo(String pickupRecordNo) {
        this.pickupRecordNo = pickupRecordNo;
    }

    public String getCheckPerson() {
        return this.checkPerson;
    }

    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }

    public Date getPickupTime() {
        return this.pickupTime;
    }

    public void setPickupTime(Date pickupTime) {
        this.pickupTime = pickupTime;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getValidTime() {
        return this.validTime;
    }

    public void setValidTime(Date validTime) {
        this.validTime = validTime;
    }


}