/*
 * @(#)PickupDetailEo.java 1.0 2019-02-27
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 自提明细 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_pickup_detail")
public class StdPickupDetailEo extends CubeBaseEo {
    public static StdPickupDetailEo newInstance() {
        return (StdPickupDetailEo) BaseEo.newInstance(StdPickupDetailEo.class);
    }

    /**
     * 状态 待自提 部分自提 已自提
     */
    @Column(name = "status")
    private String status;
    /**
     * 自提流水号
     */
    @Column(name = "pickup_record_no")
    private String pickupRecordNo;
    /**
     * 自提类型：订单order  包裹pack 商品 goods
     */
    @Column(name = "pickup_type")
    private String pickupType;
    /**
     * 核销/自提时间
     */
    @Column(name = "pickup_time")
    private Date pickupTime;
    /**
     * 配送系统
     */
    @Column(name = "package_src")
    private String packageSrc;
    /**
     * 配送系统流水号
     */
    @Column(name = "package_serial")
    private String packageSerial;
    /**
     * 实际提货数量
     */
    @Column(name = "actual_pickup_num")
    private Integer actualPickupNum;
    /**
     * 应该提货数量
     */
    @Column(name = "pickup_num")
    private Integer PickupNum;
    /**
     * 自提码id
     */
    @Column(name = "pickup_code_id")
    private Long pickupCodeId;
    /**
     * 货品id
     */
    @Column(name = "cargo_serial")
    private String cargoSerial;
    /**
     * 订单商品明细id
     */
    @Column(name = "tr_order_item_no")
    private String trOrderItemNo;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPickupRecordNo() {
        return this.pickupRecordNo;
    }

    public void setPickupRecordNo(String pickupRecordNo) {
        this.pickupRecordNo = pickupRecordNo;
    }

    public String getPickupType() {
        return this.pickupType;
    }

    public void setPickupType(String pickupType) {
        this.pickupType = pickupType;
    }

    public Date getPickupTime() {
        return this.pickupTime;
    }

    public void setPickupTime(Date pickupTime) {
        this.pickupTime = pickupTime;
    }

    public String getPackageSrc() {
        return this.packageSrc;
    }

    public void setPackageSrc(String packageSrc) {
        this.packageSrc = packageSrc;
    }

    public String getPackageSerial() {
        return this.packageSerial;
    }

    public void setPackageSerial(String packageSerial) {
        this.packageSerial = packageSerial;
    }

    public Integer getActualPickupNum() {
        return this.actualPickupNum;
    }

    public void setActualPickupNum(Integer actualPickupNum) {
        this.actualPickupNum = actualPickupNum;
    }

    public Long getPickupCodeId() {
        return this.pickupCodeId;
    }

    public void setPickupCodeId(Long pickupCodeId) {
        this.pickupCodeId = pickupCodeId;
    }

    public String getTrOrderItemNo() {
        return this.trOrderItemNo;
    }

    public void setTrOrderItemNo(String trOrderItemNo) {
        this.trOrderItemNo = trOrderItemNo;
    }

    public Integer getPickupNum() {
        return PickupNum;
    }

    public void setPickupNum(Integer pickupNum) {
        PickupNum = pickupNum;
    }

    public String getCargoSerial() {
        return cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }
}