/*
 * @(#)PickupRecordEo.java 1.0 2019-02-27
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 自提单 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_pickup_record")
public class StdPickupRecordEo extends CubeBaseEo {
    public static StdPickupRecordEo newInstance() {
        return (StdPickupRecordEo) BaseEo.newInstance(StdPickupRecordEo.class);
    }

    /**
     * 自提码交易号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 发货单号
     */
    @Column(name = "delivery_no")
    private String deliveryNo;
    /**
     * 仓库id
     */
    @Column(name = "warehouse_serial")
    private String warehouseSerial;
    /**
     * 自提类型：订单order  包裹package 商品 goods
     */
    @Column(name = "pickup_type")
    private String pickupType;
    /**
     * 自提关联类型的标识
     */
    @Column(name = "pickup_src")
    private String pickupSrc;
    /**
     * 核销/自提时间
     */
    @Column(name = "pickup_time")
    private Date pickupTime;
    /**
     * 自提流水号
     */
    @Column(name = "pickup_record_no")
    private String pickupRecordNo;
    /**
     * 状态 待自提 部分自提 自提完成
     */
    @Column(name = "status")
    private String status;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getDeliveryNo() {
        return this.deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getPickupType() {
        return this.pickupType;
    }

    public void setPickupType(String pickupType) {
        this.pickupType = pickupType;
    }

    public String getPickupSrc() {
        return this.pickupSrc;
    }

    public void setPickupSrc(String pickupSrc) {
        this.pickupSrc = pickupSrc;
    }

    public Date getPickupTime() {
        return this.pickupTime;
    }

    public void setPickupTime(Date pickupTime) {
        this.pickupTime = pickupTime;
    }

    public String getPickupRecordNo() {
        return this.pickupRecordNo;
    }

    public void setPickupRecordNo(String pickupRecordNo) {
        this.pickupRecordNo = pickupRecordNo;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getWarehouseSerial() {
        return warehouseSerial;
    }

    public void setWarehouseSerial(String warehouseSerial) {
        this.warehouseSerial = warehouseSerial;
    }
}