/*
 * @(#)TradeItemEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 异常单商品明细, 主交易记录可以直接关联 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_problem_trade_item")
public class StdProblemTradeItemEo extends CubeBaseEo {
    public static StdProblemTradeItemEo newInstance() {
        return (StdProblemTradeItemEo) BaseEo.newInstance(StdProblemTradeItemEo.class);
    }
    /**
     *  交易流水号
     订单中的 trade_no
     *
     */
    @Column(name = "trade_no")
    private String tradeNo;

    /**
     *  父订单号
     *
     */
    @Column(name = "parent_order_no")
    private String parentOrderNo;

    /**
     *  交易商品流水号
     业务唯一记录
     *
     */
    @Column(name = "trade_item_no")
    private String tradeItemNo;

    /**
     *  商品来源系统
     *
     */
    @Column(name = "item_src")
    private String itemSrc;

    /**
     *  类目ID
     *
     */
    @Column(name = "catalog_serial")
    private String catalogSerial;

    /**
     *  类目名
     *
     */
    @Column(name = "catalog_name")
    private String catalogName;

    @Column(name = "bus_type")
    private Integer busType;

    /**
     *  商品类型
     *
     */
    @Column(name = "item_type")
    private Integer itemType;

    /**
     *  品牌ID
     *
     */
    @Column(name = "brand_serial")
    private String brandSerial;

    /**
     *  商品ID
     *
     */
    @Column(name = "item_serial")
    private String itemSerial;

    /**
     *  商品编码
     *
     */
    @Column(name = "item_code")
    private String itemCode;

    /**
     *  商品版本
     *
     */
    @Column(name = "item_ver")
    private String itemVer;

    /**
     *  店铺类型
     online: 店铺
     offline: 门店
     *
     */
    @Column(name = "shop_type")
    private String shopType;

    /**
     *  店铺ID
     *
     */
    @Column(name = "shop_id")
    private String shopId;

    /**
     *  skuID
     库存规格ID
     *
     */
    @Column(name = "sku_serial")
    private String skuSerial;

    /**
     *  sku_code
     *
     */
    @Column(name = "sku_code")
    private String skuCode;

    /**
     *  规格名称
     *
     */
    @Column(name = "sku_name")
    private String skuName;

    /**
     *  第三方sdkID
     库存系统的外部SKU编码
     *
     */
    @Column(name = "third_sku_serial")
    private String thirdSkuSerial;

    /**
     *  货品来源系统
     *
     */
    @Column(name = "cargo_src")
    private String cargoSrc;

    /**
     *  库存系统的基础记录的编码
     *
     */
    @Column(name = "cargo_serial")
    private String cargoSerial;

    /**
     *  商品名称
     *
     */
    @Column(name = "item_name")
    private String itemName;

    /**
     *  商品数量
     *
     */
    @Column(name = "item_num")
    private Integer itemNum;

    /**
     *  价格类型
     0: 普通商品, 1:赠品
     *
     */
    @Column(name = "price_type")
    private Integer priceType;

    /**
     *  折扣率
     *
     */
    @Column(name = "discount_rate")
    private BigDecimal discountRate;

    /**
     *  商品实付单价
     实际每个商品用户要支付的价格
     其他价格一律商品详情.
     *
     */
    @Column(name = "item_price")
    private BigDecimal itemPrice;

    /**
     *  使用积分
     *
     */
    @Column(name = "integral")
    private Integer integral;

    /**
     *  是否需要路由，1代表是，0代表否
     *
     */
    @Column(name = "need_route")
    private Integer needRoute;

    /**
     *  行号
     *
     */
    @Column(name = "line_num")
    private Integer lineNum;

    /**
     *  备注
     *
     */
    @Column(name = "remark")
    private String remark;

    /**
     *  店铺优惠折扣金额
     *
     */
    @Column(name = "shop_discount_price")
    private BigDecimal shopDiscountPrice;

    /**
     *  平台优惠折扣金额
     *
     */
    @Column(name = "platform_discount_price")
    private BigDecimal platformDiscountPrice;

    /**
     *  实际金额小计
     金额小计
     *
     */
    @Column(name = "pay_total_amount")
    private BigDecimal payTotalAmount;

    @Column(name = "discount_total_amount")
    private BigDecimal discountTotalAmount;

    /**
     *  规格描述
     *
     */
    @Column(name = "sku_desc")
    private String skuDesc;

    /**
     *  实付是否包含折扣
     默认没有
     *
     */
    @Column(name = "discounted")
    private Integer discounted;

    /**
     *  是否无理由退货
     *
     */
    @Column(name = "is_not_condition")
    private Integer isNotCondition;

    /**
     *  json结构的商品详情记录,支持扩展
     *
     */
    @Column(name = "item_detail")
    private String itemDetail;

    /**
     *  商品应付单价
     *
     */
    @Column(name = "item_orig_price")
    private BigDecimal itemOrigPrice;

    /**
     *  商品运费金额
     *
     */
    @Column(name = "freight_amount")
    private BigDecimal freightAmount;

    /**
     * 是否周期够商品
     */
    @Column(name = "cycle_buy", columnDefinition = "tinyint(2) default 0")
    private Boolean cycleBuy;


    /**
     * 配送周期类型(0 按天 1 按周 2 按月)
     */
    @Column(name = "cycle_type")
    private Integer cycleType;

    /**
     * 配送周期
     *
     * 按天(1 每天送, 2 隔天送, 3 隔2天送,  4 隔3天送, 5 工作日每天送, 6 周末每天送)；
     * 按周(从周一到周日分别对应1-7), 存在多个值逗号隔开；
     * 按月 (从1号到28号分别对应1-28, 0表示每月最后一天), 存在多个值逗号隔开
     */
    @Column(name = "cycle_value")
    private String cycleValue;


    /**
     * 总期数
     */
    @Column(name = "total_cycle_count")
    private Integer totalCycleCount;

    /**
     * 初始化周期开始时间
     */
    @Column(name = "init_cycle_start")
    private Date initCycleStart;

    /**
     * 周期开始日期
     */
    @Column(name = "cycle_start")
    private Date cycleStart;

    /**
     * 周期结束日期
     */
    @Column(name = "cycle_end")
    private Date cycleEnd;

    /**
     * 每期配送商品数量
     */
    @Column(name = "cycle_item_num")
    private Integer cycleItemNum;

    /**
     * 已完成配送商品数量
     */
    @Column(name = "complete_delivery_num")
    private Integer completeDeliveryNum;

    /**
     * 赠品：1是，0否
     */
    @Column(name = "gift")
    private Integer gift;

    @Column(name = "user_id")
    private String userId;

    /**
     * 商品分销者ID
     */
    @Column(name = "share_user_id")
    private Long shareUserId;

    /**
     * 商品分销人姓名
     */
    @Column(name = "share_user_name")
    private String shareUserName;

    /**
     * 商品分销人手机号
     */
    @Column(name = "share_user_mobile")
    private String shareUserMobile;

    /**
     * 分销级别: 0 商品 1 店铺 2 商城
     */
    @Column(name = "distribution_range")
    private Integer distributionRange;

    /**
     * 商品分销信息
     */
    @Column(name = "distribution_info")
    private String distributionInfo;

    /**
     * 赠送的积分
     */
    @Column(name = "present_point")
    private Integer presentPoint;

    public Integer getDistributionRange() {
        return distributionRange;
    }

    public void setDistributionRange(Integer distributionRange) {
        this.distributionRange = distributionRange;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getTradeItemNo() {
        return tradeItemNo;
    }

    public void setTradeItemNo(String tradeItemNo) {
        this.tradeItemNo = tradeItemNo;
    }

    public String getItemSrc() {
        return itemSrc;
    }

    public void setItemSrc(String itemSrc) {
        this.itemSrc = itemSrc;
    }

    public String getCatalogSerial() {
        return catalogSerial;
    }

    public void setCatalogSerial(String catalogSerial) {
        this.catalogSerial = catalogSerial;
    }

    public String getCatalogName() {
        return catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public String getBrandSerial() {
        return brandSerial;
    }

    public void setBrandSerial(String brandSerial) {
        this.brandSerial = brandSerial;
    }

    public String getItemSerial() {
        return itemSerial;
    }

    public void setItemSerial(String itemSerial) {
        this.itemSerial = itemSerial;
    }

    public String getItemVer() {
        return itemVer;
    }

    public void setItemVer(String itemVer) {
        this.itemVer = itemVer;
    }

    public String getShopType() {
        return shopType;
    }

    public void setShopType(String shopType) {
        this.shopType = shopType;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getSkuSerial() {
        return skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getThirdSkuSerial() {
        return thirdSkuSerial;
    }

    public void setThirdSkuSerial(String thirdSkuSerial) {
        this.thirdSkuSerial = thirdSkuSerial;
    }

    public String getCargoSrc() {
        return cargoSrc;
    }

    public void setCargoSrc(String cargoSrc) {
        this.cargoSrc = cargoSrc;
    }

    public String getCargoSerial() {
        return cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public Integer getPriceType() {
        return priceType;
    }

    public void setPriceType(Integer priceType) {
        this.priceType = priceType;
    }

    public BigDecimal getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public Integer getIntegral() {
        return integral;
    }

    public void setIntegral(Integer integral) {
        this.integral = integral;
    }

    public Integer getNeedRoute() {
        return needRoute;
    }

    public void setNeedRoute(Integer needRoute) {
        this.needRoute = needRoute;
    }

    public Integer getLineNum() {
        return lineNum;
    }

    public void setLineNum(Integer lineNum) {
        this.lineNum = lineNum;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getShopDiscountPrice() {
        return shopDiscountPrice;
    }

    public void setShopDiscountPrice(BigDecimal shopDiscountPrice) {
        this.shopDiscountPrice = shopDiscountPrice;
    }

    public BigDecimal getPlatformDiscountPrice() {
        return platformDiscountPrice;
    }

    public void setPlatformDiscountPrice(BigDecimal platformDiscountPrice) {
        this.platformDiscountPrice = platformDiscountPrice;
    }

    public BigDecimal getPayTotalAmount() {
        return payTotalAmount;
    }

    public void setPayTotalAmount(BigDecimal payTotalAmount) {
        this.payTotalAmount = payTotalAmount;
    }

    public String getSkuDesc() {
        return skuDesc;
    }

    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }

    public Integer getDiscounted() {
        return discounted;
    }

    public void setDiscounted(Integer discounted) {
        this.discounted = discounted;
    }

    public Integer getIsNotCondition() {
        return isNotCondition;
    }

    public void setIsNotCondition(Integer isNotCondition) {
        this.isNotCondition = isNotCondition;
    }

    public String getItemDetail() {
        return itemDetail;
    }

    public void setItemDetail(String itemDetail) {
        this.itemDetail = itemDetail;
    }

    public BigDecimal getItemOrigPrice() {
        return itemOrigPrice;
    }

    public void setItemOrigPrice(BigDecimal itemOrigPrice) {
        this.itemOrigPrice = itemOrigPrice;
    }

    public BigDecimal getFreightAmount() {
        return freightAmount;
    }

    public void setFreightAmount(BigDecimal freightAmount) {
        this.freightAmount = freightAmount;
    }

    public String getParentOrderNo() {
        return parentOrderNo;
    }

    public void setParentOrderNo(String parentOrderNo) {
        this.parentOrderNo = parentOrderNo;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Boolean getCycleBuy() {
        return cycleBuy;
    }

    public void setCycleBuy(Boolean cycleBuy) {
        this.cycleBuy = cycleBuy;
    }

    public Integer getTotalCycleCount() {
        return totalCycleCount;
    }

    public void setTotalCycleCount(Integer totalCycleCount) {
        this.totalCycleCount = totalCycleCount;
    }

    public Integer getCycleType() {
        return cycleType;
    }

    public void setCycleType(Integer cycleType) {
        this.cycleType = cycleType;
    }

    public String getCycleValue() {
        return cycleValue;
    }

    public void setCycleValue(String cycleValue) {
        this.cycleValue = cycleValue;
    }

    public Date getInitCycleStart() {
        return initCycleStart;
    }

    public void setInitCycleStart(Date initCycleStart) {
        this.initCycleStart = initCycleStart;
    }

    public Date getCycleStart() {
        return cycleStart;
    }

    public void setCycleStart(Date cycleStart) {
        this.cycleStart = cycleStart;
    }

    public Date getCycleEnd() {
        return cycleEnd;
    }

    public void setCycleEnd(Date cycleEnd) {
        this.cycleEnd = cycleEnd;
    }

    public Integer getCycleItemNum() {
        return cycleItemNum;
    }

    public void setCycleItemNum(Integer cycleItemNum) {
        this.cycleItemNum = cycleItemNum;
    }

    public Integer getCompleteDeliveryNum() {
        return completeDeliveryNum;
    }

    public void setCompleteDeliveryNum(Integer completeDeliveryNum) {
        this.completeDeliveryNum = completeDeliveryNum;
    }

    public Integer getGift() {
        return gift;
    }

    public void setGift(Integer gift) {
        this.gift = gift;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public BigDecimal getDiscountTotalAmount() {
        return discountTotalAmount;
    }

    public void setDiscountTotalAmount(BigDecimal discountTotalAmount) {
        this.discountTotalAmount = discountTotalAmount;
    }

    public Long getShareUserId() {
        return shareUserId;
    }

    public void setShareUserId(Long shareUserId) {
        this.shareUserId = shareUserId;
    }

    public String getShareUserName() {
        return shareUserName;
    }

    public void setShareUserName(String shareUserName) {
        this.shareUserName = shareUserName;
    }

    public String getShareUserMobile() {
        return shareUserMobile;
    }

    public void setShareUserMobile(String shareUserMobile) {
        this.shareUserMobile = shareUserMobile;
    }

    public String getDistributionInfo() {
        return distributionInfo;
    }

    public void setDistributionInfo(String distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    public Integer getPresentPoint() {
        return presentPoint;
    }

    public void setPresentPoint(Integer presentPoint) {
        this.presentPoint = presentPoint;
    }
}