package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 对账渠道订单记录表Eo对象
 *
 * @author 妙才
 * @since 2021-01-21
 */
@Table(name = "tr_reconciliation_order_record")
public class StdReconciliationOrderRecordEo extends CubeBaseEo {

    /**
     * 店铺ID
     */
    @Column(name = "shop_code")
    private String shopCode;
    /**
     * 对账渠道编码
     */
    @Column(name = "channel_code")
    private String channelCode;
    /**
     * 商户订单号
     */
    @Column(name = "merchant_order_no")
    private String merchantOrderNo;
    /**
     * 对账渠道名称
     */
    @Column(name = "channel_name")
    private String channelName;
    /**
     * 订单类型
     */
    @Column(name = "order_type")
    private Integer orderType;
    /**
     * 店铺名称
     */
    @Column(name = "shop_name")
    private String shopName;
    /**
     * 渠道销售金额
     */
    @Column(name = "channel_sell_price")
    private BigDecimal channelSellPrice;
    /**
     * 渠道应付金额
     */
    @Column(name = "channel_pay_price")
    private BigDecimal channelPayPrice;
    /**
     * 渠道支付金额
     */
    @Column(name = "channel_actual_price")
    private BigDecimal channelActualPrice;
    /**
     * 渠道支出金额
     */
    @Column(name = "channel_paid_price")
    private BigDecimal channelPaidPrice;
    /**
     * 渠道服务费
     */
    @Column(name = "channel_fee")
    private BigDecimal channelFee;
    /**
     * 支付时间
     */
    @Column(name = "pay_time")
    private Date payTime;
    /**
     * 拉取时间
     */
    @Column(name = "pull_time")
    private Date pullTime;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setMerchantOrderNo(String merchantOrderNo) {
        this.merchantOrderNo = merchantOrderNo;
    }

    public String getMerchantOrderNo() {
        return this.merchantOrderNo;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
    }

    public Integer getOrderType() {
        return this.orderType;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopName() {
        return this.shopName;
    }

    public void setChannelSellPrice(BigDecimal channelSellPrice) {
        this.channelSellPrice = channelSellPrice;
    }

    public BigDecimal getChannelSellPrice() {
        return this.channelSellPrice;
    }

    public void setChannelPayPrice(BigDecimal channelPayPrice) {
        this.channelPayPrice = channelPayPrice;
    }

    public BigDecimal getChannelPayPrice() {
        return this.channelPayPrice;
    }

    public void setChannelActualPrice(BigDecimal channelActualPrice) {
        this.channelActualPrice = channelActualPrice;
    }

    public BigDecimal getChannelActualPrice() {
        return this.channelActualPrice;
    }

    public void setChannelFee(BigDecimal channelFee) {
        this.channelFee = channelFee;
    }

    public BigDecimal getChannelFee() {
        return this.channelFee;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Date getPayTime() {
        return this.payTime;
    }

    public void setPullTime(Date pullTime) {
        this.pullTime = pullTime;
    }

    public Date getPullTime() {
        return this.pullTime;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public BigDecimal getChannelPaidPrice() {
        return channelPaidPrice;
    }

    public void setChannelPaidPrice(BigDecimal channelPaidPrice) {
        this.channelPaidPrice = channelPaidPrice;
    }
}
