package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 对账任务表Eo对象
 *
 * @author 妙才
 * @since 2021-01-21
 */
@Table(name = "tr_reconciliation_task")
public class StdReconciliationTaskEo extends CubeBaseEo {

    /**
     * 任务编码
     */
    @Column(name = "code")
    private String code;
    /**
     * 对账渠道编码
     */
    @Column(name = "channel_code")
    private String channelCode;
    /**
     * 对账渠道名称
     */
    @Column(name = "channel_name")
    private String channelName;
    /**
     * 任务名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 任务类型
     */
    @Column(name = "task_type")
    private Integer taskType;
    /**
     * 对账文件名称
     */
    @Column(name = "import_file_name")
    private String importFileName;
    /**
     * 导入状态 (0: 正在导入 1: 成功 2: 失败)
     */
    @Column(name = "import_status")
    private Integer importStatus;
    /**
     * 对账文件url
     */
    @Column(name = "import_file_url")
    private String importFileUrl;
    /**
     * 对账结果
     */
    @Column(name = "reconciliation_result")
    private String reconciliationResult;
    /**
     * 上传人
     */
    @Column(name = "push_person")
    private String pushPerson;

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public void setImportFileName(String importFileName) {
        this.importFileName = importFileName;
    }

    public String getImportFileName() {
        return this.importFileName;
    }

    public void setImportStatus(Integer importStatus) {
        this.importStatus = importStatus;
    }

    public Integer getImportStatus() {
        return this.importStatus;
    }

    public void setImportFileUrl(String importFileUrl) {
        this.importFileUrl = importFileUrl;
    }

    public String getImportFileUrl() {
        return this.importFileUrl;
    }

    public void setReconciliationResult(String reconciliationResult) {
        this.reconciliationResult = reconciliationResult;
    }

    public String getReconciliationResult() {
        return this.reconciliationResult;
    }

    public void setPushPerson(String pushPerson) {
        this.pushPerson = pushPerson;
    }

    public String getPushPerson() {
        return this.pushPerson;
    }
}
