/*
 * @(#)RefReturnRefundEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_ref_return_refund")
public class StdRefReturnRefundEo extends CubeBaseEo {
    public static StdRefReturnRefundEo newInstance() {
        return (StdRefReturnRefundEo) BaseEo.newInstance(StdRefReturnRefundEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 退货流水号
     * 退货单号
     */
    @Column(name = "return_no")
    private String returnNo;
    /**
     * 退款流水号
     * 退款单号
     */
    @Column(name = "refund_no")
    private String refundNo;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getReturnNo() {
        return this.returnNo;
    }

    public void setReturnNo(String returnNo) {
        this.returnNo = returnNo;
    }

    public String getRefundNo() {
        return this.refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }


}