/*
 * @(#)RefTradeInvoiceEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 支持打包开票 或 分拆开票 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_ref_trade_invoice")
public class StdRefTradeInvoiceEo extends CubeBaseEo {
    public static StdRefTradeInvoiceEo newInstance() {
        return (StdRefTradeInvoiceEo) BaseEo.newInstance(StdRefTradeInvoiceEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 发票流水号
     */
    @Column(name = "invoice_no")
    private String invoiceNo;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getInvoiceNo() {
        return this.invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }


}