/*
 * @(#)RefTradeItemEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 交易下的数据可以多对多关联,  也一(交易)对多关联(商品) 比如 支付, 可以一次性支付多个商品 , 也可 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_ref_trade_item")
public class StdRefTradeItemEo extends CubeBaseEo {
    public static StdRefTradeItemEo newInstance() {
        return (StdRefTradeItemEo) BaseEo.newInstance(StdRefTradeItemEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 交易商品流水号
     * 业务唯一记录
     */
    @Column(name = "trade_item_no")
    private String tradeItemNo;
    /**
     * 关联方式
     * 购买, 开具发票
     * <p>
     * 发货由于有特定数据, 独立记录
     */
    @Column(name = "ref_type")
    private String refType;
    /**
     * 关联详情
     */
    @Column(name = "ref_detail")
    private String refDetail;
    /**
     * 商品来源系统
     */
    @Column(name = "item_src")
    private String itemSrc;
    /**
     * skuID
     * 库存规格ID
     */
    @Column(name = "sku_serial")
    private String skuSerial;
    /**
     * 第三方sdkID
     * 库存系统的外部SKU编码
     */
    @Column(name = "third_sku_serial")
    private String thirdSkuSerial;
    /**
     * 货品来源系统
     */
    @Column(name = "cargo_src")
    private String cargoSrc;
    /**
     * 库存系统的基础记录的编码
     */
    @Column(name = "cargo_serial")
    private String cargoSerial;
    /**
     * 商品数量
     */
    @Column(name = "item_num")
    private Integer itemNum;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getTradeItemNo() {
        return this.tradeItemNo;
    }

    public void setTradeItemNo(String tradeItemNo) {
        this.tradeItemNo = tradeItemNo;
    }

    public String getRefType() {
        return this.refType;
    }

    public void setRefType(String refType) {
        this.refType = refType;
    }

    public String getRefDetail() {
        return this.refDetail;
    }

    public void setRefDetail(String refDetail) {
        this.refDetail = refDetail;
    }

    public String getItemSrc() {
        return this.itemSrc;
    }

    public void setItemSrc(String itemSrc) {
        this.itemSrc = itemSrc;
    }

    public String getSkuSerial() {
        return this.skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public String getThirdSkuSerial() {
        return this.thirdSkuSerial;
    }

    public void setThirdSkuSerial(String thirdSkuSerial) {
        this.thirdSkuSerial = thirdSkuSerial;
    }

    public String getCargoSrc() {
        return this.cargoSrc;
    }

    public void setCargoSrc(String cargoSrc) {
        this.cargoSrc = cargoSrc;
    }

    public String getCargoSerial() {
        return this.cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public Integer getItemNum() {
        return this.itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }


}