/*
 * @(#)RefundDetailEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 如果没有合并支付记录或分拆退款,这个表可不写入 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_refund_detail")
public class StdRefundDetailEo extends CubeBaseEo {
    public static StdRefundDetailEo newInstance() {
        return (StdRefundDetailEo) BaseEo.newInstance(StdRefundDetailEo.class);
    }

    /**
     * 退款流水号
     */
    @Column(name = "refund_no")
    private String refundNo;
    /**
     * 支付流水号
     * 用于跟支付中心后或外部系统对接
     */
    @Column(name = "pay_no")
    private String payNo;
    /**
     * 退款金额
     */
    @Column(name = "refund_amount")
    private BigDecimal refundAmount;

    public String getRefundNo() {
        return this.refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public String getPayNo() {
        return this.payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }


}