/*
 * @(#)RefundEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.enhance.flow.NameCodePair;
import com.dtyunxi.cube.enhance.flow.StatusValueInfo;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;
import org.apache.commons.lang3.tuple.Pair;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 订单退款申请 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_refund")
public class StdRefundEo extends CubeBaseEo implements IFlowEntity {
    public static StdRefundEo newInstance() {
        return (StdRefundEo) BaseEo.newInstance(StdRefundEo.class);
    }


    /**
     * 流程方案id
     */
    @Column(name = "flow_def_id")
    private Long flowDefId;

    /**
     * 交易流水号:v3交易引擎trade_no实际为订单编号order_no
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 退款流水号
     * 退款单号
     */
    @Column(name = "refund_no")
    private String refundNo;
    @Column(name = "return_no")
    private String returnNo;
    /**
     * 外部交易系统
     */
    @Column(name = "extl_return_src")
    private String extlReturnSrc;
    /**
     * 外部退款单号
     */
    @Column(name = "extl_refund_serail")
    private String extlRefundSerail;
    /**
     * 退换类型: RETURN_BASE  退货退款,  REFUND_ONLY  只退款
     */
    @Column(name = "refund_type")
    private String refundType;
    /**
     * 支付方式
     */
    @Column(name = "pay_method")
    private String payMethod;
    /**
     * 申请状态 1处理中，2审核，3付款，0关闭
     */
    @Column(name = "refund_status")
    private String refundStatus;

    /**
     * 退款单业务状态
     */
    @Column(name = "biz_status")
    private String bizStatus;

    /**
     * 退款原因
     */
    @Column(name = "refund_reason")
    private String refundReason;
    /**
     * 退款说明
     */
    @Column(name = "refund_desc")
    private String refundDesc;
    /**
     * 退款付款方式 1.线上支付 2线下支付
     */
    @Column(name = "refund_payment_type")
    private String refundPaymentType;
    /**
     * 退款总金额
     * 退款商品金额
     */
    @Column(name = "refund_total_amount")
    private BigDecimal refundTotalAmount;
    /**
     * 商品退款金额
     * 退款实际金额
     */
    @Column(name = "refund_item_amount")
    private BigDecimal refundItemAmount;
    /**
     * 物流退款费用
     * 退货物流费用
     */
    @Column(name = "refund_freight_amount")
    private BigDecimal refundFreightAmount;
    /**
     * 取消方式: 0: 未取消,buyer_cancle: 买家取消,seller_cancle:卖家取消
     */
    @Column(name = "cancel_type")
    private String cancelType;
    /**
     * 退款完成的时间
     */
    @Column(name = "refund_time")
    private Date refundTime;
    /**
     * 取消完成的时间
     */
    @Column(name = "cancel_time")
    private Date cancelTime;
    /**
     * ${item.comment}
     */
    @Column(name = "cancel_desc")
    private String cancelDesc;

    /**
     * ${item.comment}
     */
    @Column(name = "pay_no")
    private String payNo;
    /**
     * ${item.comment}
     */
    @Column(name = "discount_refund_amount")
    private BigDecimal discountRefundAmount;

    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;

    public String getReturnNo() {
        return returnNo;
    }

    public void setReturnNo(String returnNo) {
        this.returnNo = returnNo;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getRefundNo() {
        return this.refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public String getExtlReturnSrc() {
        return this.extlReturnSrc;
    }

    public void setExtlReturnSrc(String extlReturnSrc) {
        this.extlReturnSrc = extlReturnSrc;
    }

    public String getExtlRefundSerail() {
        return this.extlRefundSerail;
    }

    public void setExtlRefundSerail(String extlRefundSerail) {
        this.extlRefundSerail = extlRefundSerail;
    }

    public String getRefundType() {
        return this.refundType;
    }

    public void setRefundType(String refundType) {
        this.refundType = refundType;
    }

    public String getPayMethod() {
        return this.payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public String getRefundStatus() {
        return this.refundStatus;
    }

    public void setRefundStatus(String refundStatus) {
        this.refundStatus = refundStatus;
    }

    public String getRefundReason() {
        return this.refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public String getRefundDesc() {
        return this.refundDesc;
    }

    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }

    public String getRefundPaymentType() {
        return this.refundPaymentType;
    }

    public void setRefundPaymentType(String refundPaymentType) {
        this.refundPaymentType = refundPaymentType;
    }

    public BigDecimal getRefundTotalAmount() {
        return this.refundTotalAmount;
    }

    public void setRefundTotalAmount(BigDecimal refundTotalAmount) {
        this.refundTotalAmount = refundTotalAmount;
    }

    public BigDecimal getRefundItemAmount() {
        return this.refundItemAmount;
    }

    public void setRefundItemAmount(BigDecimal refundItemAmount) {
        this.refundItemAmount = refundItemAmount;
    }

    public BigDecimal getRefundFreightAmount() {
        return this.refundFreightAmount;
    }

    public void setRefundFreightAmount(BigDecimal refundFreightAmount) {
        this.refundFreightAmount = refundFreightAmount;
    }

    public String getCancelType() {
        return this.cancelType;
    }

    public void setCancelType(String cancelType) {
        this.cancelType = cancelType;
    }

    public Date getRefundTime() {
        return this.refundTime;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    public Date getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    public String getCancelDesc() {
        return this.cancelDesc;
    }

    public void setCancelDesc(String cancelDesc) {
        this.cancelDesc = cancelDesc;
    }


    public String getPayNo() {
        return this.payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public BigDecimal getDiscountRefundAmount() {
        return this.discountRefundAmount;
    }

    public void setDiscountRefundAmount(BigDecimal discountRefundAmount) {
        this.discountRefundAmount = discountRefundAmount;
    }

    public String getBizStatus() {
        return bizStatus;
    }

    public void setBizStatus(String bizStatus) {
        this.bizStatus = bizStatus;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    /**
     * 这个表map可以被流程引擎管理的"状态" 字段
     */
    private static Map<String, StatusValueInfo> STATUS_PROP_DESC = new HashMap<>();

    static {
        STATUS_PROP_DESC.put("refundStatus", StatusValueInfo.generate("退款状态",
               NameCodePair.of("审核中","AUDITING"),
               NameCodePair.of(" 退款失败","FAIL"),
               NameCodePair.of("退款完成","SUCCESS")));
        STATUS_PROP_DESC.put("bizStatus", StatusValueInfo.generate("业务状态"));
    }

    @Override
    public String getEntityName() {
        return "订单退款申请";
    }

    @Override
    public Long getFlowDefId() {
        return flowDefId;
    }

    @Override
    public void setFlowDefId(Long flowDefId) {
        this.flowDefId = flowDefId;
    }

    @Override
    public Map<String, StatusValueInfo> getStatusDesc() {
        return STATUS_PROP_DESC;
    }

    @Override
    public String getStatus(String statusField) {
        if("refundStatus".equals(statusField)){
            return refundStatus;
        }
        if("bizStatus".equals(statusField)){
            return bizStatus;
        }
        return null;
    }

    @Override
    public void setStatus(String statusField, String newStatus) {
        if("refundStatus".equals(statusField)){
            this.refundStatus = newStatus;
        }
        if("bizStatus".equals(statusField)){
            this.bizStatus = bizStatus;
        }
    }

}