/*
 * @(#)RelatePartyEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 这个对象作为可扩展的字段 可以让业务方自行扩展. Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_relate_party")
public class StdRelatePartyEo extends CubeBaseEo {
    public static StdRelatePartyEo newInstance() {
        return (StdRelatePartyEo) BaseEo.newInstance(StdRelatePartyEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 关联方编码
     */
    @Column(name = "relate_party_serial")
    private String relatePartySerial;
    /**
     * 关联方名称
     */
    @Column(name = "relate_name")
    private String relateName;
    /**
     * 关联类型
     */
    @Column(name = "relate_type")
    private String relateType;
    /**
     * 关联详情
     * json结构的关联说明, 中台原样返回
     */
    @Column(name = "relate_detail")
    private String relateDetail;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getRelatePartySerial() {
        return this.relatePartySerial;
    }

    public void setRelatePartySerial(String relatePartySerial) {
        this.relatePartySerial = relatePartySerial;
    }

    public String getRelateName() {
        return this.relateName;
    }

    public void setRelateName(String relateName) {
        this.relateName = relateName;
    }

    public String getRelateType() {
        return this.relateType;
    }

    public void setRelateType(String relateType) {
        this.relateType = relateType;
    }

    public String getRelateDetail() {
        return this.relateDetail;
    }

    public void setRelateDetail(String relateDetail) {
        this.relateDetail = relateDetail;
    }


}