/*
 * @(#)ReturnEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单退货申请 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_return")
public class StdReturnEo extends CubeBaseEo {

    public static StdReturnEo newInstance() {
        return (StdReturnEo) BaseEo.newInstance(StdReturnEo.class);
    }


    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 退货流水号
     * 退货单号
     */
    @Column(name = "return_no")
    private String returnNo;
    /**
     * 外部交易系统
     */
    @Column(name = "extl_return_src")
    private String extlReturnSrc;
    /**
     * 外部退货单号
     */
    @Column(name = "extl_return_serial")
    private String extlReturnSerial;
    /**
     * ${item.comment}
     */
    @Column(name = "return_status")
    private String returnStatus;
    /**
     * 退款金额（临时记录）
     */
    @Column(name = "refund_amount")
    private BigDecimal refundAmount;
    /**
     * 退款积分
     */
    @Column(name = "return_integral")
    private Integer returnIntegral;
    /**
     * 退款详情（json格式）
     */
    @Column(name = "refund_amount_detail")
    private String refundAmountDetail;
    /**
     * 物流公司code
     */
    @Column(name = "return_express_company")
    private String returnExpressCompany;
    /**
     * 退货物流单
     */
    @Column(name = "return_express_serial")
    private String returnExpressSerial;
    /**
     * 退货物流详情
     */
    @Column(name = "return_express_detail")
    private String returnExpressDetail;
    /**
     * 取消方式: 0: 未取消,buyer_cancle: 买家取消,seller_cancle:卖家取消
     */
    @Column(name = "cancel_type")
    private String cancelType;
    /**
     * 取消完成的时间
     */
    @Column(name = "cancel_time")
    private Date cancelTime;
    /**
     * ${item.comment}
     */
    @Column(name = "cancel_desc")
    private String cancelDesc;

    /**
     * 退换类型: RETURN_BASE  退货退款,  REFUND_ONLY  只退款
     */
    @Column(name = "return_type")
    private String returnType;
    /**
     * 订单流水号
     */
    @Column(name = "order_trade_no")
    private String orderTradeNo;
    /**
     * 业务状态
     */
    @Column(name = "biz_status")
    private String bizStatus;
    /**
     * 售后订单订单业务类型
     */
    @Column(name = "biz_type")
    private String bizType;
    /**
     * 终端来源类型: 1: app端 2: PC端 3:微信端
     */
    @Column(name = "device_type")
    private String deviceType;
    /**
     * 商户所属系统
     */
    @Column(name = "seller_src")
    private String sellerSrc;
    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private String sellerId;
    /**
     * 店铺类型
     * online: 店铺
     * offline: 门店
     */
    @Column(name = "shop_type")
    private String shopType;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private String shopId;
    /**
     * 用户来源系统
     */
    @Column(name = "user_src")
    private String userSrc;
    /**
     * 用户ID
     * 跟用户来源系统联合作为业务主键
     */
    @Column(name = "user_id")
    private String userId;
    /**
     * 销售渠道
     * 客户下单的最后一个触点
     */
    @Column(name = "sale_channel")
    private String saleChannel;
    /**
     * 推广渠道
     * 客户来源的第一个触点.
     */
    @Column(name = "mkt_channel")
    private String mktChannel;

    /**
     * 退款点券
     */
    @Column(name = "return_point_coupon")
    private Integer returnPointCoupon;

    /**
     * 所属组织ID
     */
    @Column(name = "organization_id")
    private Long organizationId;

    /**
     * 所属组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 是否收到赠品
     */
    @Column(name = "received_gift")
    private Boolean receivedGift;
    /**
     * 退款返利
     */
    @Column(name = "return_rebate")
    private BigDecimal returnRebate;

    public BigDecimal getReturnRebate() {
        return returnRebate;
    }

    public void setReturnRebate(BigDecimal returnRebate) {
        this.returnRebate = returnRebate;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getReturnNo() {
        return this.returnNo;
    }

    public void setReturnNo(String returnNo) {
        this.returnNo = returnNo;
    }

    public String getExtlReturnSrc() {
        return this.extlReturnSrc;
    }

    public void setExtlReturnSrc(String extlReturnSrc) {
        this.extlReturnSrc = extlReturnSrc;
    }

    public String getExtlReturnSerial() {
        return this.extlReturnSerial;
    }

    public void setExtlReturnSerial(String extlReturnSerial) {
        this.extlReturnSerial = extlReturnSerial;
    }

    public String getReturnStatus() {
        return this.returnStatus;
    }

    public void setReturnStatus(String returnStatus) {
        this.returnStatus = returnStatus;
    }

    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public Integer getReturnIntegral() {
        return this.returnIntegral;
    }

    public void setReturnIntegral(Integer returnIntegral) {
        this.returnIntegral = returnIntegral;
    }

    public String getRefundAmountDetail() {
        return this.refundAmountDetail;
    }

    public void setRefundAmountDetail(String refundAmountDetail) {
        this.refundAmountDetail = refundAmountDetail;
    }

    public String getReturnExpressCompany() {
        return this.returnExpressCompany;
    }

    public void setReturnExpressCompany(String returnExpressCompany) {
        this.returnExpressCompany = returnExpressCompany;
    }

    public String getReturnExpressSerial() {
        return this.returnExpressSerial;
    }

    public void setReturnExpressSerial(String returnExpressSerial) {
        this.returnExpressSerial = returnExpressSerial;
    }

    public String getReturnExpressDetail() {
        return this.returnExpressDetail;
    }

    public void setReturnExpressDetail(String returnExpressDetail) {
        this.returnExpressDetail = returnExpressDetail;
    }

    public String getCancelType() {
        return this.cancelType;
    }

    public void setCancelType(String cancelType) {
        this.cancelType = cancelType;
    }

    public Date getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    public String getCancelDesc() {
        return this.cancelDesc;
    }

    public void setCancelDesc(String cancelDesc) {
        this.cancelDesc = cancelDesc;
    }


    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getOrderTradeNo() {
        return this.orderTradeNo;
    }

    public void setOrderTradeNo(String orderTradeNo) {
        this.orderTradeNo = orderTradeNo;
    }

    public String getBizStatus() {
        return this.bizStatus;
    }

    public void setBizStatus(String bizStatus) {
        this.bizStatus = bizStatus;
    }

    public String getBizType() {
        return this.bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getSellerSrc() {
        return this.sellerSrc;
    }

    public void setSellerSrc(String sellerSrc) {
        this.sellerSrc = sellerSrc;
    }

    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public String getShopType() {
        return this.shopType;
    }

    public void setShopType(String shopType) {
        this.shopType = shopType;
    }

    public String getShopId() {
        return this.shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getUserSrc() {
        return this.userSrc;
    }

    public void setUserSrc(String userSrc) {
        this.userSrc = userSrc;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getSaleChannel() {
        return this.saleChannel;
    }

    public void setSaleChannel(String saleChannel) {
        this.saleChannel = saleChannel;
    }

    public String getMktChannel() {
        return this.mktChannel;
    }

    public void setMktChannel(String mktChannel) {
        this.mktChannel = mktChannel;
    }

    public Integer getReturnPointCoupon() {
        return returnPointCoupon;
    }

    public void setReturnPointCoupon(Integer returnPointCoupon) {
        this.returnPointCoupon = returnPointCoupon;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Boolean getReceivedGift() {
        return receivedGift;
    }

    public void setReceivedGift(Boolean receivedGift) {
        this.receivedGift = receivedGift;
    }
}