package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author: liuji
 * @since 2.0.0
 */
@Table(name = "tr_return_item")
public class StdReturnItemEo extends CubeBaseEo {
    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;

    /**
     * 售后单流水号
     */
    @Column(name = "return_no")
    private String returnNo;

    /**
     * 品牌ID
     */
    @Column(name = "brand_id")
    private String brandId;

    /**
     * 品牌code
     */
    @Column(name = "brand_code")
    private String brandCode;

    /**
     *商品ID
     */
    @Column(name = "item_id")
    private String itemId;

    /**
     *商品code（款号）
     */
    @Column(name = "item_code")
    private String itemCode;

    /**
     *商品名称
     */
    @Column(name = "item_name")
    private String itemName;

    /**
     *商品数量
     */
    @Column(name = "item_num")
    private Integer itemNum;

    /**
     *商品实付单价，实际每个商品用户要支付的价格
     */
    @Column(name = "item_price")
    private BigDecimal itemPrice;

    /**
     *skuCode
     */
    @Column(name = "sku_code")
    private String skuCode;

    /**
     *规格描述
     */
    @Column(name = "sku_desc")
    private String skuDesc;

    /**
     *店铺ID
     */
    @Column(name = "shop_id")
    private String shopId;
    @Column(name = "sku_serial")
    private String skuSerial;

    /**
     *门店代码
     */
    @Column(name = "shop_code")
    private String shopCode;

    /**
     *支付流水号
     */
    @Column(name = "pay_no")
    private String payNo;

    /**
     *交易平台商品编码
     */
    @Column(name = "ext_code")
    private String extCode;

    /**
     *库存系统的基础记录的编码
     */
    @Column(name = "cargo_serial")
    private String cargoSerial;

    /**
     *行号
     */
    @Column(name = "line_num")
    private Long lineNum;

    /**
     *备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 商品应付单价
     */
    @Column(name = "item_orig_price")
    private BigDecimal itemOrigPrice;

    /**
     * 是否是赠品
     */
    @Column(name = "gift")
    private Integer gift;

    public String getSkuSerial() {
        return skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getReturnNo() {
        return returnNo;
    }

    public void setReturnNo(String returnNo) {
        this.returnNo = returnNo;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuDesc() {
        return skuDesc;
    }

    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getPayNo() {
        return payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public String getExtCode() {
        return extCode;
    }

    public void setExtCode(String extCode) {
        this.extCode = extCode;
    }

    public String getCargoSerial() {
        return cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public Long getLineNum() {
        return lineNum;
    }

    public void setLineNum(Long lineNum) {
        this.lineNum = lineNum;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getItemOrigPrice() {
        return itemOrigPrice;
    }

    public void setItemOrigPrice(BigDecimal itemOrigPrice) {
        this.itemOrigPrice = itemOrigPrice;
    }

    public Integer getGift() {
        return gift;
    }

    public void setGift(Integer gift) {
        this.gift = gift;
    }
}
