/*
 * @(#)AuditRecordEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author antu
 * @since 2.0.0
 */
@Table(name = "tr_share_item_record_detail")
public class StdShareItemRecordDetailEo extends CubeBaseEo {
    public static StdShareItemRecordDetailEo newInstance() {
        return (StdShareItemRecordDetailEo) BaseEo.newInstance(StdShareItemRecordDetailEo.class);
    }

    /**
     * 所属商品分享链接记录id
     */
    @Column(name = "share_item_record_id")
    private Long shareItemRecordId;
    /**
     * 商品id
     */
    @Column(name = "item_serial")
    private String itemSerial;
    /**
     * skuID
     */
    @Column(name = "sku_serial")
    private String skuSerial;
    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * 商品图片
     */
    @Column(name = "item_img_path")
    private String itemImgPath;
    /**
     * 商品销售价格
     */
    @Column(name = "item_sell_price")
    private String itemSellPrice;
    /**
     * 商品属性
     */
    @Column(name = "item_attrs")
    private String itemAttrs;

    @Column(name = "shop_id")
    private Long shopId;

    /**
     * 分享类型: 0 社区团购 1 分销
     */
    @Column(name = "share_type")
    private Integer shareType;

    /**
     * 分销用户Id
     */
    @Column(name = "share_user_id")
    private Long shareUserId;

    /**
     * 分享人姓名
     */
    @Column(name = "share_user_name")
    private String shareUserName;

    /**
     * 分享人手机号
     */
    @Column(name = "share_user_mobile")
    private String shareUserMobile;

    public Long getShareItemRecordId() {
        return shareItemRecordId;
    }

    public void setShareItemRecordId(Long shareItemRecordId) {
        this.shareItemRecordId = shareItemRecordId;
    }

    public String getItemSerial() {
        return itemSerial;
    }

    public void setItemSerial(String itemSerial) {
        this.itemSerial = itemSerial;
    }

    public String getSkuSerial() {
        return skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemImgPath() {
        return itemImgPath;
    }

    public void setItemImgPath(String itemImgPath) {
        this.itemImgPath = itemImgPath;
    }

    public String getItemSellPrice() {
        return itemSellPrice;
    }

    public void setItemSellPrice(String itemSellPrice) {
        this.itemSellPrice = itemSellPrice;
    }

    public String getItemAttrs() {
        return itemAttrs;
    }

    public void setItemAttrs(String itemAttrs) {
        this.itemAttrs = itemAttrs;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Integer getShareType() {
        return shareType;
    }

    public void setShareType(Integer shareType) {
        this.shareType = shareType;
    }

    public Long getShareUserId() {
        return shareUserId;
    }

    public void setShareUserId(Long shareUserId) {
        this.shareUserId = shareUserId;
    }

    public String getShareUserName() {
        return shareUserName;
    }

    public void setShareUserName(String shareUserName) {
        this.shareUserName = shareUserName;
    }

    public String getShareUserMobile() {
        return shareUserMobile;
    }

    public void setShareUserMobile(String shareUserMobile) {
        this.shareUserMobile = shareUserMobile;
    }
}