/*
 * @(#)AuditRecordEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author antu
 * @since 2.0.0
 */
@Table(name = "tr_share_item_record")
public class StdShareItemRecordEo extends CubeBaseEo {
    public static StdShareItemRecordEo newInstance() {
        return (StdShareItemRecordEo) BaseEo.newInstance(StdShareItemRecordEo.class);
    }

    /**
     * 分享链接中商品数量
     */
    @Column(name = "share_item_quantity")
    private Integer shareItemQuantity;
    /**
     * 分享商品链接形成下单成功交易数
     */
    @Column(name = "share_item_order_quantity")
    private Integer shareItemOrderQuantity;

    /**
     * 分享人用户id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 分享类型: 0 社区团购 1 分销
     */
    @Column(name = "share_type")
    private Integer shareType;

    public Integer getShareItemQuantity() {
        return shareItemQuantity;
    }

    public void setShareItemQuantity(Integer shareItemQuantity) {
        this.shareItemQuantity = shareItemQuantity;
    }

    public Integer getShareItemOrderQuantity() {
        return shareItemOrderQuantity;
    }

    public void setShareItemOrderQuantity(Integer shareItemOrderQuantity) {
        this.shareItemOrderQuantity = shareItemOrderQuantity;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getShareType() {
        return shareType;
    }

    public void setShareType(Integer shareType) {
        this.shareType = shareType;
    }
}