package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 分销记录表
 */
@Table(name = "tr_share_distribution")
public class StdSharedDistributionEo extends CubeBaseEo {

    public static StdSharedDistributionEo newInstance() {
        return (StdSharedDistributionEo) BaseEo.newInstance(StdSharedDistributionEo.class);
    }

    /**
     * 分享类型 1商品 2店铺
     */
    @Column(name = "share_type")
    private Integer shareType;

    /**
     * 所属店铺分享链接记录id
     */
    @Column(name = "share_shop_id")
    private Long shareShopId;

    /**
     * 所属商品分享链接记录id
     */
    @Column(name = "share_item_detail_id")
    private Long shareItemDetailId;

    /**
     * 分销用户Id
     */
    @Column(name = "share_user_id")
    private Long shareUserId;

    /**
     * 分享人姓名
     */
    @Column(name = "share_user_name")
    private String shareUserName;

    /**
     * 分享人手机号
     */
    @Column(name = "share_user_mobile")
    private String shareUserMobile;

    /**
     * 用户Id
     */
    @Column(name = "place_user_id")
    private Long placeUserId;

    /**
     * 分销保护到期时间
     */
    @Column(name = "expiration_time")
    private Date expirationTime;

    /**
     * 店铺Id
     */
    @Column(name = "shop_id")
    private Long shopId;

    /**
     * 商品Id
     */
    @Column(name = "item_id")
    private Long itemId;

    /**
     * skuId
     */
    @Column(name = "sku_id")
    private Long skuId;


    public Integer getShareType() {
        return shareType;
    }

    public void setShareType(Integer shareType) {
        this.shareType = shareType;
    }

    public Long getShareShopId() {
        return shareShopId;
    }

    public void setShareShopId(Long shareShopId) {
        this.shareShopId = shareShopId;
    }

    public Long getShareItemDetailId() {
        return shareItemDetailId;
    }

    public void setShareItemDetailId(Long shareItemDetailId) {
        this.shareItemDetailId = shareItemDetailId;
    }

    public Long getShareUserId() {
        return shareUserId;
    }

    public void setShareUserId(Long shareUserId) {
        this.shareUserId = shareUserId;
    }

    public Long getPlaceUserId() {
        return placeUserId;
    }

    public void setPlaceUserId(Long placeUserId) {
        this.placeUserId = placeUserId;
    }

    public Date getExpirationTime() {
        return expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getShareUserName() {
        return shareUserName;
    }

    public void setShareUserName(String shareUserName) {
        this.shareUserName = shareUserName;
    }

    public String getShareUserMobile() {
        return shareUserMobile;
    }

    public void setShareUserMobile(String shareUserMobile) {
        this.shareUserMobile = shareUserMobile;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
