/*
 * @(#)TradeEo.java 1.0 2019-03-06
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 交易负责整体流程的驱动和流程
 订单,支付,配送,售后均是下属的环节.
 以trade_no为分库分 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_trade")
public class StdTradeEo extends CubeBaseEo {
    public static StdTradeEo newInstance() {
        return (StdTradeEo) BaseEo.newInstance(StdTradeEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 上级交易流水号
     */
    @Column(name = "parent_trade_no")
    private String parentTradeNo;
    /**
     * 根交易流水号
     */
    @Column(name = "root_trade_no")
    private String rootTradeNo;
    /**
     * 是否有子交易
     */
    @Column(name = "has_children")
    private Integer hasChildren;
    /**
     * 处理流程
     */
    @Column(name = "flow_type_code")
    private String flowTypeCode;
    /**
     * 交易类型
     * 可选值:
     * 父订单:   AGG_ORDER
     * 订单: ORDER
     * 支付: PAY
     * 发货: DELIVERY
     * 退货: RETURN
     * 退款: REFUND
     * 换货: EXCHANGE
     * 后续可继续扩展.
     */
    @Column(name = "trade_type")
    private String tradeType;
    /**
     * 流程启动时间
     */
    @Column(name = "flow_start_time")
    private Date flowStartTime;
    /**
     * 当前状态
     */
    @Column(name = "flow_status")
    private String flowStatus;
    /**
     * 进入当前状态时间
     */
    @Column(name = "step_start_time")
    private Date stepStartTime;
    /**
     * 当前状态处理结束时间
     */
    @Column(name = "step_end_time")
    private Date stepEndTime;
    /**
     * 上一状态
     */
    @Column(name = "pre_status")
    private String preStatus;
    /**
     * 动作的执行状态
     */
    @Column(name = "action_status")
    private String actionStatus;
    /**
     * 入参
     */
    @Column(name = "start_param")
    private String startParam;
    /**
     * 父流程启动状态
     */
    @Column(name = "parent_start_status")
    private String parentStartStatus;
    /**
     * 父流程启动状态
     */
    @Column(name = "parent_act_status")
    private String parentActStatus;
    /**
     * 组合流程节点
     */
    @Column(name = "comp_flow_code")
    private String compFlowCode;
    /**
     * 流程执行类型
     */
    @Column(name = "flow_exec_type")
    private String flowExecType;
    /**
     * 上一状态完成时间
     */
    @Column(name = "pre_step_end_time")
    private Date preStepEndTime;
    /**
     * 流程结束时间
     */
    @Column(name = "flow_end_time")
    private Date flowEndTime;
    /**
     * 交易详情
     */
    @Column(name = "flow_detail")
    private String flowDetail;
    /**
     * 流程版本化
     */
    @Column(name = "flow_version")
    private String flowVersion;

    public String getFlowVersion() {
        return flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getParentTradeNo() {


        return this.parentTradeNo;
    }

    public void setParentTradeNo(String parentTradeNo) {
        this.parentTradeNo = parentTradeNo;
    }

    public String getRootTradeNo() {
        return this.rootTradeNo;
    }

    public void setRootTradeNo(String rootTradeNo) {
        this.rootTradeNo = rootTradeNo;
    }

    public Integer getHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(Integer hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getFlowTypeCode() {
        return this.flowTypeCode;
    }

    public void setFlowTypeCode(String flowTypeCode) {
        this.flowTypeCode = flowTypeCode;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public Date getFlowStartTime() {
        return this.flowStartTime;
    }

    public void setFlowStartTime(Date flowStartTime) {
        this.flowStartTime = flowStartTime;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public void setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
    }

    public Date getStepStartTime() {
        return this.stepStartTime;
    }

    public void setStepStartTime(Date stepStartTime) {
        this.stepStartTime = stepStartTime;
    }

    public Date getStepEndTime() {
        return this.stepEndTime;
    }

    public void setStepEndTime(Date stepEndTime) {
        this.stepEndTime = stepEndTime;
    }

    public String getPreStatus() {
        return this.preStatus;
    }

    public void setPreStatus(String preStatus) {
        this.preStatus = preStatus;
    }

    public String getActionStatus() {
        return this.actionStatus;
    }

    public void setActionStatus(String actionStatus) {
        this.actionStatus = actionStatus;
    }

    public String getStartParam() {
        return this.startParam;
    }

    public void setStartParam(String startParam) {
        this.startParam = startParam;
    }

    public String getParentStartStatus() {
        return this.parentStartStatus;
    }

    public void setParentStartStatus(String parentStartStatus) {
        this.parentStartStatus = parentStartStatus;
    }

    public String getCompFlowCode() {
        return this.compFlowCode;
    }

    public void setCompFlowCode(String compFlowCode) {
        this.compFlowCode = compFlowCode;
    }

    public Date getPreStepEndTime() {
        return this.preStepEndTime;
    }

    public void setPreStepEndTime(Date preStepEndTime) {
        this.preStepEndTime = preStepEndTime;
    }

    public Date getFlowEndTime() {
        return this.flowEndTime;
    }

    public void setFlowEndTime(Date flowEndTime) {
        this.flowEndTime = flowEndTime;
    }

    public String getFlowDetail() {
        return this.flowDetail;
    }

    public void setFlowDetail(String flowDetail) {
        this.flowDetail = flowDetail;
    }

    public String getFlowExecType() {
        return flowExecType;
    }

    public void setFlowExecType(String flowExecType) {
        this.flowExecType = flowExecType;
    }

    public String getParentActStatus() {
        return parentActStatus;
    }

    public void setParentActStatus(String parentActStatus) {
        this.parentActStatus = parentActStatus;
    }
}