/*
 * @(#)TrolleyEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_trolley")
public class StdTrolleyEo extends CubeBaseEo {
    public static StdTrolleyEo newInstance() {
        return (StdTrolleyEo) BaseEo.newInstance(StdTrolleyEo.class);
    }

    /**
     * 用户来源系统
     */
    @Column(name = "user_src")
    private String userSrc;
    /**
     * 用户编码
     */
    @Column(name = "user_serial")
    private String userSerial;
    /**
     * 购物车类型
     */
    @Column(name = "trolley_type")
    private String trolleyType;

    public String getUserSrc() {
        return this.userSrc;
    }

    public void setUserSrc(String userSrc) {
        this.userSrc = userSrc;
    }

    public String getUserSerial() {
        return this.userSerial;
    }

    public void setUserSerial(String userSerial) {
        this.userSerial = userSerial;
    }

    public String getTrolleyType() {
        return this.trolleyType;
    }

    public void setTrolleyType(String trolleyType) {
        this.trolleyType = trolleyType;
    }


}