/*
 * @(#)TrolleyItemEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_trolley_item")
public class StdTrolleyItemEo extends CubeBaseEo {
    public static StdTrolleyItemEo newInstance() {
        return (StdTrolleyItemEo) BaseEo.newInstance(StdTrolleyItemEo.class);
    }

    /**
     * 所属购物车id
     * 会员中心 cubeMember
     * 其他...
     */
    @Column(name = "trolley_id")
    private Long trolleyId;
    /**
     * 商品来源系统
     */
    @Column(name = "item_src")
    private String itemSrc;
    /**
     * 商品id
     */
    @Column(name = "item_serial")
    private String itemSerial;
    /**
     * skuID
     * 库存规格ID
     */
    @Column(name = "sku_serial")
    private String skuSerial;
    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * 商品数量
     */
    @Column(name = "item_num")
    private Integer itemNum;
    /**
     * 分组依据
     * 展示时按此字段进行分组.
     */
    @Column(name = "group_key")
    private String groupKey;
    /**
     * 来源类型
     * 通过什么场景添加的商品
     */
    @Column(name = "add_channel")
    private String addChannel;

    /**
     * 类型：1快递配送  2同城配送
     */
    @Column(name = "type")
    private Integer type;

    /**
     * 活动类型：0非活动  1组合商品
     */
    @Column(name = "activity_type")
    private Integer activityType;

    public Long getTrolleyId() {
        return this.trolleyId;
    }

    public void setTrolleyId(Long trolleyId) {
        this.trolleyId = trolleyId;
    }

    public String getItemSrc() {
        return this.itemSrc;
    }

    public void setItemSrc(String itemSrc) {
        this.itemSrc = itemSrc;
    }

    public String getItemSerial() {
        return this.itemSerial;
    }

    public void setItemSerial(String itemSerial) {
        this.itemSerial = itemSerial;
    }

    public String getSkuSerial() {
        return this.skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Integer getItemNum() {
        return this.itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getAddChannel() {
        return this.addChannel;
    }

    public void setAddChannel(String addChannel) {
        this.addChannel = addChannel;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }
}