package com.dtyunxi.yundt.cube.center.item.api.item.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 用户收藏商品
 *
 * @author weichu
 * @time 2021/1/22 20:44
 */
@ApiModel(value = "CollectionItemReqDto", description = "用户收藏商品")
public class CollectionItemReqDto extends BaseReqDto {

    /**
     * 用户收藏id
     */
    @ApiModelProperty(name = "collectionId", value = "用户收藏id，必填",required = true)
    @NotNull(message = "collectionId不能为空")
    private Long collectionId;

    /**
     * 商品来源系统
     */
    @ApiModelProperty(name = "itemSrc", value = "商品来源系统，选填")
    private String itemSrc;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemSerial", value = "商品id，选填")
    private String itemSerial;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称，选填")
    private String itemName;

    /**
     * 店铺id
     */
    @ApiModelProperty(name = "shopSerial", value = "店铺id，选填")
    private String shopSerial;

    /**
     * 店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称，选填")
    private String shopName;

    /**
     * 分组依据
     * 展示时按此字段进行分组.
     */
    @ApiModelProperty(name = "groupKey", value = "分组依据，展示时按此字段进行分组，选填")
    private String groupKey;

    /**
     * 来源类型
     * 通过什么场景添加的商品
     */
    @ApiModelProperty(name = "addChannel", value = "来源类型，通过什么场景添加的商品，选填")
    private String addChannel;

    /**
     * 收藏类型
     */
    @ApiModelProperty(name = "collectionType", value = "收藏类型")
    private String collectionType;

    public Long getCollectionId() {
        return collectionId;
    }

    public void setCollectionId(Long collectionId) {
        this.collectionId = collectionId;
    }

    public String getItemSrc() {
        return itemSrc;
    }

    public void setItemSrc(String itemSrc) {
        this.itemSrc = itemSrc;
    }

    public String getItemSerial() {
        return itemSerial;
    }

    public void setItemSerial(String itemSerial) {
        this.itemSerial = itemSerial;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getShopSerial() {
        return shopSerial;
    }

    public void setShopSerial(String shopSerial) {
        this.shopSerial = shopSerial;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getGroupKey() {
        return groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getAddChannel() {
        return addChannel;
    }

    public void setAddChannel(String addChannel) {
        this.addChannel = addChannel;
    }

    public String getCollectionType() {
        return collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }
}
