/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.mq.process;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="CUSTOMER_ACCOUNT_UPDATE")
public class CustomerAccountProcess
implements IMessageProcessor<List<JSONObject>> {
    private final Logger logger = LoggerFactory.getLogger(CustomerAccountProcess.class);
    @Resource
    private CustomerDas customerDas;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(List<JSONObject> message) {
        this.logger.info("\u83b7\u53d6mq\u6d88\u606f:{}", (Object)JSONObject.toJSONString(message));
        if (message.isEmpty()) {
            return MessageResponse.SUCCESS;
        }
        try {
            Optional.of(message.stream().map(json -> {
                CustomerEo customerEo = new CustomerEo();
                customerEo.setCode(json.getString("customerCode"));
                if (StringUtils.isEmpty((CharSequence)customerEo.getCode())) {
                    return null;
                }
                customerEo.setAccountorEffectStarttime(json.getDate("effectStarttime") == null ? new Date(9978411000L) : json.getDate("effectStarttime"));
                customerEo.setAccountorEffectEndtime(json.getDate("effectEndtime") == null ? new Date(9978411000L) : json.getDate("effectEndtime"));
                return customerEo;
            }).filter(Objects::nonNull).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((CustomerDas)this.customerDas).updateAccountorsDate(arg_0));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }
}

