/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.es.impl;

import com.dtyunxi.huieryun.opensearch.autoconfigure.OpenSearchRegistryProperties;
import com.dtyunxi.huieryun.opensearch.provider.es68.RestSearchClientUtils;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EsNativeApiService {
    @Resource
    private OpenSearchRegistryProperties openSearchRegistryProperties;
    private static final Logger logger = LoggerFactory.getLogger(EsNativeApiService.class);

    public SearchResultVo wrapNativeSearch(SearchSourceBuilder searchSourceBuilder, SearchRequest searchRequest) {
        RestHighLevelClient client = RestSearchClientUtils.createClient((OpenSearchVo)this.openSearchRegistryProperties);
        logger.debug("bundler-project-esapi\u7248\u672c\u9700\u548c\u58f3\u5de5\u7a0b\u7248\u672c\u4e00\u81f4");
        searchSourceBuilder.fetchSource(true);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        if (logger.isDebugEnabled()) {
            logger.debug("builder={}", (Object)searchSourceBuilder);
        }
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("response={}", (Object)searchResponse);
        }
        SearchHits hits = searchResponse.getHits();
        long totalSize = hits.totalHits;
        SearchResultVo result = new SearchResultVo();
        result.setTotalSize(totalSize);
        result.setDocValues(this.wrapDocValue(hits));
        return result;
    }

    public List<Map<String, Object>> wrapDocValue(SearchHits hits) {
        SearchHit[] searchHits = hits.getHits();
        ArrayList<Map<String, Object>> docValue = new ArrayList<Map<String, Object>>(searchHits.length);
        SearchHit[] var4 = searchHits;
        int var5 = searchHits.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            SearchHit searchHit = var4[var6];
            Map highlightFields = searchHit.getHighlightFields();
            Map item = searchHit.getSourceAsMap();
            if (!highlightFields.isEmpty()) {
                StringBuilder highlightFieldStringBuilder = new StringBuilder();
                for (String key : highlightFields.keySet()) {
                    for (Text text : ((HighlightField)highlightFields.get(key)).fragments()) {
                        highlightFieldStringBuilder.append(text.string());
                    }
                    item.put(key, highlightFieldStringBuilder.toString());
                }
            }
            item.put("_score", Float.valueOf(searchHit.getScore()));
            docValue.add(item);
        }
        return docValue;
    }
}

