/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.LimitItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.LimitItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.LimitItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.LimitItemRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.ILimitItemService;
import com.dtyunxi.yundt.cube.center.price.dao.das.LimitItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.LimitItemEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LimitItemServiceImpl
implements ILimitItemService {
    @Resource
    private LimitItemDas limitItemDas;
    private static final Logger logger = LoggerFactory.getLogger(LimitItemServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addLimitItem(LimitItemAddReqDto reqDto) {
        LimitItemEo limitItemEo = new LimitItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)limitItemEo);
        this.limitItemDas.insert((BaseEo)limitItemEo);
        return limitItemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyLimitItem(LimitItemModifyReqDto reqDto) {
        LimitItemEo limitItemEo = new LimitItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)limitItemEo);
        this.limitItemDas.updateSelective((BaseEo)limitItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeLimitItem(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.limitItemDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public LimitItemRespDto queryLimitItemById(Long id) {
        LimitItemEo limitItemEo = (LimitItemEo)this.limitItemDas.selectByPrimaryKey(id);
        if (limitItemEo == null) {
            return null;
        }
        LimitItemRespDto limitItemRespDto = new LimitItemRespDto();
        DtoHelper.eo2Dto((BaseEo)limitItemEo, (BaseVo)limitItemRespDto);
        return limitItemRespDto;
    }

    @Override
    public PageInfo<LimitItemRespDto> queryLimitItemByPage(LimitItemQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LimitItemEo limitItemEo = new LimitItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)limitItemEo);
        PageInfo eoPageInfo = this.limitItemDas.selectPage((BaseEo)limitItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, LimitItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

