/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.OssHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceExcelTemplateService;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.poi.ExcelUtils;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.BaseExcel;
import com.dtyunxi.yundt.cube.center.price.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.price.biz.vo.DynamicTemplateVo;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceExcelTemplateDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceExcelTemplateEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Service;

@Service
public class PriceExcelTemplateServiceImpl
implements IPriceExcelTemplateService {
    @Resource
    private PriceExcelTemplateDas priceExcelTemplateDas;
    @Resource
    private OssHelper ossHelper;

    private PriceExcelTemplateEo getPriceExcelTemplate(String code) {
        PriceExcelTemplateEo priceExcelTemplateEo = new PriceExcelTemplateEo();
        priceExcelTemplateEo.setCode(code);
        priceExcelTemplateEo = (PriceExcelTemplateEo)this.priceExcelTemplateDas.selectOne((BaseEo)priceExcelTemplateEo);
        AssertUtils.isNonNull(priceExcelTemplateEo, PriceExceptionCode.ERROR.setParamValue("\u65e0\u6548\u7684\u6a21\u677f"));
        return priceExcelTemplateEo;
    }

    @Override
    public String queryTemplateByCode(String templateCode) {
        PriceExcelTemplateEo priceExcelTemplate = this.getPriceExcelTemplate(templateCode);
        String url = priceExcelTemplate.getUrl();
        if (StrUtil.isNotBlank((CharSequence)url)) {
            return url;
        }
        return this.dynamicTemplate(priceExcelTemplate);
    }

    private String dynamicTemplate(PriceExcelTemplateEo priceExcelTemplate) {
        String config = priceExcelTemplate.getConfig();
        AssertUtils.isNotBlank(config, PriceExceptionCode.ERROR.setParamValue("\u65e0\u6548\u7684\u914d\u7f6e\u4fe1\u606f"));
        Workbook workbook = null;
        List dynamicTemplateList = JSON.parseList((String)config, DynamicTemplateVo.class);
        for (DynamicTemplateVo dynamicTemplateVo : dynamicTemplateList) {
            Class paramsClass = dynamicTemplateVo.toClass();
            ExportParams exportParams = dynamicTemplateVo.getExportParams();
            if (Objects.isNull(paramsClass)) {
                workbook = ExcelUtils.exportBigData(exportParams, dynamicTemplateVo.getExcelParams(), index -> this.getDataList(index, dynamicTemplateVo));
                continue;
            }
            workbook = ExcelUtils.exportBigData(exportParams, paramsClass, index -> this.getDataList(index, dynamicTemplateVo));
        }
        String url = this.ossHelper.upload(workbook, priceExcelTemplate.getName());
        priceExcelTemplate.setUrl(url);
        this.priceExcelTemplateDas.update((BaseEo)priceExcelTemplate);
        return url;
    }

    private Collection<?> getDataList(Integer index, DynamicTemplateVo dynamicTemplateVo) {
        if (index != 1) {
            return ListUtil.empty();
        }
        if (Objects.nonNull(dynamicTemplateVo.getExcelParams())) {
            return dynamicTemplateVo.getDefaultDataMapList();
        }
        Integer number = dynamicTemplateVo.getNumber();
        Class paramsClass = dynamicTemplateVo.toClass();
        if (Objects.nonNull(paramsClass)) {
            return this.getDefaultDataList(dynamicTemplateVo, number, paramsClass);
        }
        ArrayList list = ListUtil.toList((Object[])new Map[0]);
        if (Objects.nonNull(number) && number > 0) {
            for (int i = 0; i < number; ++i) {
                list.add(MapUtil.empty());
            }
        }
        return list;
    }

    private List<?> getDefaultDataList(DynamicTemplateVo dynamicTemplateVo, Integer number, Class<? extends BaseExcel> paramsClass) {
        List<? extends BaseExcel> defaultDataList = dynamicTemplateVo.getDefaultDataList();
        if (CollUtil.isNotEmpty(defaultDataList)) {
            return defaultDataList;
        }
        try {
            if (Objects.nonNull(number) && number > 0) {
                ArrayList dataList = ListUtil.toList((Object[])new Object[0]);
                for (int i = 0; i < number; ++i) {
                    BaseExcel baseExcel = paramsClass.newInstance();
                    baseExcel.setSerialNumber(i + 1);
                    dataList.add(baseExcel);
                }
                return dataList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ListUtil.empty();
    }
}

