/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.price.api.IPriceApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceAuditReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.SkuPolicyPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.SkuPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.query.IPriceQueryApi;
import com.github.pagehelper.PageInfo;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/price"})
public class PriceRest
implements IPriceApi,
IPriceQueryApi {
    @Resource
    private IPriceApi priceApi;
    @Resource
    private IPriceQueryApi priceQueryApi;

    public RestResponse<PriceAddOrModifyRespDto> addPrice(@Valid @RequestBody PriceAddReqDto reqDto) {
        return this.priceApi.addPrice(reqDto);
    }

    public RestResponse<PriceAddOrModifyRespDto> modifyPrice(@Valid @RequestBody PriceModifyReqDto reqDto) {
        return this.priceApi.modifyPrice(reqDto);
    }

    public RestResponse<Void> removePrice(@PathVariable(value="ids") String ids) {
        return this.priceApi.removePrice(ids);
    }

    public RestResponse<PriceRespDto> queryPriceById(@PathVariable(value="id") Long id) {
        return this.priceQueryApi.queryPriceById(id);
    }

    public RestResponse<PageInfo<PriceRespDto>> queryPriceByPage(@SpringQueryMap PriceQueryReqDto reqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.priceQueryApi.queryPriceByPage(reqDto, pageNum, pageSize);
    }

    public RestResponse<Void> cancelPrice(@PathVariable(value="id") Long id) {
        return this.priceApi.cancelPrice(id);
    }

    public RestResponse<Void> auditPrice(@Valid @RequestBody PriceAuditReqDto reqDto) {
        return this.priceApi.auditPrice(reqDto);
    }

    public RestResponse<Void> submit(@PathVariable(value="id") Long id) {
        return this.priceApi.submit(id);
    }

    public RestResponse<PageInfo<SkuPolicyPriceRespDto>> querySkuPolicyDistributePriceByPage(@RequestBody SkuPolicyPriceQueryReqDto reqDto) {
        return this.priceQueryApi.querySkuPolicyDistributePriceByPage(reqDto);
    }

    public RestResponse<Void> updatePriceIndex(Long id) {
        return this.priceApi.updatePriceIndex(id);
    }
}

