/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.OrderDetailVO;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateOrderCountReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.gateway.OrganizationGateway;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orderQueryApi")
public class OrderQueryApiImpl
implements IOrderQueryApi {
    private static final Logger logger = LoggerFactory.getLogger(OrderQueryApiImpl.class);
    @Resource
    private IOrderService orderService;
    @Resource
    private OrganizationGateway organizationGateway;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    public RestResponse<OrderRespDto> queryOrderById(Long id) {
        return new RestResponse((Object)this.orderService.queryOrderById(id));
    }

    public RestResponse<PageInfo<OrderRespDto>> queryOrderByPage(OrderQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.orderService.queryOrderByPage(reqDto, pageNum, pageSize));
    }

    public RestResponse<PageInfo<OrderDetailVO>> queryOrderDetailById(Long id, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.orderService.queryOrderDetailById(id, pageNum, pageSize));
    }

    public RestResponse<RebateOrderCountRespDto> queryOrderCount(RebateOrderCountReqDto reqDto) {
        reqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getKeyword())) {
            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
            customerSearchReqDto.setMerchantId(reqDto.getOrganizationId());
            customerSearchReqDto.setKeyword(reqDto.getKeyword());
            List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)customerSearchReqDto)));
            logger.info("[\u8fd4\u5229\u5355\u5217\u8868\u7edf\u8ba1\u91d1\u989d]:{}", (Object)JSON.toJSONString((Object)customerRespDtoList));
            List customerIds = customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
            reqDto.setCustomerIds(customerIds);
        }
        return new RestResponse((Object)this.orderService.queryOrderCount(reqDto));
    }
}

