/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.calc.impl;

import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateCycleTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.RebateCycleCalcStrategy;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.vo.RebateCycleVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.DateUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class MonthRebateCycleCalcStrategy
implements RebateCycleCalcStrategy {
    public List<RebateCycleVo> getAllCycleList(Date cycleBegin, Date cycleEnd) {
        ArrayList<RebateCycleVo> monthList = new ArrayList<RebateCycleVo>();
        Calendar c = Calendar.getInstance();
        c.setTime(cycleBegin);
        int beginYear = c.get(1);
        int beginMonth = c.get(2) + 1;
        c.setTime(cycleEnd);
        int endYear = c.get(1);
        int endMonth = c.get(2) + 1;
        int diffMonth = endMonth + (endYear - beginYear) * 12 - beginMonth + 1;
        for (int i = 0; i < diffMonth; ++i) {
            Date curCycleStart = DateUtil.getMonthBegin(cycleBegin, i);
            Date curCycleEnd = DateUtil.getMonthEnd(curCycleStart);
            RebateCycleVo cycleInfo = new RebateCycleVo(curCycleStart, curCycleEnd, RebateCycleTypeEnum.MONTHLY.getType(), i + 1);
            monthList.add(cycleInfo);
        }
        return monthList;
    }

    @Override
    public RebateCycleVo findDateMapperRebateCycle(Date cycleBegin, Date cycleEnd, Date orderDate) {
        List<RebateCycleVo> cycleList = this.getAllCycleList(cycleBegin, cycleEnd);
        RebateCycleVo res = null;
        for (RebateCycleVo vo : cycleList) {
            if (orderDate.compareTo(vo.getCycleStart()) < 0 || orderDate.compareTo(vo.getCycleEnd()) > 0) continue;
            res = vo;
            break;
        }
        return res;
    }

    @Override
    public Date calcSettleDate(RebateCycleVo rebateCycleVo, Integer cycleMonth, Integer cycleDay) {
        Date curCycleStart = rebateCycleVo.getCycleStart();
        Date nextCycleStart = DateUtil.getMonthBegin(curCycleStart, 1);
        Date settleDate = DateUtil.getDateAfter(nextCycleStart, cycleDay - 1);
        return settleDate;
    }
}

