/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.calc.impl;

import com.dtyunxi.yundt.cube.center.rebate.api.constants.CompareOpEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.SegmentCalcMethodEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicySegmentCalcReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicySegmentReqDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.RebateCalcStrategy;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.MathUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class SegmentRebateCalcStrategy
implements RebateCalcStrategy {
    @Override
    public BigDecimal calcRebate(PolicySegmentReqDto dto, BigDecimal consumeVal) {
        BigDecimal res = BigDecimal.ZERO;
        for (PolicySegmentCalcReqDto segDto : dto.getSegmentCalcRuleList()) {
            if (!this.isMatchSegmentCondition(segDto, consumeVal)) continue;
            res = res.add(this.calcSegmentRebate(segDto, consumeVal));
        }
        return res;
    }

    private BigDecimal calcSegmentRebate(PolicySegmentCalcReqDto segDto, BigDecimal consumeVal) {
        BigDecimal segmentRebate = BigDecimal.ZERO;
        boolean leftOpen = segDto.getLeftOpCond().equalsIgnoreCase(CompareOpEnum.GT.getCode());
        boolean rightOpen = segDto.getRightOpCond().equalsIgnoreCase(CompareOpEnum.LT.getCode());
        BigDecimal segmentVal = BigDecimal.ZERO;
        if (MathUtils.greaterRange(segDto.getLeftOpVal(), segDto.getRightOpVal(), leftOpen, rightOpen, consumeVal)) {
            segmentVal = segDto.getRightOpVal().setScale(2).subtract(segDto.getLeftOpVal());
            if (!leftOpen && !rightOpen) {
                segmentVal = segmentVal.add(BigDecimal.ONE);
            }
            if (leftOpen && rightOpen) {
                segmentVal = segmentVal.subtract(BigDecimal.ONE);
            }
        } else if (MathUtils.isInRange(segDto.getLeftOpVal(), segDto.getRightOpVal(), leftOpen, rightOpen, consumeVal)) {
            segmentVal = consumeVal.setScale(2).subtract(segDto.getLeftOpVal());
            if (!leftOpen) {
                segmentVal = segmentVal.add(BigDecimal.ONE);
            }
        } else {
            segmentRebate = BigDecimal.ZERO;
            return segmentRebate;
        }
        SegmentCalcMethodEnum calcMethod = SegmentCalcMethodEnum.getByCode((String)segDto.getSegmentCalcMethed());
        switch (calcMethod) {
            case CALC_BY_PECT: {
                segmentRebate = segmentVal.multiply(segDto.getSegmentCalcParam()).divide(new BigDecimal(100), RoundingMode.HALF_UP);
                break;
            }
            case CALC_BY_FIX_AMT: {
                segmentRebate = segDto.getSegmentCalcParam();
                break;
            }
            case CALC_BY_EACH_PIECE: {
                segmentRebate = segmentVal.setScale(2).multiply(segDto.getSegmentCalcParam());
                break;
            }
        }
        return segmentRebate;
    }

    private boolean isMatchSegmentCondition(PolicySegmentCalcReqDto segDto, BigDecimal consumeVal) {
        boolean isInRanger = false;
        boolean isGreaterRanger = false;
        boolean leftOpen = segDto.getLeftOpCond().equalsIgnoreCase(CompareOpEnum.GT.getCode());
        boolean rightOpen = segDto.getRightOpCond().equalsIgnoreCase(CompareOpEnum.LT.getCode());
        isInRanger = MathUtils.isInRange(segDto.getLeftOpVal(), segDto.getRightOpVal(), leftOpen, rightOpen, consumeVal);
        isGreaterRanger = MathUtils.greaterRange(segDto.getLeftOpVal(), segDto.getRightOpVal(), leftOpen, rightOpen, consumeVal);
        return isInRanger || isGreaterRanger;
    }
}

