/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.calc.impl;

import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateCycleTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.RebateCycleCalcStrategy;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.vo.RebateCycleVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.DateUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class YearRebateCycleCalcStrategy
implements RebateCycleCalcStrategy {
    public List<RebateCycleVo> getAllCycleList(Date cycleBegin, Date cycleEnd) {
        ArrayList<RebateCycleVo> yearList = new ArrayList<RebateCycleVo>();
        Calendar c = Calendar.getInstance();
        c.setTime(cycleBegin);
        int beginYear = c.get(1);
        c.setTime(cycleEnd);
        int endYear = c.get(1);
        int diffYear = endYear - beginYear + 1;
        Date firstCycleStart = DateUtil.getYearBegin(cycleBegin, 0);
        for (int i = 0; i < diffYear; ++i) {
            Date curCycleStart = DateUtil.getYearBegin(firstCycleStart, i);
            Date curCycleEnd = DateUtil.getYearEnd(curCycleStart);
            RebateCycleVo cycleInfo = new RebateCycleVo(curCycleStart, curCycleEnd, RebateCycleTypeEnum.ANNUALLY.getType(), i + 1);
            yearList.add(cycleInfo);
        }
        return yearList;
    }

    @Override
    public RebateCycleVo findDateMapperRebateCycle(Date cycleBegin, Date cycleEnd, Date orderDate) {
        List<RebateCycleVo> cycleList = this.getAllCycleList(cycleBegin, cycleEnd);
        RebateCycleVo res = null;
        for (RebateCycleVo vo : cycleList) {
            if (orderDate.compareTo(vo.getCycleStart()) < 0 || orderDate.compareTo(vo.getCycleEnd()) > 0) continue;
            res = vo;
            break;
        }
        return res;
    }

    @Override
    public Date calcSettleDate(RebateCycleVo rebateCycleVo, Integer cycleMonth, Integer cycleDay) {
        Date curCycleStart = rebateCycleVo.getCycleStart();
        Date nextCycleStart = DateUtil.getYearBegin(curCycleStart, 1);
        Date settleDate = DateUtil.getMonthBegin(nextCycleStart, cycleMonth - 1);
        settleDate = DateUtil.getDateAfter(settleDate, cycleDay - 1);
        return settleDate;
    }
}

