/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.BalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateDetailDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.BalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateDetailEo;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderProcess
implements IMessageProcessor<Long> {
    private static final Logger logger = LoggerFactory.getLogger(OrderProcess.class);
    @Resource
    private OrderDas orderDas;
    @Resource
    private BalanceDas balanceDas;
    @Resource
    private RebateDetailDas rebateDetailDas;

    public MessageResponse process(Long orderId) {
        logger.info("delay_message: {}", (Object)orderId);
        OrderEo orderEo = (OrderEo)this.orderDas.selectByPrimaryKey(orderId);
        logger.info("delay_message_orderEo: {}", (Object)JSON.toJSONString((Object)orderEo));
        if (orderEo.getBalance().compareTo(BigDecimal.ZERO) > 0) {
            BalanceEo queryBalanceEo = new BalanceEo();
            queryBalanceEo.setRebateAccountNo(orderEo.getRebateAccountNo());
            BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectOne((BaseEo)queryBalanceEo);
            this.balanceDas.releaseBalance(balanceEo.getId(), orderEo.getBalance().negate());
            RebateDetailEo rebateDetailEo = new RebateDetailEo();
            rebateDetailEo.setBusinessNo(orderEo.getRebateNo());
            rebateDetailEo.setRebateAccountNo(orderEo.getRebateAccountNo());
            rebateDetailEo.setUserId(orderEo.getUserId());
            rebateDetailEo.setUserType(orderEo.getUserType());
            rebateDetailEo.setUserName(orderEo.getUserName());
            rebateDetailEo.setChangeAmount(orderEo.getBalance().negate());
            rebateDetailEo.setType(RebateTypeEnum.FAILURE.getType() + "");
            rebateDetailEo.setExpiredTime(null);
            this.rebateDetailDas.insert((BaseEo)rebateDetailEo);
        }
        orderEo.setStatus(RebateOrderStatusEnum.EXPIRED.getCode());
        this.orderDas.updateSelective((BaseEo)orderEo);
        return MessageResponse.SUCCESS;
    }
}

