/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.mq.process;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.biz.mq.vo.RefundOrderMsgVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.mq.vo.ReturnItemVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPreSettlementService;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnOmniItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="${icomb.common.topic.order.rebate:ORDER_REBATE_TOPIC}", tag="btrade_order_return_rebate")
public class OrderRecalcRebateProcess
implements IMessageProcessor<String> {
    private static Logger logger = LoggerFactory.getLogger(OrderRecalcRebateProcess.class);
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private IPreSettlementService preSettlementService;
    @Resource
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Autowired
    private IOrderQueryApi orderQueryApi;

    public MessageResponse process(String message) {
        logger.info("\u9000\u6b3e\u6d88\u606f={}", (Object)JSONObject.toJSONString((Object)message));
        RefundOrderMsgVo refundOrderMsgVo = (RefundOrderMsgVo)((Object)JSONObject.parseObject((String)message, RefundOrderMsgVo.class));
        RestResponse returnDetailRespDtoRestResponse = this.afterSalesQueryApi.queryReturnDetail(refundOrderMsgVo.getReturnNo(), "{}");
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)RestResponseHelper.extractData((RestResponse)returnDetailRespDtoRestResponse);
        logger.info("\u9000\u6b3e\u5355\u4fe1\u606f={}", (Object)JSONObject.toJSONString((Object)returnDetailRespDto));
        RestResponse orderDetailRespDtoRestResponse = this.orderQueryApi.getOrderDetail(refundOrderMsgVo.getOrderNo());
        OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)RestResponseHelper.extractData((RestResponse)orderDetailRespDtoRestResponse);
        refundOrderMsgVo.setPlaceDate(orderDetailRespDto.getPlaceTime());
        String customerId = orderDetailRespDto.getExtFields().get("customerId") + "";
        refundOrderMsgVo.setUserId(Long.valueOf(customerId));
        refundOrderMsgVo.setUserType(orderDetailRespDto.getUserSrc());
        ArrayList<ReturnItemVo> returnItemVoList = new ArrayList<ReturnItemVo>();
        for (ReturnOmniItemRespDto omniItemRespDto : returnDetailRespDto.getReturnOmniItemRespDtoList()) {
            ReturnItemVo returnItemVo = this.convertReturnOmniItemDto(omniItemRespDto);
            returnItemVoList.add(returnItemVo);
        }
        refundOrderMsgVo.setReturnItemVoList(returnItemVoList);
        this.preSettlementService.reCalcPolicyRebate(refundOrderMsgVo);
        return MessageResponse.SUCCESS;
    }

    private ReturnItemVo convertReturnOmniItemDto(ReturnOmniItemRespDto omniItemRespDto) {
        ReturnItemVo returnItemVo = new ReturnItemVo();
        Map extFields = omniItemRespDto.getExtFields();
        String unit = extFields.get("unit") + "";
        String returnedNum = extFields.get("returnedNum") + "";
        String returnNum = extFields.get("returnNum") + "";
        String itemAmount = extFields.get("itemAmount") + "";
        String refundAmount = extFields.get("refundAmount") + "";
        String returnRebate = extFields.get("returnRebate") + "";
        CubeBeanUtils.copyProperties((Object)((Object)returnItemVo), (Object)omniItemRespDto, (String[])new String[0]);
        returnItemVo.setItemId(Long.valueOf(omniItemRespDto.getItemId()));
        returnItemVo.setSkuSerial(Long.valueOf(omniItemRespDto.getSkuSerial()));
        returnItemVo.setReturnNum(StringUtils.isBlank((CharSequence)returnNum) || "null".equals(returnNum) ? 0 : Integer.parseInt(returnNum));
        returnItemVo.setRefundAmount(StringUtils.isBlank((CharSequence)refundAmount) || "null".equals(refundAmount) ? BigDecimal.ZERO : new BigDecimal(refundAmount));
        returnItemVo.setReturnRebate(StringUtils.isBlank((CharSequence)returnRebate) || "null".equals(returnRebate) ? BigDecimal.ZERO : new BigDecimal(returnRebate));
        return returnItemVo;
    }
}

