/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.AttachmentAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.AttachmentMinimumDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.AttachmentModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.AttachmentQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.AttachmentRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IAttachmentService;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.AttachmentDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.AttachmentEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttachmentServiceImpl
implements IAttachmentService {
    @Resource
    private AttachmentDas attachmentDas;

    @Override
    public void addPolicyAttachment(List<AttachmentMinimumDto> attachmentList, Long businessId, String businessType, String name) {
        AttachmentEo deleteAttachmentEo = new AttachmentEo();
        deleteAttachmentEo.setBusinessId(businessId);
        deleteAttachmentEo.setBusinessType(businessType);
        this.attachmentDas.delete((BaseEo)deleteAttachmentEo);
        ArrayList<AttachmentEo> attachmentEoList = new ArrayList<AttachmentEo>();
        for (AttachmentMinimumDto attachment : attachmentList) {
            String path = attachment.getPath();
            AttachmentEo attachmentEo = new AttachmentEo();
            attachmentEo.setBusinessId(businessId);
            attachmentEo.setBusinessType(businessType);
            attachmentEo.setName(name);
            attachmentEo.setPath(path);
            attachmentEo.setDr(0);
            String fileType = path.substring(path.lastIndexOf(".")).replace(".", "").toUpperCase();
            attachmentEo.setFileType(fileType);
            attachmentEoList.add(attachmentEo);
        }
        this.attachmentDas.insertBatch(attachmentEoList);
    }

    @Override
    public List<AttachmentMinimumDto> getPolicyAttachment(Long businessId, String businessType) {
        ArrayList<AttachmentMinimumDto> AttachmentMinimumDtoList = new ArrayList<AttachmentMinimumDto>();
        AttachmentEo attachmentEo = new AttachmentEo();
        attachmentEo.setBusinessId(businessId);
        attachmentEo.setBusinessType(businessType);
        List resultList = this.attachmentDas.select((BaseEo)attachmentEo);
        if (null == resultList || resultList.isEmpty()) {
            return AttachmentMinimumDtoList;
        }
        for (AttachmentEo eo : resultList) {
            AttachmentMinimumDto minimumDto = new AttachmentMinimumDto();
            minimumDto.setPath(eo.getPath());
            AttachmentMinimumDtoList.add(minimumDto);
        }
        return AttachmentMinimumDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAttachment(AttachmentAddReqDto reqDto) {
        AttachmentEo attachmentEo = new AttachmentEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)attachmentEo);
        this.attachmentDas.insert((BaseEo)attachmentEo);
        return attachmentEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAttachment(AttachmentModifyReqDto reqDto) {
        AttachmentEo attachementEo = new AttachmentEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)attachementEo);
        this.attachmentDas.updateSelective((BaseEo)attachementEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAttachment(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.attachmentDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public AttachmentRespDto queryAttachmentById(Long id) {
        AttachmentEo attachementEo = (AttachmentEo)this.attachmentDas.selectByPrimaryKey(id);
        if (attachementEo == null) {
            return null;
        }
        AttachmentRespDto attachmentRespDto = new AttachmentRespDto();
        DtoHelper.eo2Dto((BaseEo)attachementEo, (BaseVo)attachmentRespDto);
        return attachmentRespDto;
    }

    @Override
    public PageInfo<AttachmentRespDto> queryAttachmentByPage(AttachmentQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        AttachmentEo attachementEo = new AttachmentEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)attachementEo);
        PageInfo eoPageInfo = this.attachmentDas.selectPage((BaseEo)attachementEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AttachmentRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

