/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RuleUseObjectTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.UserTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceNegativeReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalancePayReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceReturnRechargeReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceReturnReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderRebateAmountQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateUseRuleSearchDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateUseRuleSearchItemDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.BalanceGroupRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.BalancePayRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.BalanceRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderRebateAmountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.exception.RebateExceptionCode;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IBalanceService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IRuleService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.gateway.OrganizationGateway;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.RebateUtil;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.BalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateDetailDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateUseLogDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.BalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PreSettlementEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateDetailEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateUseLogEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdRebateDetailEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdRebateUseLogEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BalanceServiceImpl
implements IBalanceService {
    private static final Logger logger = LoggerFactory.getLogger(BalanceServiceImpl.class);
    @Resource
    private BalanceDas balanceDas;
    private static final String ERROR_CODE = "FAIL";
    private static final String SUCCESS_CODE = "SUCCESS";
    @Autowired
    private BalanceDas rbBalanceDas;
    @Autowired
    private OrderDas orderDas;
    @Autowired
    private RebateUseLogDas rebateUseLogDas;
    @Autowired
    private RebateDetailDas rebateDetailDas;
    @Autowired
    private IContext iContext;
    @Resource
    private IRuleService ruleService;
    @Resource
    private IOrderService orderService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private OrganizationGateway organizationGateway;
    @Resource
    private ILockService lockService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBalance(BalanceAddReqDto reqDto) {
        BalanceEo queryEo = new BalanceEo();
        queryEo.setUserId(reqDto.getUserId());
        queryEo.setUserType(reqDto.getUserType());
        List select = this.balanceDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            throw new BizException(RebateExceptionCode.REBATE_ACCOUNT_EXISTS.getCode(), RebateExceptionCode.REBATE_ACCOUNT_EXISTS.getMsg());
        }
        BalanceEo balanceEo = new BalanceEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)balanceEo);
        String rebateAccountNo = RebateUtil.generateRebateAccountNo("RBA");
        logger.info("addBalance params rebateAccountNo:{}", (Object)rebateAccountNo);
        balanceEo.setRebateAccountNo(rebateAccountNo);
        this.balanceDas.insert((BaseEo)balanceEo);
        return balanceEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBalance(BalanceModifyReqDto reqDto) {
        BalanceEo balanceEo = new BalanceEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)balanceEo);
        this.balanceDas.updateSelective((BaseEo)balanceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBalance(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.balanceDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public BalanceRespDto queryBalanceById(Long id) {
        BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectByPrimaryKey(id);
        if (balanceEo == null) {
            return null;
        }
        BalanceRespDto balanceRespDto = new BalanceRespDto();
        DtoHelper.eo2Dto((BaseEo)balanceEo, (BaseVo)balanceRespDto);
        return balanceRespDto;
    }

    @Override
    public PageInfo<BalanceRespDto> queryBalanceByPage(BalanceQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        BalanceEo balanceEo = new BalanceEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)balanceEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (reqDto.getOrganizationId() == null && this.organizationGateway.getOrganizationId() != null) {
            sqlFilters.add(SqlFilter.in((String)"organization_id", (Object)this.organizationGateway.getOrganizationId()));
        } else if (reqDto.getOrganizationId() != null) {
            sqlFilters.add(SqlFilter.in((String)"organization_id", (Object)reqDto.getOrganizationId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getUserName())) {
            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
            customerSearchReqDto.setKeyword(reqDto.getUserName());
            RestResponse customerResponse = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)customerSearchReqDto));
            logger.info("\u4f59\u989d\u8d26\u6237\u641c\u7d22:{}", (Object)JSON.toJSONString((Object)customerResponse));
            List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)customerResponse);
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtoList)) {
                sqlFilters.add(SqlFilter.in((String)"user_id", customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList())));
            }
        }
        if (CollectionUtils.isNotEmpty(sqlFilters)) {
            balanceEo.setSqlFilters(sqlFilters);
            balanceEo.setUserName(null);
        }
        balanceEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.balanceDas.selectPage((BaseEo)balanceEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BalanceRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            dtoList.forEach(balanceRespDto -> {
                BigDecimal actualBalance = this.balanceDas.selectActualBalanceByUserId(balanceRespDto.getUserId().longValue());
                balanceRespDto.setBalance(actualBalance);
            });
            List<String> rebateAccountNos = dtoList.stream().filter(bean -> StringUtils.isNotEmpty((CharSequence)bean.getRebateAccountNo())).map(BalanceRespDto::getRebateAccountNo).collect(Collectors.toList());
            Map<String, List<RebateDetailEo>> stringListMap = this.queryRebateDetailByAccountNos(rebateAccountNos);
            if (null != stringListMap) {
                dtoList.stream().forEach(bean -> {
                    List rebateDetailEos;
                    bean.setFlag(Boolean.valueOf(false));
                    if (StringUtils.isNotEmpty((CharSequence)bean.getRebateAccountNo()) && CollectionUtils.isNotEmpty((Collection)(rebateDetailEos = (List)stringListMap.get(bean.getRebateAccountNo())))) {
                        bean.setFlag(Boolean.valueOf(true));
                    }
                });
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public OrderRebateAmountRespDto queryUsableBalance(OrderRebateAmountQueryReqDto orderRebateAmountQueryReqDto) {
        Long sellerOrgId;
        SellerRespDto sellerRespDto;
        RestResponse sellerRestResponse;
        ShopBaseDto shopBaseDto;
        RestResponse shopResponse;
        if (orderRebateAmountQueryReqDto.getCustomerId() == null) {
            shopResponse = this.shopQueryApi.queryBaseById(orderRebateAmountQueryReqDto.getShopId());
            shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)shopResponse);
            sellerRestResponse = this.sellerQueryApi.queryById(shopBaseDto.getSellerId());
            sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)sellerRestResponse);
            sellerOrgId = sellerRespDto.getOrganizationId();
            orderRebateAmountQueryReqDto.setSellerOrgId(sellerOrgId);
            Long userOrganizationId = this.organizationGateway.getOrganizationId();
            RestResponse customerRespDtoRestResponse = this.customerExtQueryApi.queryCustomerByOrgAndMerch(userOrganizationId, sellerOrgId);
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRestResponse);
            if (customerRespDto.getCustomerId() == null) {
                throw new BizException("\u5f53\u524d\u8d26\u6237\u4e0e\u8be5\u5e97\u94fa\u65e0\u5173\u8054\u5173\u7cfb\uff0c\u65e0\u6cd5\u8d2d\u4e70");
            }
            orderRebateAmountQueryReqDto.setCustomerId(customerRespDto.getCustomerId());
        } else {
            shopResponse = this.shopQueryApi.queryBaseById(orderRebateAmountQueryReqDto.getShopId());
            shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)shopResponse);
            sellerRestResponse = this.sellerQueryApi.queryById(shopBaseDto.getSellerId());
            sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)sellerRestResponse);
            sellerOrgId = sellerRespDto.getOrganizationId();
            orderRebateAmountQueryReqDto.setSellerOrgId(sellerOrgId);
        }
        logger.info("\u67e5\u770b\u5ba2\u6237\u53ef\u7528\u8fd4\u5229\u4f59\u989d:\u5165\u53c2orderRebateAmountQueryReqDto\u65e5\u5fd7\u8f93\u51fa[{}]", (Object)JSON.toJSONString((Object)orderRebateAmountQueryReqDto));
        OrderRebateAmountRespDto orderRebateAmountRespDto = new OrderRebateAmountRespDto();
        BalanceEo balanceEo = this.balanceDas.queryCustomerAccountByUserId(orderRebateAmountQueryReqDto.getCustomerId());
        if (balanceEo == null) {
            orderRebateAmountRespDto.setMsg("\u627e\u4e0d\u5230\u8fd4\u5229\u8d26\u6237");
            return orderRebateAmountRespDto;
        }
        BigDecimal actualBalance = this.balanceDas.selectActualBalanceByUserId(orderRebateAmountQueryReqDto.getCustomerId().longValue());
        balanceEo.setBalance(actualBalance);
        if (actualBalance.compareTo(BigDecimal.ZERO) == 0) {
            logger.info("{}\uff0c\u5ba2\u6237\u8d26\u53f7\u4f59\u989d\u4e3a0", (Object)balanceEo.getUserName());
        }
        DtoHelper.eo2Dto((BaseEo)balanceEo, (BaseVo)orderRebateAmountRespDto);
        RebateUseRuleSearchDto rebateUseRuleSearchDto = this.ruleService.rebateUseRuleEngine(orderRebateAmountQueryReqDto);
        logger.info("\u8fd4\u5229\u5f15\u64ce\u8fd4\u56de\u6700\u4f18\u8fd4\u5229\u89c4\u5219[{}]", (Object)JSON.toJSONString((Object)rebateUseRuleSearchDto));
        if (rebateUseRuleSearchDto == null) {
            orderRebateAmountQueryReqDto.getItemList().forEach(g -> g.setTotalSellPrice(g.getSellPrice().multiply(BigDecimal.valueOf(g.getItemNum().intValue()))));
            BigDecimal totalAmount = orderRebateAmountQueryReqDto.getItemList().stream().map(OrderItemInfoDto::getTotalSellPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            orderRebateAmountRespDto.setUseBalance(balanceEo.getBalance().min(totalAmount));
            orderRebateAmountRespDto.setMsg("\u672a\u627e\u5230\u4efb\u4f55\u8fd4\u5229\u89c4\u5219");
            return orderRebateAmountRespDto;
        }
        orderRebateAmountRespDto.setRebateUseRuleSearchDto(rebateUseRuleSearchDto);
        boolean isNotBlackProduct = true;
        if (CollectionUtils.isEmpty((Collection)rebateUseRuleSearchDto.getBlackItems())) {
            rebateUseRuleSearchDto.setBlackItems(new ArrayList());
        }
        List<Object> querySkuIds = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)rebateUseRuleSearchDto.getBlackItems())) {
            querySkuIds = rebateUseRuleSearchDto.getBlackItems().stream().map(RebateUseRuleSearchDto.BlackItem::getSkuId).collect(Collectors.toList());
        }
        BigDecimal orderPayAmountOutBlack = BigDecimal.ZERO;
        BigDecimal orderPayAmountIntBlack = BigDecimal.ZERO;
        for (OrderItemInfoDto orderItemInfoDto : orderRebateAmountQueryReqDto.getItemList()) {
            if (!querySkuIds.contains(orderItemInfoDto.getSkuId())) {
                orderPayAmountOutBlack = orderItemInfoDto.getIfExchange() != null && orderItemInfoDto.getIfExchange() == 1 ? orderPayAmountOutBlack.add(orderItemInfoDto.getExchangePrice().multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue()))) : orderPayAmountOutBlack.add(orderItemInfoDto.getSellPrice().multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue())).subtract(Optional.ofNullable(orderItemInfoDto.getDiscountTotalAmount()).orElse(BigDecimal.ZERO)));
                orderItemInfoDto.setBlackItem(false);
                continue;
            }
            orderPayAmountIntBlack = orderItemInfoDto.getIfExchange() != null && orderItemInfoDto.getIfExchange() == 1 ? orderPayAmountIntBlack.add(orderItemInfoDto.getExchangePrice().multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue()))) : orderPayAmountIntBlack.add(orderItemInfoDto.getSellPrice().multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue()).subtract(Optional.ofNullable(orderItemInfoDto.getDiscountTotalAmount()).orElse(BigDecimal.ZERO))));
            orderItemInfoDto.setBlackItem(true);
            isNotBlackProduct = false;
        }
        logger.info("\u514d\u8d39\u8d60\u54c1\u5e94\u4ed8\u6b3e:{}", (Object)orderPayAmountOutBlack.add(orderPayAmountIntBlack));
        logger.info("\u9ed1\u540d\u5355\u5546\u54c1\u91d1\u989d:{}", (Object)orderPayAmountIntBlack);
        ArrayList<OrderItemInfoDto> productItemList = new ArrayList<OrderItemInfoDto>();
        ArrayList<OrderItemInfoDto> giftItemList = new ArrayList<OrderItemInfoDto>();
        ArrayList<OrderItemInfoDto> materialItemList = new ArrayList<OrderItemInfoDto>();
        for (OrderItemInfoDto item : orderRebateAmountQueryReqDto.getItemList()) {
            if (item.getSubType() == null) {
                logger.error("itemId: {}, \u65e0\u5546\u54c1\u7c7b\u578b\u3002 {}", (Object)item.getItemId(), (Object)JSON.toJSONString((Object)orderRebateAmountQueryReqDto));
                continue;
            }
            if (item.getSubType().equals(1)) {
                productItemList.add(item);
            }
            if (item.getSubType().equals(2)) {
                giftItemList.add(item);
            }
            if (!item.getSubType().equals(3)) continue;
            materialItemList.add(item);
        }
        List useRules = rebateUseRuleSearchDto.getRules();
        RebateUseRuleSearchItemDto rootRule = null;
        RebateUseRuleSearchItemDto productRule = null;
        RebateUseRuleSearchItemDto giftRule = null;
        RebateUseRuleSearchItemDto materialRule = null;
        for (RebateUseRuleSearchItemDto rule : rebateUseRuleSearchDto.getRules()) {
            if (rule.getType().equals(RuleUseObjectTypeEnum.ALL.toCode())) {
                rootRule = rule;
            }
            if (rule.getType().equals(RuleUseObjectTypeEnum.PRODUCT.toCode())) {
                productRule = rule;
            }
            if (rule.getType().equals(RuleUseObjectTypeEnum.GIFT.toCode())) {
                giftRule = rule;
            }
            if (!rule.getType().equals(RuleUseObjectTypeEnum.MATERIAL.toCode())) continue;
            materialRule = rule;
        }
        if (rootRule != null) {
            List<String> list = this.getUseInstStrings("", rootRule.getUseRadio(), rootRule.getThresholdAmount(), isNotBlackProduct);
            orderRebateAmountRespDto.setUseInst(list);
            logger.info("\u8ba2\u5355\u975e\u9ed1\u540d\u5355\u5e94\u4ed8\u91d1\u989d: {}", (Object)orderPayAmountOutBlack);
            BigDecimal usableBalance = this.getUseBalance(rootRule.getUseRadio(), rootRule.getThresholdAmount(), balanceEo.getBalance(), orderPayAmountOutBlack);
            List<OrderItemInfoDto> orderItemInfoDtos = this.buildNotBlackItemRebate(orderRebateAmountQueryReqDto.getItemList(), orderPayAmountOutBlack.add(orderPayAmountIntBlack), usableBalance);
            orderRebateAmountRespDto.setItemList(orderItemInfoDtos);
            orderRebateAmountRespDto.setUseBalance(usableBalance);
        } else {
            ArrayList<String> useList = new ArrayList<String>();
            ArrayList<OrderItemInfoDto> returnItemList = new ArrayList<OrderItemInfoDto>();
            BigDecimal usableBalance = BigDecimal.ZERO;
            BigDecimal balance = balanceEo.getBalance();
            if (CollectionUtils.isNotEmpty(productItemList) && productRule != null) {
                usableBalance = this.calculateRebate(productRule, productItemList, balance, querySkuIds, useList, returnItemList, usableBalance);
            }
            logger.info("\u4ea7\u54c1\u91d1\u989d[{}]", (Object)usableBalance);
            if (CollectionUtils.isNotEmpty(giftItemList) && giftRule != null) {
                usableBalance = this.calculateRebate(giftRule, giftItemList, balance, querySkuIds, useList, returnItemList, usableBalance);
            }
            logger.info("\u8d60\u54c1\u91d1\u989d[{}]", (Object)usableBalance);
            if (CollectionUtils.isNotEmpty(materialItemList) && materialRule != null) {
                usableBalance = this.calculateRebate(materialRule, materialItemList, balance, querySkuIds, useList, returnItemList, usableBalance);
            }
            logger.info("\u7269\u6599\u91d1\u989d[{}]", (Object)usableBalance);
            orderRebateAmountRespDto.setUseInst(useList);
            orderRebateAmountRespDto.setItemList(returnItemList);
            orderRebateAmountRespDto.setUseBalance(balance.min(usableBalance));
        }
        orderRebateAmountRespDto.setUseBalance(orderRebateAmountRespDto.getUseBalance().setScale(2, 0));
        return orderRebateAmountRespDto;
    }

    private BigDecimal calculateRebate(RebateUseRuleSearchItemDto rule, List<OrderItemInfoDto> itemList, BigDecimal balance, List<Long> querySkuIds, List<String> useList, List<OrderItemInfoDto> returnItemList, BigDecimal totalUsableBalance) {
        BigDecimal allPayAmount = BigDecimal.ZERO;
        BigDecimal outBlackPayAmount = BigDecimal.ZERO;
        boolean isNotBlack = true;
        for (OrderItemInfoDto item : itemList) {
            if (querySkuIds.contains(item.getSkuId())) {
                isNotBlack = false;
            }
            if (item.getIfExchange() != null && item.getIfExchange() == 1) {
                allPayAmount = allPayAmount.add(item.getExchangePrice().multiply(BigDecimal.valueOf(item.getItemNum().intValue())));
                if (querySkuIds.contains(item.getSkuId())) continue;
                outBlackPayAmount = outBlackPayAmount.add(item.getExchangePrice().multiply(BigDecimal.valueOf(item.getItemNum().intValue())));
                continue;
            }
            allPayAmount = allPayAmount.add(item.getSellPrice().multiply(BigDecimal.valueOf(item.getItemNum().intValue())).subtract(Optional.ofNullable(item.getDiscountTotalAmount()).orElse(BigDecimal.ZERO)));
            if (querySkuIds.contains(item.getSkuId())) continue;
            outBlackPayAmount = outBlackPayAmount.add(item.getSellPrice().multiply(BigDecimal.valueOf(item.getItemNum().intValue())).subtract(Optional.ofNullable(item.getDiscountTotalAmount()).orElse(BigDecimal.ZERO)));
        }
        List<String> list = this.getUseInstStrings(RuleUseObjectTypeEnum.valueOf((String)rule.getType()).toName(), rule.getUseRadio(), rule.getThresholdAmount(), isNotBlack);
        useList.addAll(list);
        logger.info("\u62b5\u6263\u8ba1\u7b97\u91d1\u989d: {}, {}", (Object)RuleUseObjectTypeEnum.valueOf((String)rule.getType()).toName(), (Object)outBlackPayAmount);
        BigDecimal usableBalance = this.getUseBalance(rule.getUseRadio(), rule.getThresholdAmount(), balance, outBlackPayAmount);
        totalUsableBalance = totalUsableBalance.add(usableBalance);
        List<OrderItemInfoDto> orderItemInfoDtos = this.buildNotBlackItemRebate(itemList, outBlackPayAmount, usableBalance);
        returnItemList.addAll(orderItemInfoDtos);
        return totalUsableBalance;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BalancePayRespDto useBalance(BalancePayReqDto reqDto) {
        BalancePayRespDto respDto = null;
        Assert.notNull((Object)reqDto.getUserId(), (String)"\u7528\u6237ID\u4e3a\u7a7a", (Object[])new Object[0]);
        BalanceEo selectItemBalance = new BalanceEo();
        selectItemBalance.setUserId(reqDto.getUserId());
        BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectOne((BaseEo)selectItemBalance);
        if (balanceEo == null) {
            throw new BizException("\u627e\u4e0d\u5230\u7528\u6237\u8d26\u53f7");
        }
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), "rebate_balance_lock:" + balanceEo.getUserId(), 2000, 1000, TimeUnit.MILLISECONDS);
        BigDecimal actualBalance = this.rbBalanceDas.selectActualBalanceByUserId(reqDto.getUserId().longValue());
        Assert.isTrue((actualBalance.compareTo(balanceEo.getBalance()) == 0 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u8d26\u6237\u4f59\u989d\u548c\u5145\u503c\u5355\u7edf\u8ba1\u4f59\u989d\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        try {
            respDto = this.useBalance0(reqDto, balanceEo);
            this.lockService.unlock(lock);
        }
        catch (Exception e) {
            logger.info("\u8ba2\u5355\uff1a{}\uff0c\u6263\u6b3e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object)reqDto.getOrderNo(), (Object)e.getMessage());
            throw e;
        }
        finally {
            this.lockService.unlock(lock);
        }
        return respDto;
    }

    public BalancePayRespDto useBalance0(BalancePayReqDto reqDto, BalanceEo balanceEo) {
        BalancePayRespDto balancePayRespDto = new BalancePayRespDto();
        List orderEos = this.orderDas.getEffectOrderEos(reqDto.getUserId());
        logger.info("\u8ba1\u7b97\u8fd4\u5229:\u83b7\u53d6\u6ee1\u8db3\u6761\u4ef6\u7684\u8fd4\u5229\u5355:useBalance\u65e5\u5fd7\u8f93\u51fa[{}]", (Object)JSON.toJSONString((Object)orderEos));
        if (CollectionUtils.isEmpty((Collection)orderEos)) {
            balancePayRespDto.setCode(ERROR_CODE);
            balancePayRespDto.setMsg("\u627e\u4e0d\u5230\u53ef\u7528\u8fd4\u5229\u5355");
            return balancePayRespDto;
        }
        int data = this.rbBalanceDas.useBalanceByCAS(balanceEo.getUserId(), balanceEo.getVersion(), reqDto.getPayAmount());
        Assert.isTrue((data == 1 ? 1 : 0) != 0, (String)("\u6263\u51cf\u8fd4\u5229\u5931\u8d25,\u8fd4\u5229\u4f59\u989d\u4e0d\u8db3,\u7528\u6237id" + reqDto.getUserId()), (Object[])new Object[0]);
        String changeType = reqDto.getChangeType() == null ? ChangeTypeEnum.CREATE_ORDER.toCode() : reqDto.getChangeType();
        BigDecimal needAmount = reqDto.getPayAmount();
        for (OrderEo orderEo : orderEos) {
            if (needAmount.compareTo(BigDecimal.ZERO) <= 0) {
                logger.info("\u8ba1\u7b97\u8fd4\u5229:\u67e5\u627e\u8fd4\u5229\u5355\u6240\u9700\u91d1\u989d\u5df2\u591f[{}]", (Object)JSON.toJSONString((Object)orderEos));
                break;
            }
            if (orderEo.getBalance().compareTo(BigDecimal.ZERO) < 0) continue;
            BigDecimal useAmount = needAmount.min(orderEo.getBalance());
            int j = this.orderDas.useBalanceByCAS(orderEo.getId(), orderEo.getVersion(), useAmount, Integer.valueOf(1));
            Assert.isTrue((j >= 1 ? 1 : 0) != 0, (String)("\u66f4\u65b0\u8fd4\u5229\u5355\u5931\u8d25,\u8fd4\u5229\u5355id[]" + orderEo.getId()), (Object[])new Object[0]);
            BigDecimal balance = Optional.ofNullable(orderEo.getBalance()).orElse(BigDecimal.ZERO);
            RebateUseLogEo rebateUseLogEo = new RebateUseLogEo();
            rebateUseLogEo.setOrderNo(reqDto.getOrderNo());
            rebateUseLogEo.setChangeType(changeType);
            rebateUseLogEo.setBusinessNo(reqDto.getOrderNo());
            rebateUseLogEo.setRebateNo(orderEo.getRebateNo());
            rebateUseLogEo.setRebateUseAmount(BigDecimal.ZERO.subtract(useAmount));
            rebateUseLogEo.setOldOrderBalance(orderEo.getBalance());
            rebateUseLogEo.setNewOrderBalance(balance.subtract(useAmount));
            this.rebateUseLogDas.insert((BaseEo)rebateUseLogEo);
            needAmount = needAmount.subtract(useAmount);
        }
        if (needAmount.compareTo(BigDecimal.ZERO) != 0) {
            logger.error("\u53ef\u7528\u8fd4\u5229\u5355\u53ef\u7528\u91d1\u989d\u4e0d\u8db3,\u5ba2\u6237id\uff1a{}", (Object)reqDto.getUserId());
            throw new BizException("\u53ef\u7528\u8fd4\u5229\u5355\u53ef\u7528\u91d1\u989d\u4e0d\u8db3\u3002");
        }
        RebateTypeEnum rebateType = RebateTypeEnum.ORDER_USE;
        String businessNo = reqDto.getOrderNo();
        if (changeType.equals(ChangeTypeEnum.REBATE_NEGATIVE.toCode())) {
            rebateType = RebateTypeEnum.REFUND;
            businessNo = reqDto.getBusinessNo();
        }
        this.getRebateDetailEo(balanceEo.getRebateAccountNo(), balanceEo.getUserName(), null, businessNo, BigDecimal.ZERO.subtract(reqDto.getPayAmount()), rebateType, reqDto.getUserId(), balanceEo.getBalance());
        return balancePayRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BalancePayRespDto returnBalance(BalanceReturnReqDto reqDto) {
        logger.info("\u8fd4\u5229\u9000\u56de\u5f00\u59cb:[{}]\u67e5\u627e\u8fd4\u5229\u4f7f\u7528\u8bb0\u5f55\u65e5\u5fd7\u8f93\u51fa[{}]", (Object)reqDto.getOrderNo(), (Object)JSON.toJSONString((Object)reqDto));
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), "rebate_balance_lock:" + reqDto.getUserId(), 2000, 1000, TimeUnit.MILLISECONDS);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getRefundNo())) {
            RebateUseLogEo selectItemRebateUseLog = new RebateUseLogEo();
            selectItemRebateUseLog.setBusinessNo(reqDto.getRefundNo());
            List rebateUseLogEos = this.rebateUseLogDas.selectList((BaseEo)selectItemRebateUseLog);
            if (!CollectionUtils.isEmpty((Collection)rebateUseLogEos)) {
                BalancePayRespDto balancePayRespDto = new BalancePayRespDto();
                balancePayRespDto.setMsg("\u8be5\u9000\u6b3e\u5355\u5df2\u5b8c\u6210\u9000\u6b3e" + reqDto.getRefundNo());
                balancePayRespDto.setCode(SUCCESS_CODE);
                logger.info("\u8fd4\u5229\u9000\u56de\u5f00\u59cb:[{}]\u8be5\u9000\u6b3e\u5355\u5df2\u5b8c\u6210\u9000\u6b3e[{}]", (Object)reqDto.getOrderNo(), (Object)JSON.toJSONString((Object)rebateUseLogEos));
                return balancePayRespDto;
            }
        }
        BalancePayRespDto respDto = null;
        BalanceEo balanceEo = this.balanceDas.queryCustomerAccountByUserId(reqDto.getUserId());
        Assert.notNull((Object)balanceEo, (String)("\u8fd4\u5229\u8d26\u53f7\u4e3a\u7a7auserId:" + reqDto.getUserId()), (Object[])new Object[0]);
        try {
            respDto = this.returnBalance0(reqDto, balanceEo);
            this.lockService.unlock(lock);
        }
        catch (Exception e) {
            logger.info("\u5931\u8d25\u539f\u56e0" + e.toString());
            this.lockService.unlock(lock);
            throw e;
        }
        return respDto;
    }

    public BalancePayRespDto returnBalance0(BalanceReturnReqDto reqDto, BalanceEo balanceEo) {
        List rebateUseLogEos = this.rebateUseLogDas.getRebateUseLogEos(reqDto.getOrderNo());
        BalancePayRespDto balancePayRespDto = this.checkRefundAmount(reqDto, rebateUseLogEos);
        Map<String, List<RebateUseLogEo>> rebateUseLogMapByRebateNo = rebateUseLogEos.stream().collect(Collectors.groupingBy(StdRebateUseLogEo::getRebateNo, Collectors.toList()));
        Map<String, BigDecimal> orderReturnAmountMapByRebateNo = this.getReturnAmountMapByRebateNo(rebateUseLogMapByRebateNo, reqDto.getReturnAmount());
        Set orderNos = rebateUseLogEos.stream().map(StdRebateUseLogEo::getRebateNo).collect(Collectors.toSet());
        Map orderMapByRebateNo = this.orderDas.getOrderMapByOrderNos(orderNos);
        RebateTypeEnum rebateTypeEnum = RebateTypeEnum.REFUND;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getChangeType()) && ("CANCEL_ORDER".equals(reqDto.getChangeType()) || "CLOSE_ORDER".equals(reqDto.getChangeType()))) {
            rebateTypeEnum = RebateTypeEnum.CANCEL;
        }
        RebateDetailEo rebateDetailEo = this.getRebateDetailEo(balanceEo.getRebateAccountNo(), balanceEo.getUserName(), null, reqDto.getOrderNo(), reqDto.getReturnAmount(), rebateTypeEnum, reqDto.getUserId(), balanceEo.getBalance());
        balanceEo.setBalance(rebateDetailEo.getBalanceSnapshot());
        Map<String, RebateUseLogEo> rebateUseLogEoMap = rebateUseLogEos.stream().collect(Collectors.toMap(StdRebateUseLogEo::getRebateNo, e -> e, (e1, e2) -> e1));
        for (Map.Entry<String, BigDecimal> rebateNoAndCanReturnAmount : orderReturnAmountMapByRebateNo.entrySet()) {
            RebateUseLogEo rebateUseLogEo = rebateUseLogEoMap.get(rebateNoAndCanReturnAmount.getKey());
            this.buildLogData(reqDto, rebateUseLogEo, rebateNoAndCanReturnAmount, orderMapByRebateNo, balanceEo);
        }
        return balancePayRespDto;
    }

    private BalancePayRespDto checkRefundAmount(BalanceReturnReqDto reqDto, List<RebateUseLogEo> rebateUseLogEos) {
        Assert.isTrue((reqDto != null ? 1 : 0) != 0, (String)"\u8bf7\u6c42dto\u4e0d\u53ef\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(rebateUseLogEos), (String)"\u9a8c\u8bc1\u662f\u5426\u53ef\u9000:\u627e\u4e0d\u5230\u8ba2\u5355\u8fd4\u5229\u4f7f\u7528\u8bb0\u5f55", (Object[])new Object[0]);
        BigDecimal waitReturn = reqDto.getReturnAmount().compareTo(BigDecimal.ZERO) < 0 ? reqDto.getReturnAmount().negate() : reqDto.getReturnAmount();
        BalancePayRespDto balancePayRespDto = new BalancePayRespDto();
        balancePayRespDto.setCode(SUCCESS_CODE);
        BigDecimal totalCanReturnAmount = rebateUseLogEos.stream().map(item -> item.getRebateUseAmount() == null ? BigDecimal.ZERO : item.getRebateUseAmount()).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
        Assert.isTrue((totalCanReturnAmount.compareTo(waitReturn) >= 0 ? 1 : 0) != 0, (String)("\u9a8c\u8bc1\u5f85\u8fd4\u91d1\u989d[" + totalCanReturnAmount + "]\u662f\u5426\u8db3\u591f:\u5f85\u8fd4\u91d1\u989d\u4e0d\u8db3\u4ee5\u652f\u4ed8\u672c\u6b21\u9000\u6b3e[" + waitReturn + "]"), (Object[])new Object[0]);
        return balancePayRespDto;
    }

    private void buildLogData(BalanceReturnReqDto reqDto, RebateUseLogEo oldRebateUseLogEo, Map.Entry<String, BigDecimal> rebateNoAndCanReturnAmount, Map<String, List<OrderEo>> orderMapByRebateNo, BalanceEo balanceEo) {
        boolean isOverDue;
        reqDto = reqDto == null ? new BalanceReturnReqDto() : reqDto;
        Assert.notNull((Object)oldRebateUseLogEo, (String)"rebateUseLogEo\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((rebateNoAndCanReturnAmount != null ? 1 : 0) != 0, (String)"rebateNoAndCanReturnAmount\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderEo orderEo = orderMapByRebateNo.get(rebateNoAndCanReturnAmount.getKey()).get(0);
        BigDecimal balance = Optional.ofNullable(orderEo.getBalance()).orElse(BigDecimal.ZERO);
        RebateUseLogEo rebateUseLogEo = new RebateUseLogEo();
        BeanUtils.copyProperties((Object)oldRebateUseLogEo, (Object)rebateUseLogEo, (String[])new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime"});
        rebateUseLogEo.setChangeType(reqDto.getChangeType());
        assert (rebateNoAndCanReturnAmount != null);
        rebateUseLogEo.setRebateUseAmount(rebateNoAndCanReturnAmount.getValue());
        rebateUseLogEo.setOldOrderBalance(balance);
        rebateUseLogEo.setNewOrderBalance(balance.add(rebateNoAndCanReturnAmount.getValue()));
        int insert = this.rebateUseLogDas.insert((BaseEo)rebateUseLogEo);
        Assert.isTrue((insert == 1 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u9000\u56de:\u65b0\u589e\u8fd4\u5229\u4f7f\u7528\u8bb0\u5f55\u5931\u8d25", (Object[])new Object[0]);
        Date date = new Date();
        int ii = this.orderDas.releaseBalanceById(orderEo.getId(), rebateNoAndCanReturnAmount.getValue(), orderEo.getVersion(), Integer.valueOf(1));
        Assert.isTrue((ii == 1 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u9000\u56de:\u6062\u590d\u8fd4\u5229\u5355\u989d\u5ea6\u5931\u8d25", (Object[])new Object[0]);
        boolean bl = isOverDue = orderEo.getEffectEndTime() != null && orderEo.getEffectEndTime().before(date);
        if (!isOverDue) {
            logger.info("\u8fd4\u5229\u9000\u56de:\u5904\u7406\u5b8c\u6210\u8fd4\u5229\u5355\u672a\u5931\u6548->\u6062\u590d\u8fd4\u5229\u5355\u4f7f\u7528\u989d\u5ea6/\u751f\u6210\u5355\u6761\u8d26\u53f7\u6d41\u6c34/\u6062\u590d\u8d26\u53f7\u989d\u5ea6[{}]", (Object)JSONObject.toJSONString((Object)orderEo));
            int i = this.balanceDas.releaseBalance(balanceEo.getId(), rebateNoAndCanReturnAmount.getValue());
            Assert.isTrue((i == 1 ? 1 : 0) != 0, (String)"\u8fd4\u5229\u9000\u56de:\u989d\u5ea6\u91ca\u653e\u5931\u8d25", (Object[])new Object[0]);
        } else {
            if (!Objects.equals(orderEo.getStatus(), RebateOrderStatusEnum.EXPIRED.getCode())) {
                OrderEo updateOrder = new OrderEo();
                updateOrder.setId(orderEo.getId());
                updateOrder.setStatus(RebateOrderStatusEnum.EXPIRED.getCode());
                this.orderDas.updateSelective((BaseEo)updateOrder);
            }
            balanceEo.setBalance(balanceEo.getBalance().subtract(rebateNoAndCanReturnAmount.getValue()));
            RebateDetailEo subRebateDetailEo = new RebateDetailEo();
            subRebateDetailEo.setBalanceSnapshot(balanceEo.getBalance());
            subRebateDetailEo.setBusinessNo(orderEo.getRebateNo());
            subRebateDetailEo.setRebateAccountNo(orderEo.getRebateAccountNo());
            subRebateDetailEo.setUserId(orderEo.getUserId());
            subRebateDetailEo.setUserType(orderEo.getUserType());
            subRebateDetailEo.setUserName(orderEo.getUserName());
            subRebateDetailEo.setChangeAmount(rebateNoAndCanReturnAmount.getValue().negate());
            subRebateDetailEo.setType(RebateTypeEnum.FAILURE.getType() + "");
            subRebateDetailEo.setExpiredTime(null);
            this.rebateDetailDas.insert((BaseEo)subRebateDetailEo);
        }
    }

    private RebateDetailEo getRebateDetailEo(String rebateAccountNo, String userName, Date effectEndTime, String orderNo, BigDecimal value, RebateTypeEnum refund, Long userId, BigDecimal actualBalance) {
        RebateDetailEo rebateDetail = new RebateDetailEo();
        rebateDetail.setBusinessNo(orderNo);
        rebateDetail.setChangeAmount(value);
        rebateDetail.setBalanceSnapshot(actualBalance.add(value));
        rebateDetail.setExpiredTime(effectEndTime);
        rebateDetail.setRebateAccountNo(rebateAccountNo);
        rebateDetail.setType(refund.getType() + "");
        rebateDetail.setUserId(userId);
        rebateDetail.setUserName(userName);
        rebateDetail.setUserType(UserTypeEnum.CUSTOMER.toCode());
        this.rebateDetailDas.insert((BaseEo)rebateDetail);
        return rebateDetail;
    }

    private Map<String, BigDecimal> getReturnAmountMapByRebateNo(Map<String, List<RebateUseLogEo>> rebateUseLogMapByRebateNo, BigDecimal waitReturnTotalAmount) {
        HashMap<String, BigDecimal> orderReturnAmountMapByRebateNo = new HashMap<String, BigDecimal>();
        Set<Map.Entry<String, List<RebateUseLogEo>>> entries = rebateUseLogMapByRebateNo.entrySet();
        for (Map.Entry<String, List<RebateUseLogEo>> entry : entries) {
            if (waitReturnTotalAmount.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal canReturnAmount = entry.getValue().stream().map(item -> BigDecimal.ZERO.subtract(item.getRebateUseAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (canReturnAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal bigReturnAmount = waitReturnTotalAmount.min(canReturnAmount);
            waitReturnTotalAmount = waitReturnTotalAmount.subtract(bigReturnAmount);
            orderReturnAmountMapByRebateNo.put(entry.getKey(), bigReturnAmount);
        }
        Assert.isTrue((!orderReturnAmountMapByRebateNo.isEmpty() ? 1 : 0) != 0, (String)"\u8ba1\u7b97\u6bcf\u4e2a\u8fd4\u5229\u5355\u53ef\u9000\u91d1\u989d\u5931\u8d25", (Object[])new Object[0]);
        return orderReturnAmountMapByRebateNo;
    }

    private List<OrderItemInfoDto> buildNotBlackItemRebate(List<OrderItemInfoDto> itemList, BigDecimal payAmount, BigDecimal waitGive) {
        if (waitGive != null && waitGive.compareTo(BigDecimal.ZERO) > 0) {
            HashMap<Long, BigDecimal> skuRebateMap = new HashMap<Long, BigDecimal>();
            List itemListNotBlack = itemList.stream().filter(data -> !data.getBlackItem()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(itemListNotBlack)) {
                BigDecimal rebateRatio = waitGive.divide(payAmount, 4).setScale(4, 1);
                BigDecimal haveGave = BigDecimal.ZERO;
                for (int i = 0; i < itemListNotBlack.size(); ++i) {
                    boolean isLast;
                    OrderItemInfoDto orderItemInfoDto = (OrderItemInfoDto)itemListNotBlack.get(i);
                    boolean bl = isLast = i == itemListNotBlack.size() - 1;
                    if (!isLast) {
                        BigDecimal thisAmount = orderItemInfoDto.getSellPrice().multiply(rebateRatio).setScale(2, 1);
                        skuRebateMap.put(orderItemInfoDto.getSkuId(), thisAmount);
                        haveGave = haveGave.add(thisAmount);
                        continue;
                    }
                    skuRebateMap.put(orderItemInfoDto.getSkuId(), waitGive.subtract(haveGave));
                }
            }
            Iterator<OrderItemInfoDto> iterator = itemList.iterator();
            while (iterator.hasNext()) {
                OrderItemInfoDto orderItemInfoDto;
                BigDecimal bigDecimal = (BigDecimal)skuRebateMap.get((orderItemInfoDto = iterator.next()).getSkuId());
                orderItemInfoDto.setDiscountAmount(bigDecimal == null ? BigDecimal.ZERO : bigDecimal);
            }
        }
        return itemList;
    }

    private BigDecimal getUseBalance(BigDecimal useRadio, BigDecimal thresholdAmount, BigDecimal accountBalance, BigDecimal oderPayAmountWithoutBlack) {
        boolean payAmountIsEnough;
        if (accountBalance.compareTo(BigDecimal.ZERO) <= 0 || oderPayAmountWithoutBlack.compareTo(BigDecimal.ZERO) <= 0) {
            BigDecimal newUseBalance = BigDecimal.ZERO;
            return newUseBalance;
        }
        if (thresholdAmount == null) {
            thresholdAmount = BigDecimal.ZERO;
        }
        boolean bl = payAmountIsEnough = thresholdAmount.compareTo(oderPayAmountWithoutBlack) <= 0;
        if (!payAmountIsEnough) {
            BigDecimal newUseBalance = BigDecimal.ZERO;
            return newUseBalance;
        }
        BigDecimal maxUse = oderPayAmountWithoutBlack;
        if (useRadio == null) {
            useRadio = BigDecimal.valueOf(100L);
        }
        maxUse = useRadio.divide(new BigDecimal("100"), 2, 0).setScale(2, 4).multiply(oderPayAmountWithoutBlack);
        return accountBalance.min(maxUse);
    }

    private List<String> getUseInstStrings(String prefix, BigDecimal useRadio, BigDecimal thresholdAmount, boolean isNotBlackProduct) {
        ArrayList<String> useInst = new ArrayList<String>();
        StringBuilder condition = new StringBuilder();
        if (thresholdAmount != null) {
            String filterOne = "";
            filterOne = StringUtils.isNotBlank((CharSequence)prefix) ? prefix + ",\u5e94\u4ed8\u91d1\u989d\u8fbe\u5230%s\u5143\u65f6\u53ef\u4ee5\u4f7f\u7528\uff1b" : "\u5e94\u4ed8\u91d1\u989d\u8fbe\u5230%s\u5143\u65f6\u53ef\u4ee5\u4f7f\u7528\uff1b";
            filterOne = String.format(filterOne, thresholdAmount.setScale(2, 1));
            condition.append(filterOne);
        }
        if (useRadio != null) {
            String filterTwo = "\u6700\u9ad8\u4e0d\u8d85\u8fc7%s";
            filterTwo = String.format(filterTwo, useRadio) + "%\uff1b";
            condition.append(filterTwo);
        }
        if (!isNotBlackProduct) {
            String filterThree = "\u8ba2\u5355\u4e2d\u5305\u542b\u4e0d\u53ef\u4f7f\u7528\u6298\u6263\u7684" + prefix;
            condition.append(filterThree);
        }
        if (StringUtils.isNotBlank((CharSequence)prefix) && useRadio == null && thresholdAmount == null) {
            String filter = prefix + "\u65e0\u4f7f\u7528\u9650\u5236\uff1b";
            condition.append(filter);
        }
        useInst.add(condition.toString());
        return useInst;
    }

    private Map<String, List<RebateDetailEo>> queryRebateDetailByAccountNos(List<String> rebateAccountNos) {
        if (CollectionUtils.isNotEmpty(rebateAccountNos)) {
            ArrayList<SqlFilter> SqlFilters = new ArrayList<SqlFilter>();
            RebateDetailEo rebateDetailEo = new RebateDetailEo();
            SqlFilters.add(SqlFilter.in((String)"rebate_account_no", rebateAccountNos));
            rebateDetailEo.setSqlFilters(SqlFilters);
            List rebateDetailEos = this.rebateDetailDas.select((BaseEo)rebateDetailEo);
            if (CollectionUtils.isNotEmpty((Collection)rebateDetailEos)) {
                return rebateDetailEos.stream().collect(Collectors.groupingBy(StdRebateDetailEo::getRebateAccountNo));
            }
        }
        return null;
    }

    @Deprecated
    private RebateUseRuleSearchDto rebateUseRuleEngine(OrderRebateAmountQueryReqDto orderRebateAmountQueryReqDto) {
        ArrayList<RebateUseRuleSearchDto.BlackItem> list = new ArrayList<RebateUseRuleSearchDto.BlackItem>();
        RebateUseRuleSearchDto.BlackItem rebateUseRuleSearchDtoBlackItem = new RebateUseRuleSearchDto.BlackItem();
        rebateUseRuleSearchDtoBlackItem.setItemId(Long.valueOf(1270062035429195174L));
        rebateUseRuleSearchDtoBlackItem.setSkuId(Long.valueOf(1270062035488964007L));
        rebateUseRuleSearchDtoBlackItem.setName("\u7ea2\u7c73K40");
        list.add(rebateUseRuleSearchDtoBlackItem);
        RebateUseRuleSearchDto rebateUseRuleSearchDto = new RebateUseRuleSearchDto();
        rebateUseRuleSearchDto.setBlackItems(list);
        rebateUseRuleSearchDto.setCustomerAreaCodes(null);
        rebateUseRuleSearchDto.setCustomerDimension(null);
        rebateUseRuleSearchDto.setCustomerGroupIds(null);
        rebateUseRuleSearchDto.setCustomerIds(null);
        rebateUseRuleSearchDto.setCustomerTypeIds(null);
        rebateUseRuleSearchDto.setRuleId(Long.valueOf(1L));
        rebateUseRuleSearchDto.setStatus(null);
        ArrayList rules = new ArrayList();
        RebateUseRuleSearchItemDto itemDto = new RebateUseRuleSearchItemDto();
        itemDto.setType(RuleUseObjectTypeEnum.ALL.toCode());
        itemDto.setThresholdAmount(new BigDecimal("100"));
        itemDto.setUseRadio(new BigDecimal("50"));
        rebateUseRuleSearchDto.setRules(rules);
        return rebateUseRuleSearchDto;
    }

    @Override
    @Transactional
    public void saveNegativeRebate(BalanceNegativeReqDto nagitiveBalanceReqDto, PreSettlementEo preSettlementEo) {
        Assert.notNull((Object)nagitiveBalanceReqDto.getUserId(), (String)"\u7528\u6237ID\u4e3a\u7a7a", (Object[])new Object[0]);
        BalanceEo selectItemBalance = new BalanceEo();
        selectItemBalance.setUserId(nagitiveBalanceReqDto.getUserId());
        BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectOne((BaseEo)selectItemBalance);
        if (balanceEo == null) {
            throw new BizException("\u627e\u4e0d\u5230\u7528\u6237\u8d26\u53f7");
        }
        int data = this.rbBalanceDas.useBalanceWithNegative(balanceEo.getId(), nagitiveBalanceReqDto.getPayAmount());
        Assert.isTrue((data == 1 ? 1 : 0) != 0, (String)("\u6263\u51cf\u8fd4\u5229\u5931\u8d25,\u8fd4\u5229\u4f59\u989d\u4e0d\u8db3,\u7528\u6237id" + nagitiveBalanceReqDto.getUserId()), (Object[])new Object[0]);
        OrderEo orderEo = this.orderService.genNegativeOrder(preSettlementEo, nagitiveBalanceReqDto);
        RebateUseLogEo rebateUseLogEo = new RebateUseLogEo();
        rebateUseLogEo.setOrderNo(nagitiveBalanceReqDto.getOrderNo());
        rebateUseLogEo.setChangeType(nagitiveBalanceReqDto.getChangeType());
        rebateUseLogEo.setBusinessNo(nagitiveBalanceReqDto.getBusinessNo());
        rebateUseLogEo.setRebateNo(orderEo.getRebateNo());
        rebateUseLogEo.setRebateUseAmount(BigDecimal.ZERO.subtract(nagitiveBalanceReqDto.getPayAmount()));
        this.rebateUseLogDas.insert((BaseEo)rebateUseLogEo);
        this.getRebateDetailEo(balanceEo.getRebateAccountNo(), preSettlementEo.getUserName(), orderEo.getEffectEndTime(), nagitiveBalanceReqDto.getBusinessNo(), BigDecimal.ZERO.subtract(nagitiveBalanceReqDto.getPayAmount()), RebateTypeEnum.REFUND, nagitiveBalanceReqDto.getUserId(), balanceEo.getBalance());
    }

    @Override
    public BalanceGroupRespDto queryBalanceByOrganizationId() {
        BalanceGroupRespDto result = new BalanceGroupRespDto();
        result.setTotalAmount(BigDecimal.ZERO);
        List customers = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCustomerIdsByUserId(this.iContext.userId()));
        logger.info("\u5ba2\u6237id\uff1a{}", (Object)JSON.toJSONString((Object)customers));
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customers));
        Map<Long, CustomerRespDto> customerHashMap = customerRespDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, item -> item, (oldVal, newVal) -> newVal));
        List merchantIds = customerRespDtoList.stream().map(CustomerRespDto::getMerchantId).collect(Collectors.toList());
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setOrgInfoIds(merchantIds);
        RestResponse merchantResponse = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List merchantList = (List)RestResponseHelper.extractData((RestResponse)merchantResponse);
        Map<Long, CustomerRespDto> merchantHashMap = merchantList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, item -> item, (oldVal, newVal) -> newVal));
        List balanceList = this.balanceDas.selectListByCustomerIds(customers);
        if (CollectionUtils.isEmpty((Collection)balanceList)) {
            return result;
        }
        balanceList.forEach(balanceRespDto -> {
            CustomerRespDto merchantDto;
            BigDecimal balance = this.balanceDas.selectActualBalanceByUserId(balanceRespDto.getUserId().longValue());
            balanceRespDto.setBalance(balance);
            CustomerRespDto customerRespDto = (CustomerRespDto)customerHashMap.get(balanceRespDto.getUserId());
            if (customerRespDto != null && (merchantDto = (CustomerRespDto)merchantHashMap.get(customerRespDto.getMerchantId())) != null) {
                balanceRespDto.setMerchantId(merchantDto.getOrgInfoId());
                balanceRespDto.setMerchantName(merchantDto.getName());
            }
        });
        BigDecimal totalAmount = balanceList.stream().map(BalanceRespDto::getBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
        result.setTotalAmount(totalAmount);
        result.setBalanceList(balanceList);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BalancePayRespDto rechargeBalance(BalanceReturnRechargeReqDto reqDto) {
        BalancePayRespDto balancePayRespDto = new BalancePayRespDto();
        Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), "rebate_balance_lock:" + reqDto.getRefundNo(), 2000, 1000, TimeUnit.MILLISECONDS);
        try {
            balancePayRespDto = this.rechargeBalance0(reqDto);
            this.lockService.unlock(lock);
        }
        catch (Exception e) {
            logger.info("\u5931\u8d25\u539f\u56e0" + e.toString());
            this.lockService.unlock(lock);
            throw e;
        }
        balancePayRespDto.setCode(SUCCESS_CODE);
        return balancePayRespDto;
    }

    public BalancePayRespDto rechargeBalance0(BalanceReturnRechargeReqDto reqDto) {
        RebateDetailEo detailEo = new RebateDetailEo();
        detailEo.setBusinessNo(reqDto.getOrderNo());
        detailEo.setType(RebateTypeEnum.REFUND.getType() + "");
        detailEo.setChangeAmount(reqDto.getRechargeAmount());
        List detailEoList = this.rebateDetailDas.select((BaseEo)detailEo, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            BalancePayRespDto balancePayRespDto = new BalancePayRespDto();
            balancePayRespDto.setMsg("\u8be5\u9000\u6b3e\u5355\u5df2\u5b8c\u6210\u9000\u6b3e" + reqDto.getRefundNo());
            balancePayRespDto.setCode(SUCCESS_CODE);
            logger.info("\u8fd4\u5229\u9000\u56de\u5f00\u59cb:[{}]\u8be5\u9000\u6b3e\u5355\u5df2\u5b8c\u6210\u9000\u6b3e[{}]", (Object)reqDto.getRefundNo(), (Object)JSON.toJSONString((Object)reqDto));
            return balancePayRespDto;
        }
        BalanceEo balanceEo = this.balanceDas.queryCustomerAccountByUserId(reqDto.getUserId());
        Assert.notNull((Object)balanceEo, (String)("\u8fd4\u5229\u8d26\u53f7\u4e3a\u7a7auserId:" + reqDto.getUserId()), (Object[])new Object[0]);
        Mutex balanceLock = this.lockService.lock(this.getClass().getSimpleName(), "rebate_balance_lock:" + balanceEo.getUserId(), 2000, 1000, TimeUnit.MILLISECONDS);
        if (reqDto.getRechargeAmount() != null && reqDto.getRechargeAmount().compareTo(BigDecimal.ZERO) != 0) {
            OrderEo orderEo = new OrderEo();
            String rebateNo = RebateUtil.generateRebateAccountNo("RB");
            orderEo.setRebateNo(rebateNo);
            orderEo.setRebateAmount(reqDto.getRechargeAmount());
            orderEo.setUseEffectType(Integer.valueOf(1));
            orderEo.setUserType(UserTypeEnum.CUSTOMER.toCode());
            orderEo.setUserId(balanceEo.getUserId());
            orderEo.setUserName(balanceEo.getUserName());
            orderEo.setOrganizationId(balanceEo.getOrganizationId());
            orderEo.setOrganizationName(balanceEo.getOrganizationName());
            orderEo.setStatus(RebateOrderStatusEnum.ISSUED.getCode());
            orderEo.setIssueTime(new Date());
            orderEo.setAuditTime(new Date());
            orderEo.setEffectBeginTime(new Date());
            orderEo.setBelongTo("-1");
            orderEo.setActualAmount(reqDto.getRechargeAmount());
            orderEo.setBalance(reqDto.getRechargeAmount());
            orderEo.setRebateAccountNo(balanceEo.getRebateAccountNo());
            orderEo.setRemark("\u8ba2\u5355\u9000\u6b3e\u5145\u503c\uff0c\u9000\u8ba2\u5355\u53f7\uff1a" + reqDto.getRefundNo() + ",\u539f\u8ba2\u5355\u53f7:" + reqDto.getOrderNo());
            this.orderDas.insert((BaseEo)orderEo);
            this.getRebateDetailEo(balanceEo.getRebateAccountNo(), balanceEo.getUserName(), null, reqDto.getOrderNo(), reqDto.getRechargeAmount(), RebateTypeEnum.REFUND, balanceEo.getUserId(), balanceEo.getBalance());
            int j = this.balanceDas.releaseBalanceByCAS(balanceEo.getId(), balanceEo.getVersion(), reqDto.getRechargeAmount());
            Assert.isTrue((j == 1 ? 1 : 0) != 0, (String)"\u6298\u6263\u9000\u56de:\u5145\u503c\u91d1\u989d\u5931\u8d25", (Object[])new Object[0]);
        }
        this.lockService.unlock(balanceLock);
        BalancePayRespDto balancePayRespDto = new BalancePayRespDto();
        balancePayRespDto.setCode(SUCCESS_CODE);
        return balancePayRespDto;
    }

    @Override
    public void updateBalanceCustomerInfo(CustomerRespDto customerRespDto) {
        BalanceEo balanceEo = this.balanceDas.queryCustomerAccountByUserId(customerRespDto.getId());
        if (balanceEo != null && !balanceEo.getUserName().equals(customerRespDto.getName())) {
            balanceEo.setUserName(customerRespDto.getName());
            this.balanceDas.updateSelective((BaseEo)balanceEo);
        }
    }
}

