/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.CategoryAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.CategoryModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.CategoryQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.CategoryRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.exception.RebateExceptionCode;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.ICategoryService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.gateway.OrganizationGateway;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.CategoryDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.CategoryEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CategoryServiceImpl
implements ICategoryService {
    @Resource
    private CategoryDas categoryDas;
    @Autowired
    private IContext iContext;
    @Resource
    private PolicyDas policyDas;
    @Resource
    private OrderDas orderDas;
    @Resource
    private OrganizationGateway organizationGateway;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCategory(CategoryAddReqDto reqDto) {
        reqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
        RestResponse orgAndOrgInfoRespDtoRestResponse = this.organizationQueryApi.queryOrgAndOrgInfo(reqDto.getOrganizationId());
        OrgAndOrgInfoRespDto orgAndOrgInfoRespData = (OrgAndOrgInfoRespDto)orgAndOrgInfoRespDtoRestResponse.getData();
        if (null != orgAndOrgInfoRespData && null != orgAndOrgInfoRespData.getOrganizationDto()) {
            reqDto.setOrganizationName(orgAndOrgInfoRespData.getOrganizationDto().getName());
        }
        if (this.checkSameParam(null, reqDto.getOrganizationId(), reqDto.getName(), null)) {
            throw new BizException(RebateExceptionCode.CATEGORY_PARAM_EXISTS.getCode(), String.format(RebateExceptionCode.CATEGORY_PARAM_EXISTS.getMsg(), "\u540d\u79f0"));
        }
        if (this.checkSameParam(null, reqDto.getOrganizationId(), null, reqDto.getCode())) {
            throw new BizException(RebateExceptionCode.CATEGORY_PARAM_EXISTS.getCode(), String.format(RebateExceptionCode.CATEGORY_PARAM_EXISTS.getMsg(), "\u7f16\u7801"));
        }
        CategoryEo rbCategoryEo = new CategoryEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rbCategoryEo);
        if (rbCategoryEo.getParentId() == null) {
            rbCategoryEo.setParentId(Long.valueOf(0L));
        }
        this.categoryDas.insert((BaseEo)rbCategoryEo);
        return rbCategoryEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCategory(CategoryModifyReqDto reqDto) {
        if (this.checkSameParam(reqDto.getId(), this.organizationGateway.getOrganizationId(), reqDto.getName(), null)) {
            throw new BizException(RebateExceptionCode.CATEGORY_PARAM_EXISTS.getCode(), String.format(RebateExceptionCode.CATEGORY_PARAM_EXISTS.getMsg(), "\u540d\u79f0"));
        }
        if (this.checkSameParam(reqDto.getId(), this.organizationGateway.getOrganizationId(), null, reqDto.getCode())) {
            throw new BizException(RebateExceptionCode.CATEGORY_PARAM_EXISTS.getCode(), String.format(RebateExceptionCode.CATEGORY_PARAM_EXISTS.getMsg(), "\u7f16\u7801"));
        }
        CategoryEo rbCategoryEo = new CategoryEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rbCategoryEo);
        this.categoryDas.updateSelective((BaseEo)rbCategoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCategory(String id) {
        ArrayList<Long> allCategoryId = new ArrayList<Long>();
        allCategoryId.add(Long.valueOf(id));
        this.getIds(Long.valueOf(id), allCategoryId);
        int result = this.policyDas.countPolicyByCategoryIds(allCategoryId);
        if (result > 0) {
            throw new BizException("\u8be5\u5206\u7c7b\u6216\u5b50\u5206\u7c7b\u5df2\u6302\u9760\u8fd4\u5229\u653f\u7b56\uff0c\u6682\u65e0\u6cd5\u5220\u9664\uff01");
        }
        Integer exist = this.orderDas.existOrderByCategoryIds(allCategoryId);
        if (exist != null) {
            throw new BizException("\u8be5\u5206\u7c7b\u6216\u5b50\u5206\u7c7b\u5df2\u5173\u8054\u6298\u6263\u5145\u503c\u5355\uff0c\u6682\u65e0\u6cd5\u5220\u9664\uff01");
        }
        for (Long subId : allCategoryId) {
            this.categoryDas.logicDeleteById(subId);
        }
    }

    @Override
    public CategoryRespDto queryCategoryById(Long id) {
        CategoryEo categoryEo = (CategoryEo)this.categoryDas.selectByPrimaryKey(id);
        if (categoryEo == null) {
            return null;
        }
        CategoryRespDto categoryRespDto = new CategoryRespDto();
        DtoHelper.eo2Dto((BaseEo)categoryEo, (BaseVo)categoryRespDto);
        return categoryRespDto;
    }

    @Override
    public PageInfo<CategoryRespDto> queryCategoryByPage(CategoryQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        if (this.organizationGateway.getOrganizationId() != null) {
            reqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
        }
        CategoryEo categoryEo = new CategoryEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)categoryEo);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List categoryRespList = this.categoryDas.selectByParentId(0L, reqDto);
        for (CategoryRespDto respDto : categoryRespList) {
            this.selectChildCategory(respDto, reqDto);
        }
        return new PageInfo(categoryRespList);
    }

    @Override
    public boolean isExist(Long categoryId) {
        return this.categoryDas.selectByPrimaryKey(categoryId) != null;
    }

    @Override
    public CategoryRespDto queryParentCategoryById(Long id) {
        ArrayList<CategoryRespDto> categoryEoList = new ArrayList<CategoryRespDto>();
        this.selectParentCategory(categoryEoList, id);
        List<CategoryRespDto> result = this.list2Tree(categoryEoList, 0L);
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<CategoryRespDto> list2Tree(List<CategoryRespDto> list, Long pId) {
        ArrayList<CategoryRespDto> tree = new ArrayList<CategoryRespDto>();
        Iterator<CategoryRespDto> it = list.iterator();
        while (it.hasNext()) {
            CategoryRespDto m = it.next();
            if (!m.getParentId().equals(pId)) continue;
            tree.add(m);
            it.remove();
        }
        tree.forEach(n -> n.setChildren(this.list2Tree(list, n.getId())));
        return tree;
    }

    private void getIds(Long parentId, List<Long> ids) {
        CategoryEo condition = new CategoryEo();
        condition.setParentId(parentId);
        List list = this.categoryDas.selectList((BaseEo)condition);
        for (CategoryEo eo : list) {
            Long id = eo.getId();
            ids.add(id);
            this.getIds(id, ids);
        }
    }

    private void selectChildCategory(CategoryRespDto respDto, CategoryQueryReqDto reqDto) {
        CategoryEo condition = new CategoryEo();
        condition.setParentId(respDto.getId());
        List categoryRespList = this.categoryDas.selectByParentId(respDto.getId().longValue(), reqDto);
        respDto.setChildren(categoryRespList);
        for (CategoryRespDto resp : categoryRespList) {
            this.selectChildCategory(resp, reqDto);
        }
    }

    private void selectParentCategory(List<CategoryRespDto> categoryEoList, Long id) {
        CategoryEo categoryEo = (CategoryEo)this.categoryDas.selectByPrimaryKey(id);
        if (categoryEo == null || categoryEo.getParentId() == 0L) {
            return;
        }
        CategoryRespDto respDto = new CategoryRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)categoryEo, (String[])new String[0]);
        categoryEoList.add(respDto);
        CategoryEo parentCategoryEo = (CategoryEo)this.categoryDas.selectByPrimaryKey(categoryEo.getParentId());
        if (parentCategoryEo != null) {
            CategoryRespDto parentDto = new CategoryRespDto();
            CubeBeanUtils.copyProperties((Object)parentDto, (Object)parentCategoryEo, (String[])new String[0]);
            categoryEoList.add(parentDto);
            if (!parentCategoryEo.getId().equals(0L)) {
                this.selectParentCategory(categoryEoList, parentCategoryEo.getParentId());
            }
        }
    }

    private boolean checkSameParam(Long id, Long organizationId, String name, String code) {
        CategoryEo categoryEo = new CategoryEo();
        categoryEo.setName(name);
        categoryEo.setCode(code);
        categoryEo.setTenantId(this.iContext.tenantId());
        categoryEo.setOrganizationId(organizationId);
        List categoryEoList = this.categoryDas.select((BaseEo)categoryEo);
        if (!CollectionUtils.isEmpty((Collection)categoryEoList) && id == null) {
            return true;
        }
        return id != null && !CollectionUtils.isEmpty((Collection)categoryEoList) && !((CategoryEo)categoryEoList.get(0)).getId().equals(id);
    }
}

