/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ExportTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.ExportBaseReqDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.ICommonService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.export.RebateBalanceExport;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.export.RebateFlowExport;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.export.RebateOrderTemplateExport;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.gateway.OrganizationGateway;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.BalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.CategoryDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateDetailDas;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ICommonServiceImpl
implements ICommonService {
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private IContext context;
    @Resource
    private RebateDetailDas rebateDetailDas;
    @Resource
    private BalanceDas balanceDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private CategoryDas categoryDas;
    @Resource
    private OrganizationGateway organizationGateway;

    @Override
    public String exportSearch(ExportBaseReqDto exportBaseReqDto) {
        switch (Objects.requireNonNull(ExportTypeEnum.fromCode((String)exportBaseReqDto.getExportType()))) {
            case REBATE_FLOW: {
                String fileName = "\u62b5\u6263\u8d26\u6237\u6d41\u6c34\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
                RebateFlowExport rebateFlowExport = new RebateFlowExport(fileName, "", this.objectStorageService, this.rebateDetailDas, exportBaseReqDto.getFilter(), this.context);
                return rebateFlowExport.getExportUrl();
            }
            case REBATE_BALANCE: {
                String fileNameTwo = "\u62b5\u6263\u4f59\u989d\u5217\u8868_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
                BalanceQueryReqDto balanceQueryReqDto = (BalanceQueryReqDto)JSON.parseObject((String)exportBaseReqDto.getFilter(), BalanceQueryReqDto.class);
                balanceQueryReqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
                RebateBalanceExport rebateBalanceExport = new RebateBalanceExport(fileNameTwo, "", this.objectStorageService, this.balanceDas, JSON.toJSONString((Object)balanceQueryReqDto), this.context);
                return rebateBalanceExport.getExportUrl();
            }
            case REBATE_ORDER_TEMPLATE: {
                String fileNameTemplate = "\u6298\u6263\u5145\u503c\u6a21\u677f_\u661f\u53f7\u4e3a\u5fc5\u586b\u9879_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
                RebateOrderTemplateExport templateExport = new RebateOrderTemplateExport(fileNameTemplate, "", this.objectStorageService, this.customerQueryApi, this.categoryDas, this.context);
                return templateExport.getExportUrl();
            }
        }
        return null;
    }
}

