/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderItemRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IOrderItemService;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderItemDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderItemEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderItemServiceImpl
implements IOrderItemService {
    @Resource
    private OrderItemDas orderItemDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOrderItem(OrderItemAddReqDto reqDto) {
        OrderItemEo orderItemEo = new OrderItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orderItemEo);
        this.orderItemDas.insert((BaseEo)orderItemEo);
        return orderItemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOrderItem(OrderItemModifyReqDto reqDto) {
        OrderItemEo orderItemEo = new OrderItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orderItemEo);
        this.orderItemDas.updateSelective((BaseEo)orderItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderItem(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderItemDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public OrderItemRespDto queryOrderItemById(Long id) {
        OrderItemEo orderItemEo = (OrderItemEo)this.orderItemDas.selectByPrimaryKey(id);
        if (orderItemEo == null) {
            return null;
        }
        OrderItemRespDto orderItemRespDto = new OrderItemRespDto();
        DtoHelper.eo2Dto((BaseEo)orderItemEo, (BaseVo)orderItemRespDto);
        return orderItemRespDto;
    }

    @Override
    public PageInfo<OrderItemRespDto> queryOrderItemByPage(OrderItemQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        OrderItemEo orderItemEo = new OrderItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)orderItemEo);
        PageInfo eoPageInfo = this.orderItemDas.selectPage((BaseEo)orderItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

