/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerGroupQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ItemDimensionEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebatePolicyStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.AccountRuleEsDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.ItemEsDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.PolicyEsDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.ItemBaseDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicySettleRuleRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicyEsService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicyService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicySettleRuleService;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.DateUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PolicyEsServiceImpl
implements IPolicyEsService {
    private static final Logger logger = LoggerFactory.getLogger(PolicyEsServiceImpl.class);
    @Autowired
    private ISearchIndexService searchIndexService;
    @Autowired
    private IOpenSearchService openSearchService;
    @Autowired
    private IPolicyService policyService;
    @Autowired
    private IPolicySettleRuleService policySettleRuleService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private ICustomerGroupQueryApi customerGroupQueryApi;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Autowired
    private IContext context;
    static String POLICY_INDEX_NAME = "rebate_policy_";
    static String POLICY_TYPE_NAME = "rebate_policy";

    @Override
    public PolicyEsDto queryById(Long policyId) {
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName(POLICY_INDEX_NAME + this.globalProfile);
        osSearchVo.setTypeName(POLICY_TYPE_NAME);
        osSearchVo.addEqualFilter("id", String.valueOf(policyId));
        SearchResultVo searchResultVo = this.openSearchService.search(osSearchVo);
        if (searchResultVo != null) {
            List tagDtos = searchResultVo.getDocValues().stream().map(doc -> {
                PolicyEsDto policyEsDto = (PolicyEsDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), PolicyEsDto.class);
                return policyEsDto;
            }).collect(Collectors.toList());
            return (PolicyEsDto)tagDtos.get(0);
        }
        return null;
    }

    @Override
    public PolicyEsDto queryByCondition(Long itemId, Long skuId, Long custId, Date orderTime) {
        try {
            OSSearchVo osSearchVo = new OSSearchVo();
            osSearchVo.setIndexName(POLICY_INDEX_NAME + this.globalProfile);
            osSearchVo.setTypeName(POLICY_TYPE_NAME);
            osSearchVo.addEqualFilter("policyStatus", RebatePolicyStatusEnum.AUDIT_PASS.getCode());
            osSearchVo.addRangeFilter("effectTime", null, DateUtil.getDateFormat(orderTime, DateUtil.DEFAULT_PATTERN));
            osSearchVo.addRangeFilter("failureTime", DateUtil.getDateFormat(orderTime, DateUtil.DEFAULT_PATTERN), null);
            FilterFieldVo customerCompFilter = this.buildCustCompFitler(osSearchVo, custId);
            FilterFieldVo itemCompFilter = this.buildItemCompFitler(osSearchVo, itemId, skuId);
            osSearchVo.addFilters(new FilterFieldVo[]{customerCompFilter});
            osSearchVo.addFilters(new FilterFieldVo[]{itemCompFilter});
            SearchResultVo searchResultVo = this.openSearchService.search(osSearchVo);
            if (searchResultVo != null) {
                List tagDtos = searchResultVo.getDocValues().stream().map(doc -> {
                    PolicyEsDto policyEsDto = (PolicyEsDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), PolicyEsDto.class);
                    return policyEsDto;
                }).collect(Collectors.toList());
                logger.info("\u67e5\u8be2\u7528\u6237\u4e0b\u5355\u7684\u5546\u54c1\u7684\u8fd4\u5229\u653f\u7b56\u6570\u91cf={}", (Object)tagDtos.size());
                return (PolicyEsDto)tagDtos.get(0);
            }
        }
        catch (Exception e) {
            logger.error("es\u67e5\u8be2\u9519\u8bef\uff1a={}", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public Long matchAccountRuleId(PolicyEsDto policyEsDto, String itemId, String skuId) {
        Long accountRuleId = null;
        if (!CollectionUtils.isEmpty((Collection)policyEsDto.getItems())) {
            for (ItemEsDto itemEsDto : policyEsDto.getItems()) {
                if (!itemEsDto.getSkuId().equals(Long.valueOf(skuId))) continue;
                accountRuleId = itemEsDto.getAccountRuleId();
                return accountRuleId;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)policyEsDto.getAccountRules())) {
            RestResponse itemResp = this.itemQueryApi.queryItemAndSku(Long.valueOf(itemId), Long.valueOf(skuId));
            Long itemDirId = ((ItemRespDto)itemResp.getData()).getDirId();
            Long brandId = ((ItemRespDto)itemResp.getData()).getBrandId();
            for (AccountRuleEsDto accountRuleEsDto : policyEsDto.getAccountRules()) {
                if (!accountRuleEsDto.getItemDimensionType().equals(ItemDimensionEnum.CATEGORY.getType()) || !this.accoutRuleContainCateAndBrandId(accountRuleEsDto, itemDirId, brandId)) continue;
                accountRuleId = accountRuleEsDto.getAccountRuleId();
                break;
            }
        }
        return accountRuleId;
    }

    private boolean accoutRuleContainCateAndBrandId(AccountRuleEsDto accountRuleEsDto, Long dirId, Long brandId) {
        boolean isBrandIdContain = false;
        boolean isDirIdContain = false;
        if (!CollectionUtils.isEmpty((Collection)accountRuleEsDto.getItemBrandIds()) && brandId != null) {
            isBrandIdContain = accountRuleEsDto.getItemBrandIds().contains(brandId);
        }
        if (accountRuleEsDto.getItemBrandIds().contains(-1L)) {
            isBrandIdContain = true;
        }
        isDirIdContain = !CollectionUtils.isEmpty((Collection)accountRuleEsDto.getItemCategoryIds()) ? accountRuleEsDto.getItemCategoryIds().contains(dirId) : true;
        return isBrandIdContain && isDirIdContain;
    }

    private FilterFieldVo buildItemCompFitler(OSSearchVo osSearchVo, Long itemId, Long skuId) {
        RestResponse itemResp = this.itemQueryApi.queryItemAndSku(itemId, skuId);
        Long itemDirId = ((ItemRespDto)itemResp.getData()).getDirId();
        Long brandId = ((ItemRespDto)itemResp.getData()).getBrandId();
        FilterFieldVo skuFilter = FilterFieldVo.equal((String)"items.skuId", (String)String.valueOf(skuId), (LogicalSymbol)LogicalSymbol.OR);
        FilterFieldVo itemDirFilter1 = FilterFieldVo.equal((String)"accountRules.itemCategoryIds", (String)String.valueOf(itemDirId), (LogicalSymbol)LogicalSymbol.OR);
        ArrayList<String> brandIds = new ArrayList<String>();
        brandIds.add("-1");
        if (brandId != null) {
            brandIds.add(String.valueOf(brandId));
        }
        FilterFieldVo itemBrandFilter1 = FilterFieldVo.in((String)"accountRules.itemBrandIds", brandIds, (LogicalSymbol)LogicalSymbol.OR);
        FilterFieldVo itemCompFilter = osSearchVo.createCompoundFilter(LogicalSymbol.OR);
        itemCompFilter.addSubFilterFieldVos(new FilterFieldVo[]{skuFilter, itemDirFilter1, itemBrandFilter1});
        return itemCompFilter;
    }

    private FilterFieldVo buildCustCompFitler(OSSearchVo osSearchVo, Long custId) {
        FilterFieldVo customerCompFilter1 = osSearchVo.createCompoundFilter(LogicalSymbol.AND);
        FilterFieldVo specialCustomerFilter = FilterFieldVo.equal((String)"customerDimension", (String)String.valueOf(CustomerDimensionEnum.SPECIFIED.getType()));
        FilterFieldVo custFilter = FilterFieldVo.equal((String)"customers.customerId", (String)String.valueOf(custId));
        customerCompFilter1.addSubFilterFieldVos(new FilterFieldVo[]{specialCustomerFilter, custFilter});
        return customerCompFilter1;
    }

    @Override
    public void create(Long policyId) {
        PolicyDetailRespDto policyRespDto = this.policyService.queryPolicyById(policyId);
        PolicyEsDto policyEsDto = new PolicyEsDto();
        policyEsDto.setPolicyId(policyId);
        this.convert2PolicyEsDto(policyEsDto, policyRespDto.getPolicy());
        IndexDocumentVo documentVo = new IndexDocumentVo(POLICY_INDEX_NAME + this.globalProfile, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(String.valueOf(policyId));
        Map docValueMap = CustomBeanUtils.describe((Object)policyEsDto);
        docContentVo.setDocValueMap(docValueMap);
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.addData(documentVo);
        logger.info("\u4fdd\u5b58\u653f\u7b56\u7d22\u5f15\u6210\u529f");
    }

    private void convert2PolicyEsDto(PolicyEsDto policyEsDto, PolicyRespDto respDto) {
        policyEsDto.setPolicyId(respDto.getId());
        policyEsDto.setPolicyStatus(respDto.getStatus());
        CubeBeanUtils.copyProperties((Object)policyEsDto, (Object)respDto, (String[])new String[0]);
        if (respDto.getFailureTime() == null) {
            policyEsDto.setFailureTime(DateUtil.setDateEnd(DateUtil.getDateAfter(new Date(), 18250)));
        }
        if (!CollectionUtils.isEmpty((Collection)respDto.getPolicySegmentList())) {
            respDto.getPolicySegmentList().forEach(accountRule -> {
                AccountRuleEsDto accountRuleEsDto = new AccountRuleEsDto();
                CubeBeanUtils.copyProperties((Object)accountRuleEsDto, (Object)accountRule, (String[])new String[0]);
                if (accountRuleEsDto.getAccountRuleId() == null) {
                    Long conditionId = accountRule.getConditionId();
                    PolicySettleRuleRespDto settleRuleEo = this.policySettleRuleService.queryByConditionIdAndPolicyId(respDto.getId(), conditionId);
                    accountRuleEsDto.setAccountRuleId(settleRuleEo.getId());
                    accountRule.setAccountRuleId(settleRuleEo.getId());
                }
                if (!CollectionUtils.isEmpty((Collection)accountRule.getItemBrandIds())) {
                    accountRuleEsDto.getItemBrandIds().addAll(accountRule.getItemBrandIds());
                } else {
                    accountRuleEsDto.getItemBrandIds().add(-1L);
                }
                if (!CollectionUtils.isEmpty((Collection)accountRule.getItemCategoryIds())) {
                    List<Long> allDirIds = this.getAllSubDirIds(accountRule.getItemCategoryIds());
                    accountRuleEsDto.getItemCategoryIds().addAll(allDirIds);
                }
                policyEsDto.getAccountRules().add(accountRuleEsDto);
                if (!CollectionUtils.isEmpty((Collection)accountRule.getItems())) {
                    for (ItemBaseDto item : accountRule.getItems()) {
                        ItemEsDto esDto = new ItemEsDto();
                        esDto.setAccountRuleId(accountRule.getAccountRuleId());
                        CubeBeanUtils.copyProperties((Object)esDto, (Object)item, (String[])new String[0]);
                        policyEsDto.getItems().add(esDto);
                    }
                }
            });
        }
    }

    private List<Long> getAllSubDirIds(List<Long> itemCategoryIds) {
        ArrayList<Long> res = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(itemCategoryIds)) {
            return res;
        }
        RootDirectoryReqDto rootDirectoryReqDto = new RootDirectoryReqDto();
        rootDirectoryReqDto.setInstanceId(this.context.instanceId());
        rootDirectoryReqDto.setTenantId(this.context.tenantId());
        rootDirectoryReqDto.setDirUsage("back");
        String filters = JSONObject.toJSONString((Object)rootDirectoryReqDto);
        List backDirTree = (List)this.directoryQueryApi.queryDirectoryTreeByFilter(filters).getData();
        if (!CollectionUtils.isEmpty((Collection)backDirTree)) {
            this.addbackDirId(backDirTree, itemCategoryIds, res);
        }
        return res;
    }

    private void addbackDirId(List<TreeDto<DirectoryItemRespDto>> backDirTree, List<Long> itemCategoryIds, List<Long> res) {
        backDirTree.forEach(node -> {
            if (!itemCategoryIds.contains(((DirectoryItemRespDto)node.getNode()).getId())) {
                if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
                    this.addbackDirId(node.getChildren(), itemCategoryIds, res);
                }
            } else {
                if (!res.contains(((DirectoryItemRespDto)node.getNode()).getId())) {
                    res.add(((DirectoryItemRespDto)node.getNode()).getId());
                }
                if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
                    this.recurAddChildDir(node.getChildren(), res);
                }
            }
        });
    }

    private void recurAddChildDir(List<TreeDto<DirectoryItemRespDto>> subTree, List<Long> res) {
        if (!CollectionUtils.isEmpty(subTree)) {
            subTree.forEach(node -> {
                if (!res.contains(((DirectoryItemRespDto)node.getNode()).getId())) {
                    res.add(((DirectoryItemRespDto)node.getNode()).getId());
                }
                if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
                    this.recurAddChildDir(node.getChildren(), res);
                }
            });
        }
    }

    @Override
    public void update(Long policyId) {
        PolicyDetailRespDto policyRespDto = this.policyService.queryPolicyById(policyId);
        PolicyEsDto policyEsDto = new PolicyEsDto();
        this.convert2PolicyEsDto(policyEsDto, policyRespDto.getPolicy());
        IndexDocumentVo documentVo = new IndexDocumentVo(POLICY_INDEX_NAME + this.globalProfile, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(String.valueOf(policyId));
        Map docValueMap = CustomBeanUtils.describe((Object)policyEsDto);
        docContentVo.setDocValueMap(docValueMap);
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.updateData(documentVo);
        logger.info("\u4fdd\u5b58\u653f\u7b56\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public void delete(Long policyId) {
        IndexDocumentVo documentVo = new IndexDocumentVo(POLICY_INDEX_NAME + this.globalProfile, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(policyId.toString());
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.deleteData(documentVo);
        logger.info("\u5220\u9664\u653f\u7b56\u7d22\u5f15\u6210\u529f");
    }
}

