/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.AccountingMethodEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.AccountingRuleEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.CompareOpEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.PolicyLogEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateCycleTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebatePolicyStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.PolicyEsDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.CustomerDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.ItemBaseDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyAuditReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyRebateRuleReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicySegmentReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyConstantsDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyListResDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyRebateRuleResDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.SelectDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.cube.center.rebate.biz.condition.RuleFactory;
import com.dtyunxi.yundt.cube.center.rebate.biz.condition.policy.PolicyAccountCondition;
import com.dtyunxi.yundt.cube.center.rebate.biz.constant.ConditionBusinessType;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IAttachmentService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.ICategoryService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicyEsService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicyLogService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicyService;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.ConvertUtil;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.RebateUtil;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.ConditionDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.PolicySettleRuleDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.ConditionEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PolicyEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PolicySettleRuleEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PolicyServiceImpl
implements IPolicyService {
    private static final Logger logger = LoggerFactory.getLogger(PolicyServiceImpl.class);
    public static final DateTime END_OF_TIME = new DateTime(9999, 1, 1, 0, 0, 0, DateTimeZone.UTC);
    @Resource
    private PolicyDas policyDas;
    @Resource
    private ConditionDas conditionDas;
    @Resource
    private IContext iContext;
    @Resource
    private PolicySettleRuleDas policySettleRuleDas;
    @Resource
    private ICategoryService categoryService;
    @Resource
    private IOpenSearchService openSearchService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private IPolicyLogService policyLogService;
    @Resource
    private IPolicyEsService policyEsService;
    @Resource
    private IAttachmentService attachmentService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPolicy(PolicyAddReqDto reqDto) {
        PolicyEo policyEo = new PolicyEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)policyEo);
        policyEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        boolean isExist = this.categoryService.isExist(reqDto.getCategoryId());
        if (!isExist) {
            throw new BizException("\u4e0d\u5b58\u5728ID\u4e3a:{} \u7684\u8fd4\u5229\u5206\u7c7b", reqDto.getCategoryId().toString());
        }
        if (null != reqDto.getOrganizationId()) {
            RestResponse result = this.organizationQueryApi.queryOrgAndOrgInfo(reqDto.getOrganizationId());
            OrgAndOrgInfoRespDto orgInfoRespDto = (OrgAndOrgInfoRespDto)result.getData();
            if (orgInfoRespDto == null) {
                throw new BizException("\u4e0d\u5b58\u5728ID\u4e3a:{} \u7684\u6240\u5c5e\u7ec4\u7ec7");
            }
            policyEo.setOrganizationName(orgInfoRespDto.getOrganizationDto().getName());
        }
        this.checkPolicyName(null, reqDto.getName());
        this.validatePolicy((PolicyRebateRuleReqDto)reqDto, null);
        if (reqDto.getDraft().booleanValue()) {
            policyEo.setStatus(RebatePolicyStatusEnum.DRAFT.getCode());
            this.policyLogService.log(policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), PolicyLogEnum.DRAFT.getDesc(), null);
        } else {
            policyEo.setStatus(RebatePolicyStatusEnum.WAIT_AUDIT.getCode());
            this.policyLogService.log(policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), PolicyLogEnum.SAVE.getDesc(), null);
        }
        policyEo.setCode(RebateUtil.generateRebatePolicyNo("FLZZ"));
        this.policyDas.insert((BaseEo)policyEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getAttachment())) {
            this.attachmentService.addPolicyAttachment(reqDto.getAttachment(), policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), policyEo.getName());
        }
        List<ConditionEo> conditions = this.dto2Condition(reqDto);
        for (ConditionEo conditionEo : conditions) {
            conditionEo.setBusinessId(policyEo.getId());
            this.conditionDas.insert((BaseEo)conditionEo);
            if (new PolicyAccountCondition().getConditionTemplateId() != conditionEo.getConditionTemplateId().longValue()) continue;
            PolicySettleRuleEo settleRuleEo = new PolicySettleRuleEo();
            settleRuleEo.setPolicyId(policyEo.getId());
            settleRuleEo.setConditionId(conditionEo.getId());
            this.policySettleRuleDas.insert((BaseEo)settleRuleEo);
        }
        this.policyEsService.create(policyEo.getId());
        return policyEo.getId();
    }

    private void validatePolicy(PolicyRebateRuleReqDto reqDto, Long id) {
        List<Object> policyEsDtos = this.searchRebatePolicy(reqDto);
        if (!CollectionUtils.isEmpty(policyEsDtos)) {
            if (null == id) {
                this.checkDate(reqDto, policyEsDtos);
            } else {
                policyEsDtos = policyEsDtos.stream().filter(bean -> !bean.getPolicyId().equals(id)).collect(Collectors.toList());
                this.checkDate(reqDto, policyEsDtos);
            }
        }
    }

    private void checkDate(PolicyRebateRuleReqDto reqDto, List<PolicyEsDto> policyEsDtos) {
        Date effectTime = reqDto.getEffectTime();
        Date failureTime = reqDto.getFailureTime();
        if (null == failureTime) {
            failureTime = END_OF_TIME.toDate();
        }
        for (PolicyEsDto policyEsDto : policyEsDtos) {
            Date effectTimeCom = policyEsDto.getEffectTime();
            Date failureTimeCom = policyEsDto.getFailureTime();
            if (null == failureTimeCom) {
                failureTimeCom = END_OF_TIME.toDate();
            }
            if (effectTime.getTime() > failureTimeCom.getTime() || failureTime.getTime() < effectTimeCom.getTime()) continue;
            throw new BizException("\u540c\u4e00\u5ba2\u6237\u3001\u540c\u4e00\u5546\u54c1sku\u3001\u540c\u4e00\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u591a\u6761\u5f85\u5ba1\u6838/\u751f\u6548\u4e2d/\u5f85\u751f\u6548\u7684\u8fd4\u5229\u653f\u7b56");
        }
    }

    private List<PolicyEsDto> searchRebatePolicy(PolicyRebateRuleReqDto reqDto) {
        SearchResultVo searchResultVo;
        List result = Lists.newArrayList();
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName("rebate_policy_" + this.globalProfile);
        osSearchVo.setTypeName("rebate_policy");
        if (null != reqDto.getCustomerDimension()) {
            osSearchVo.addEqualFilter("customerDimension", String.valueOf(reqDto.getCustomerDimension()));
        }
        if (CustomerDimensionEnum.SPECIFIED.getType().equals(reqDto.getCustomerDimension()) && !CollectionUtils.isEmpty((Collection)reqDto.getCustomers())) {
            List customerIds = reqDto.getCustomers().stream().map(CustomerDto::getCustomerId).collect(Collectors.toList());
            osSearchVo.addInFilter("customers.customerId", ConvertUtil.convert2Array(customerIds));
        }
        if (CustomerDimensionEnum.TYPE.getType().equals(reqDto.getCustomerDimension()) && !CollectionUtils.isEmpty((Collection)reqDto.getCustomerTypeIds())) {
            osSearchVo.addInFilter("customerTypeIds", ConvertUtil.convert2Array(reqDto.getCustomerTypeIds()));
        }
        if (CustomerDimensionEnum.GROUP.getType().equals(reqDto.getCustomerDimension()) && !CollectionUtils.isEmpty((Collection)reqDto.getCustomerGroupIds())) {
            osSearchVo.addInFilter("customerGroupIds", ConvertUtil.convert2Array(reqDto.getCustomerGroupIds()));
        }
        if (CustomerDimensionEnum.REGION.getType().equals(reqDto.getCustomerDimension()) && !CollectionUtils.isEmpty((Collection)reqDto.getCustomerAreaCodes())) {
            osSearchVo.addInFilter("customerAreaCodes", (String[])reqDto.getCustomerAreaCodes().toArray());
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getPolicySegmentList())) {
            List itemDimensionTypes = reqDto.getPolicySegmentList().stream().map(PolicySegmentReqDto::getItemDimensionType).collect(Collectors.toList());
            ArrayList skuIds = Lists.newArrayList();
            ArrayList brandIds = Lists.newArrayList();
            ArrayList categoryIds = Lists.newArrayList();
            reqDto.getPolicySegmentList().stream().forEach(bean -> {
                if (!CollectionUtils.isEmpty((Collection)bean.getItems())) {
                    List collect = bean.getItems().stream().map(ItemBaseDto::getSkuId).collect(Collectors.toList());
                    skuIds.addAll(collect);
                }
                if (!CollectionUtils.isEmpty((Collection)bean.getItemBrandIds())) {
                    brandIds.addAll(bean.getItemBrandIds());
                }
                if (!CollectionUtils.isEmpty((Collection)bean.getItemCategoryIds())) {
                    categoryIds.addAll(bean.getItemCategoryIds());
                }
            });
            if (!CollectionUtils.isEmpty(itemDimensionTypes)) {
                osSearchVo.addInFilter("accountRules.itemDimensionType", ConvertUtil.convert2Array(itemDimensionTypes));
            }
            if (!CollectionUtils.isEmpty((Collection)skuIds)) {
                osSearchVo.addInFilter("items.skuId", ConvertUtil.convert2Array(skuIds));
            }
            if (!CollectionUtils.isEmpty((Collection)brandIds)) {
                osSearchVo.addInFilter("accountRules.itemBrandIds", ConvertUtil.convert2Array(brandIds));
            }
            if (!CollectionUtils.isEmpty((Collection)categoryIds)) {
                osSearchVo.addInFilter("accountRules.itemCategoryIds", ConvertUtil.convert2Array(categoryIds));
            }
        }
        if (null != (searchResultVo = this.openSearchService.search(osSearchVo))) {
            result = searchResultVo.getDocValues(docValue -> (PolicyEsDto)BeanUtil.mapToBean((Map)docValue, PolicyEsDto.class, (boolean)true));
        }
        return result;
    }

    private List<ConditionEo> dto2Condition(PolicyAddReqDto reqDto) {
        List<ConditionTemplate> conditionTemplates = RuleFactory.getTemplate(ConditionBusinessType.POLICY_REBATE_RULE);
        ArrayList<ConditionEo> result = new ArrayList<ConditionEo>();
        for (ConditionTemplate conditionTemplate : conditionTemplates) {
            if (conditionTemplate instanceof PolicyAccountCondition) {
                List policySegmentList = reqDto.getPolicySegmentList();
                for (PolicySegmentReqDto segmentReqDto : policySegmentList) {
                    ConditionReqDto conditionReqDto = conditionTemplate.convertToCondition(segmentReqDto);
                    ConditionEo conditionEo = new ConditionEo();
                    conditionEo.setId(segmentReqDto.getConditionId());
                    DtoHelper.dto2Eo((BaseVo)conditionReqDto, (BaseEo)conditionEo);
                    result.add(conditionEo);
                }
                continue;
            }
            ConditionReqDto conditionReqDto = conditionTemplate.convertToCondition(reqDto);
            ConditionEo conditionEo = new ConditionEo();
            DtoHelper.dto2Eo((BaseVo)conditionReqDto, (BaseEo)conditionEo);
            result.add(conditionEo);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPolicy(PolicyModifyReqDto reqDto) {
        boolean isCanModify;
        PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(reqDto.getId());
        if (policyEo == null) {
            throw new BizException("\u8fd4\u5229\u653f\u7b56\u4e0d\u5b58\u5728");
        }
        this.checkPolicyName(reqDto.getId(), reqDto.getName());
        this.validatePolicy((PolicyRebateRuleReqDto)reqDto, reqDto.getId());
        boolean bl = isCanModify = RebatePolicyStatusEnum.EFFECT.getCode().equals(policyEo.getStatus()) || RebatePolicyStatusEnum.WAIT_TAKE_EFFECT.getCode().equals(policyEo.getStatus()) || RebatePolicyStatusEnum.DRAFT.getCode().equals(policyEo.getStatus()) || RebatePolicyStatusEnum.AUDIT_REJECT.getCode().equals(policyEo.getStatus());
        if (!isCanModify) {
            throw new BizException("\u975e\u751f\u6548\u4e2d\u3001\u5f85\u751f\u6548\u3001\u8349\u7a3f\u3001\u5ba1\u6838\u4e0d\u901a\u8fc7\u72b6\u6001\uff0c\u8fd4\u5229\u653f\u7b56\u4e0d\u53ef\u7f16\u8f91\uff01");
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)policyEo);
        if (reqDto.getDraft().booleanValue()) {
            policyEo.setStatus(RebatePolicyStatusEnum.DRAFT.getCode());
        } else {
            policyEo.setStatus(RebatePolicyStatusEnum.WAIT_AUDIT.getCode());
        }
        this.policyDas.updateSelective((BaseEo)policyEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getAttachment())) {
            this.attachmentService.addPolicyAttachment(reqDto.getAttachment(), policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), policyEo.getName());
        }
        this.policyLogService.log(policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), PolicyLogEnum.EDIT.getDesc(), null);
        PolicyAddReqDto policyAddReqDto = new PolicyAddReqDto();
        CubeBeanUtils.copyProperties((Object)policyAddReqDto, (Object)reqDto, (String[])new String[0]);
        List<ConditionEo> conditions = this.dto2Condition(policyAddReqDto);
        conditions.forEach(conditionEo -> {
            conditionEo.setBusinessId(policyEo.getId());
            if (conditionEo.getId() != null) {
                this.conditionDas.updateSelective((BaseEo)conditionEo);
            } else {
                this.conditionDas.updateSelectiveByBusiness(conditionEo, ConditionBusinessType.POLICY_REBATE_RULE.getType());
            }
        });
        this.policyEsService.update(policyEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void toVoidPolicy(Long id) {
        PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(id);
        if (policyEo == null) {
            throw new BizException("\u8fd4\u5229\u653f\u7b56\u4e0d\u5b58\u5728");
        }
        policyEo.setStatus(RebatePolicyStatusEnum.INVALID.getCode());
        this.policyDas.updateSelective((BaseEo)policyEo);
        PolicySettleRuleEo settleRuleEo = new PolicySettleRuleEo();
        settleRuleEo.setPolicyId(id);
        this.policySettleRuleDas.logicDeleteByExample((BaseEo)settleRuleEo);
        this.policyLogService.log(policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), PolicyLogEnum.TO_VALID.getDesc(), null);
        this.policyEsService.delete(id);
    }

    @Override
    public PolicyDetailRespDto queryPolicyById(Long id) {
        PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(id);
        if (policyEo == null) {
            return null;
        }
        ConditionEo condition = new ConditionEo();
        condition.setBusinessId(id);
        condition.setBusinessType(ConditionBusinessType.POLICY_REBATE_RULE.getType());
        List conditionEos = this.conditionDas.select((BaseEo)condition);
        PolicyRespDto policyRespDto = new PolicyRespDto();
        DtoHelper.eo2Dto((BaseEo)policyEo, (BaseVo)policyRespDto);
        policyRespDto.setAttachment(this.attachmentService.getPolicyAttachment(policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType()));
        PolicyRebateRuleResDto resDto = this.conditionEo2PolicyRebateRuleResDto(conditionEos);
        CubeBeanUtils.copyProperties((Object)policyRespDto, (Object)resDto, (String[])new String[0]);
        policyRespDto.setCategory(this.categoryService.queryParentCategoryById(policyRespDto.getCategoryId()));
        PolicyDetailRespDto detailRespDto = new PolicyDetailRespDto();
        detailRespDto.setPolicy(policyRespDto);
        detailRespDto.setLog(this.policyLogService.queryLog(id, BusinessTypeEnum.REBATE_POLICY.getType()));
        return detailRespDto;
    }

    private PolicyRebateRuleResDto conditionEo2PolicyRebateRuleResDto(List<ConditionEo> conditionEoList) {
        List<ConditionTemplate> conditionTemplates = RuleFactory.getTemplate(ConditionBusinessType.POLICY_REBATE_RULE);
        PolicyRebateRuleReqDto reqDto = new PolicyRebateRuleReqDto();
        ArrayList<ConditionRespDto> conditionRespDtoList = new ArrayList<ConditionRespDto>();
        CubeBeanUtils.copyCollection(conditionRespDtoList, conditionEoList, ConditionRespDto.class);
        for (ConditionTemplate conditionTemplate : conditionTemplates) {
            conditionTemplate.parseCondition(conditionRespDtoList, reqDto);
        }
        PolicyRebateRuleResDto resDto = new PolicyRebateRuleResDto();
        CubeBeanUtils.copyProperties((Object)resDto, (Object)reqDto, (String[])new String[0]);
        return resDto;
    }

    @Override
    public PageInfo<PolicyListResDto> queryPolicyByPage(PolicyQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        reqDto.setTenantId(this.iContext.tenantId());
        reqDto.setInstanceId(this.iContext.instanceId());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List policyListResDtoList = this.policyDas.selectPageList(reqDto);
        return PageInfo.of((List)policyListResDtoList);
    }

    @Override
    public void audit(Long id, PolicyAuditReqDto reqDto) {
        PolicyEo policyEo = new PolicyEo();
        policyEo.setId(id);
        if (reqDto.getStatus().equals((Object)AuditStatusEnum.REJECT)) {
            policyEo.setStatus(RebatePolicyStatusEnum.AUDIT_REJECT.getCode());
            this.policyLogService.log(policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), PolicyLogEnum.AUDIT_REJECT.getDesc(), reqDto.getSuggestion());
            this.policyEsService.delete(id);
            this.policyDas.updateSelective((BaseEo)policyEo);
        } else {
            policyEo.setStatus(RebatePolicyStatusEnum.AUDIT_PASS.getCode());
            this.policyLogService.log(policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), PolicyLogEnum.AUDIT_PASS.getDesc(), reqDto.getSuggestion());
            this.policyDas.updateSelective((BaseEo)policyEo);
            this.policyEsService.update(policyEo.getId());
        }
    }

    @Override
    public PolicyConstantsDto constantList() {
        PolicyConstantsDto constantsDto = new PolicyConstantsDto();
        ArrayList<SelectDto> status = new ArrayList<SelectDto>();
        for (RebatePolicyStatusEnum statusEnum : RebatePolicyStatusEnum.values()) {
            if (statusEnum.equals((Object)RebatePolicyStatusEnum.AUDIT_PASS)) continue;
            SelectDto selectDto = new SelectDto();
            selectDto.setKey(statusEnum.getCode());
            selectDto.setLabel(statusEnum.getDesc());
            status.add(selectDto);
        }
        constantsDto.setStatus(status);
        ArrayList<SelectDto> accountingMethod = new ArrayList<SelectDto>();
        for (AccountingMethodEnum accountingMethodEnum : AccountingMethodEnum.values()) {
            SelectDto selectDto = new SelectDto();
            selectDto.setKey(accountingMethodEnum.getType().toString());
            selectDto.setLabel(accountingMethodEnum.getDesc());
            accountingMethod.add(selectDto);
        }
        constantsDto.setAccountingMethod(accountingMethod);
        ArrayList<SelectDto> accountingRule = new ArrayList<SelectDto>();
        for (AccountingRuleEnum accountingRuleEnum : AccountingRuleEnum.values()) {
            SelectDto selectDto = new SelectDto();
            selectDto.setKey(accountingRuleEnum.getType().toString());
            selectDto.setLabel(accountingRuleEnum.getDesc());
            accountingRule.add(selectDto);
        }
        constantsDto.setAccountingRule(accountingRule);
        ArrayList<SelectDto> cycleType = new ArrayList<SelectDto>();
        for (RebateCycleTypeEnum cycleTypeEnum : RebateCycleTypeEnum.values()) {
            SelectDto selectDto = new SelectDto();
            selectDto.setKey(cycleTypeEnum.getType().toString());
            selectDto.setLabel(cycleTypeEnum.getDesc());
            cycleType.add(selectDto);
        }
        constantsDto.setCycleType(cycleType);
        ArrayList<SelectDto> compareOp = new ArrayList<SelectDto>();
        for (CompareOpEnum compareOpEnum : CompareOpEnum.values()) {
            SelectDto selectDto = new SelectDto();
            selectDto.setKey(compareOpEnum.getCode());
            selectDto.setLabel(compareOpEnum.getName());
            compareOp.add(selectDto);
        }
        constantsDto.setCompareOp(compareOp);
        return constantsDto;
    }

    @Override
    public void submit(Long id) {
        PolicyEo policyEo = new PolicyEo();
        policyEo.setId(id);
        policyEo.setStatus(RebatePolicyStatusEnum.WAIT_AUDIT.getCode());
        this.policyDas.updateSelective((BaseEo)policyEo);
        this.policyLogService.log(policyEo.getId(), BusinessTypeEnum.REBATE_POLICY.getType(), PolicyLogEnum.SAVE.getDesc(), null);
    }

    private void checkPolicyName(Long id, String name) {
        PolicyEo policyEo = new PolicyEo();
        policyEo.setName(name);
        policyEo.setTenantId(this.iContext.tenantId());
        List policyEos = this.policyDas.select((BaseEo)policyEo);
        if (!CollectionUtils.isEmpty((Collection)policyEos) && id == null) {
            throw new BizException("\u8fd4\u5229\u653f\u7b56\u540d\u79f0\u91cd\u590d");
        }
        if (id != null && !CollectionUtils.isEmpty((Collection)policyEos) && !((PolicyEo)policyEos.get(0)).getId().equals(id)) {
            throw new BizException("\u8fd4\u5229\u653f\u7b56\u540d\u79f0\u91cd\u590d");
        }
    }
}

