/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.AccountingMethodEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.AccountingRuleEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicySegmentReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicySettleRuleReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicySettleRuleRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.RebateCalcFactory;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.RebateCalcStrategy;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicySettleRuleService;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.ConditionDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.PolicySettleRuleDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.ConditionEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PolicyEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PolicySettleRuleEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PreSettlementEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PolicySettleRuleServiceImpl
implements IPolicySettleRuleService {
    @Resource
    private PolicySettleRuleDas policySettleRuleDas;
    @Resource
    private ConditionDas conditionDas;
    @Resource
    private PolicyDas policyDas;

    @Override
    public Long addPolicySettleRule(PolicySettleRuleReqDto addReqDto) {
        PolicySettleRuleEo policySettleRuleEo = new PolicySettleRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)policySettleRuleEo);
        this.policySettleRuleDas.insert((BaseEo)policySettleRuleEo);
        return policySettleRuleEo.getId();
    }

    @Override
    public void modifyPolicySettleRule(PolicySettleRuleReqDto modifyReqDto) {
        PolicySettleRuleEo policySettleRuleEo = new PolicySettleRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)policySettleRuleEo);
        this.policySettleRuleDas.updateSelective((BaseEo)policySettleRuleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePolicySettleRule(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.policySettleRuleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PolicySettleRuleRespDto queryById(Long id) {
        PolicySettleRuleEo policySettleRuleEo = (PolicySettleRuleEo)this.policySettleRuleDas.selectByPrimaryKey(id);
        PolicySettleRuleRespDto policySettleRuleRespDto = new PolicySettleRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)policySettleRuleEo, (BaseVo)policySettleRuleRespDto);
        return policySettleRuleRespDto;
    }

    @Override
    public PageInfo<PolicySettleRuleRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PolicySettleRuleReqDto policySettleRuleReqDto = (PolicySettleRuleReqDto)JSON.parseObject((String)filter, PolicySettleRuleReqDto.class);
        PolicySettleRuleEo policySettleRuleEo = new PolicySettleRuleEo();
        DtoHelper.dto2Eo((BaseVo)policySettleRuleReqDto, (BaseEo)policySettleRuleEo);
        PageInfo eoPageInfo = this.policySettleRuleDas.selectPage((BaseEo)policySettleRuleEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PolicySettleRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public BigDecimal calcRebateAmt(PreSettlementEo settlementEo) {
        BigDecimal curAddUpQty = settlementEo.getConsumeQty() == null ? BigDecimal.ZERO : settlementEo.getConsumeQty();
        BigDecimal curAddUpAmt = settlementEo.getConsumeAmt() == null ? BigDecimal.ZERO : settlementEo.getConsumeAmt();
        BigDecimal returnQty = settlementEo.getReturnQty() == null ? BigDecimal.ZERO : settlementEo.getReturnQty();
        BigDecimal returnAmt = settlementEo.getReturnAmt() == null ? BigDecimal.ZERO : settlementEo.getReturnAmt();
        curAddUpQty = curAddUpQty.subtract(returnQty);
        curAddUpAmt = curAddUpAmt.subtract(returnAmt);
        return this.calcRebateAmt(settlementEo.getPolicyId(), settlementEo.getPolicyRuleId(), curAddUpQty, curAddUpAmt);
    }

    @Override
    public BigDecimal calcRebateAmt(Long policyId, Long policyRuleId, BigDecimal curAddUpQty, BigDecimal curAddUpAmt) {
        BigDecimal rebateAmt = BigDecimal.ZERO;
        PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(policyId);
        PolicySettleRuleEo settleRuleEntity = (PolicySettleRuleEo)this.policySettleRuleDas.selectByPrimaryKey(policyRuleId);
        Long conditionId = settleRuleEntity.getConditionId();
        ConditionEo settleRuleCondition = (ConditionEo)this.conditionDas.selectByPrimaryKey(conditionId);
        PolicySegmentReqDto dto = (PolicySegmentReqDto)JSON.parseObject((String)settleRuleCondition.getConditionParams(), PolicySegmentReqDto.class);
        AccountingRuleEnum accountingRuleEnum = AccountingRuleEnum.getByType((Integer)policyEo.getAccountingRule());
        AccountingMethodEnum accountingMethodEnum = AccountingMethodEnum.getByType((Integer)policyEo.getAccountingMethod());
        RebateCalcStrategy rebateCalcStrategy = RebateCalcFactory.getRebateCalcStrategy(accountingRuleEnum.getCode());
        switch (accountingMethodEnum) {
            case MONEY: {
                rebateAmt = rebateCalcStrategy.calcRebate(dto, curAddUpAmt);
                break;
            }
            case QUANTITY: {
                rebateAmt = rebateCalcStrategy.calcRebate(dto, curAddUpQty);
                break;
            }
        }
        return rebateAmt;
    }

    @Override
    public PolicySettleRuleRespDto queryByConditionIdAndPolicyId(Long policyId, Long conditionId) {
        PolicySettleRuleEo policySettleRuleEo = (PolicySettleRuleEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.policySettleRuleDas.filter().eq((Object)"policy_id", (Object)policyId)).eq((Object)"condition_id", (Object)conditionId)).one();
        PolicySettleRuleRespDto policySettleRuleRespDto = new PolicySettleRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)policySettleRuleEo, (BaseVo)policySettleRuleRespDto);
        return policySettleRuleRespDto;
    }
}

