/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.UserTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.PolicyEsDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceNegativeReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalancePayReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PreSettlementQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PreSettlementReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PreSettlementRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.RebateCycleCalcFactory;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.RebateCycleCalcStrategy;
import com.dtyunxi.yundt.cube.center.rebate.biz.calc.vo.RebateCycleVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.mq.vo.OrderItemVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.mq.vo.OrderMsgVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.mq.vo.RefundOrderMsgVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.mq.vo.ReturnItemVo;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IBalanceService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicyEsService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicyService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicySettleRuleService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPreSettlementService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IRefundItemService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.ISettleItemService;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.DateUtil;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.RebateUtil;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.BalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.PolicyDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.PreSettlementDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.BalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PolicyEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PreSettlementEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RefundItemEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.SettleItemEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.vo.RefundItemStatisticVo;
import com.dtyunxi.yundt.cube.center.rebate.dao.vo.SettleItemStatisticVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PreSettlementServiceImpl
implements IPreSettlementService {
    private static Logger logger = LoggerFactory.getLogger(PreSettlementServiceImpl.class);
    @Resource
    private PreSettlementDas preSettlementDas;
    @Resource
    private IPolicyService policyService;
    @Resource
    private IPolicySettleRuleService policySettleRuleService;
    @Resource
    private ISettleItemService settleItemService;
    @Resource
    private IRefundItemService refundItemService;
    @Resource
    private IOrderService orderService;
    @Resource
    private OrderDas orderDas;
    @Resource
    private PolicyDas policyDas;
    @Resource
    private BalanceDas balanceDas;
    @Resource
    private IPolicyEsService policyEsService;
    @Resource
    private IBalanceService balanceService;

    @Override
    public Long addPreSettlement(PreSettlementReqDto addReqDto) {
        PreSettlementEo preSettlementEo = new PreSettlementEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)preSettlementEo);
        this.preSettlementDas.insert((BaseEo)preSettlementEo);
        return preSettlementEo.getId();
    }

    @Override
    public void modifyPreSettlement(PreSettlementReqDto modifyReqDto) {
        PreSettlementEo preSettlementEo = new PreSettlementEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)preSettlementEo);
        this.preSettlementDas.updateSelective((BaseEo)preSettlementEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePreSettlement(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.preSettlementDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PreSettlementRespDto queryById(Long id) {
        PreSettlementEo preSettlementEo = (PreSettlementEo)this.preSettlementDas.selectByPrimaryKey(id);
        PreSettlementRespDto preSettlementRespDto = new PreSettlementRespDto();
        DtoHelper.eo2Dto((BaseEo)preSettlementEo, (BaseVo)preSettlementRespDto);
        return preSettlementRespDto;
    }

    @Override
    public PageInfo<PreSettlementRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PreSettlementReqDto preSettlementReqDto = (PreSettlementReqDto)JSON.parseObject((String)filter, PreSettlementReqDto.class);
        PreSettlementEo preSettlementEo = new PreSettlementEo();
        DtoHelper.dto2Eo((BaseVo)preSettlementReqDto, (BaseEo)preSettlementEo);
        PageInfo eoPageInfo = this.preSettlementDas.selectPage((BaseEo)preSettlementEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PreSettlementRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<PreSettlementEo> selectUnSettlePolicyUser(PreSettlementQueryReqDto query) {
        return this.preSettlementDas.selectLastNdayUnSettleUser(query);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean genUserRebateOrder(PreSettlementEo policyUser) {
        try {
            PolicyRespDto policyDto = this.policyService.queryPolicyById(policyUser.getPolicyId()).getPolicy();
            logger.info("\u5f00\u59cb\u7ed3\u7b97\u7528\u6237{},\u653f\u7b56{},\u7ed3\u7b97\u65e5{}\u7684\u8fd4\u5229\u5355", new Object[]{policyUser.getUserId(), policyDto.getName(), policyUser.getCurSettleDate()});
            PreSettlementEo queryEo = new PreSettlementEo();
            queryEo.setPolicyId(policyUser.getPolicyId());
            queryEo.setUserId(policyUser.getUserId());
            queryEo.setCurSettleDate(policyUser.getCurSettleDate());
            List userPolicyPreSettlementList = this.preSettlementDas.selectList((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(100));
            this.confirmSettlementQtyAndAmt(userPolicyPreSettlementList);
            BigDecimal rebateAmtTotal = userPolicyPreSettlementList.stream().map(item -> item.getSettleAmount() == null ? BigDecimal.ZERO : item.getSettleAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            OrderEo orderEo = this.saveUserRebateOrder(policyDto, rebateAmtTotal, userPolicyPreSettlementList);
            this.updSettlementStatus(orderEo, userPolicyPreSettlementList);
        }
        catch (Exception e) {
            logger.error("error={}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private void updSettlementStatus(OrderEo orderEo, List<PreSettlementEo> userPolicyPreSettlementList) {
        for (PreSettlementEo settlementEo : userPolicyPreSettlementList) {
            PreSettlementEo updEntity = new PreSettlementEo();
            updEntity.setId(settlementEo.getId());
            updEntity.setRebateId(orderEo.getId());
            updEntity.setRebateNo(orderEo.getRebateNo());
            updEntity.setSettleAmount(settlementEo.getSettleAmount());
            if (settlementEo.getRebateId() != null) continue;
            this.preSettlementDas.updateSelective((BaseEo)updEntity);
        }
    }

    private OrderEo saveUserRebateOrder(PolicyRespDto policyDto, BigDecimal rebateAmtTotal, List<PreSettlementEo> userPolicyPreSettlementList) {
        OrderEo orderEo = new OrderEo();
        orderEo.setPolicyId(policyDto.getId());
        orderEo.setRebateAmount(rebateAmtTotal);
        orderEo.setUseEffectType(policyDto.getUseEffectType());
        orderEo.setUseEffectNum(policyDto.getUseEffectNum());
        orderEo.setCategoryId(policyDto.getCategoryId());
        boolean rebateExists = this.checkRebateOrderExists(userPolicyPreSettlementList);
        if (rebateExists) {
            Optional<PreSettlementEo> opt = userPolicyPreSettlementList.stream().filter(p -> p.getRebateId() != null).findFirst();
            PreSettlementEo eo = opt.orElseThrow(() -> new IllegalArgumentException());
            orderEo.setId(eo.getRebateId());
            this.orderDas.updateSelective((BaseEo)orderEo);
        } else {
            PreSettlementEo preSettlementEo = userPolicyPreSettlementList.get(0);
            String rebateNo = RebateUtil.generateRebateAccountNo("RB");
            orderEo.setRebateNo(rebateNo);
            orderEo.setType(Integer.valueOf(1));
            orderEo.setUseEffectNum(policyDto.getUseEffectNum());
            orderEo.setUseEffectType(policyDto.getUseEffectType());
            orderEo.setOrganizationId(policyDto.getOrganizationId());
            orderEo.setOrganizationName(policyDto.getOrganizationName());
            orderEo.setStatus(RebateOrderStatusEnum.WAIT_AUDIT.getCode());
            orderEo.setUserId(preSettlementEo.getUserId());
            orderEo.setUserName(preSettlementEo.getUserName());
            orderEo.setUserType(StringUtils.isNotEmpty((CharSequence)preSettlementEo.getUserType()) ? preSettlementEo.getUserType() : UserTypeEnum.CUSTOMER.toCode());
            BalanceEo queryBalanceEo = new BalanceEo();
            queryBalanceEo.setUserId(preSettlementEo.getUserId());
            queryBalanceEo.setUserType(StringUtils.isNotEmpty((CharSequence)preSettlementEo.getUserType()) ? preSettlementEo.getUserType() : UserTypeEnum.CUSTOMER.toCode());
            BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectOne((BaseEo)queryBalanceEo);
            if (null != balanceEo) {
                orderEo.setRebateAccountNo(balanceEo.getRebateAccountNo());
            }
            this.orderDas.insert((BaseEo)orderEo);
        }
        return orderEo;
    }

    private boolean checkRebateOrderExists(List<PreSettlementEo> userPolicyPreSettlementList) {
        for (PreSettlementEo settlementEo : userPolicyPreSettlementList) {
            if (settlementEo.getRebateId() == null) continue;
            return true;
        }
        return false;
    }

    private void confirmSettlementQtyAndAmt(List<PreSettlementEo> userPolicyPreSettlementList) {
        for (PreSettlementEo settlementEo : userPolicyPreSettlementList) {
            Long preSettlementId = settlementEo.getId();
            SettleItemStatisticVo settleItemStatisticVo = this.settleItemService.statisticByPreSettleId(preSettlementId);
            RefundItemStatisticVo refundItemStatisticVo = this.refundItemService.statisticByPreSettleId(preSettlementId);
            if (settleItemStatisticVo.compareQtyAndAmt(settlementEo) != 0) {
                settlementEo.setConsumeAmt(settleItemStatisticVo.getConsumeAmt());
                settlementEo.setConsumeQty(settleItemStatisticVo.getConsumeQty());
            }
            if (refundItemStatisticVo != null && refundItemStatisticVo.compareReturnQtyAndAmt(settlementEo) != 0) {
                settlementEo.setReturnAmt(refundItemStatisticVo.getReturnAmt());
                settlementEo.setReturnQty(refundItemStatisticVo.getReturnQty());
            }
            BigDecimal returnQty = settlementEo.getReturnQty() == null ? BigDecimal.ZERO : settlementEo.getReturnQty();
            BigDecimal returnAmt = settlementEo.getReturnAmt() == null ? BigDecimal.ZERO : settlementEo.getReturnAmt();
            BigDecimal actualConsumeQty = settlementEo.getConsumeQty().setScale(2).subtract(returnQty);
            BigDecimal actualConsumeAmt = settlementEo.getConsumeAmt().setScale(2).subtract(returnAmt);
            logger.info("\u89c4\u5219{}\u91cd\u65b0\u8ba1\u7b97\u8fd4\u5229\u53c2\u6570\u662f\uff1aactualConsumeQty={},actualConsumeAmt={} ", new Object[]{settlementEo.getPolicyRuleId(), actualConsumeQty, actualConsumeAmt});
            BigDecimal actualRebateAtm = this.policySettleRuleService.calcRebateAmt(settlementEo.getPolicyId(), settlementEo.getPolicyRuleId(), actualConsumeQty, actualConsumeAmt);
            logger.info("\u89c4\u5219{}\u91cd\u65b0\u8ba1\u7b97\u8fd4\u5229\u91d1\u989d\u662f\uff1a{} ", (Object)settlementEo.getPolicyRuleId(), (Object)actualRebateAtm);
            settlementEo.setSettleAmount(actualRebateAtm);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean preSettlementItemRebate(OrderMsgVo orderMsg) {
        boolean orderNoExists = this.settleItemService.isOrderNoExists(orderMsg.getOrderNo());
        ArrayList<SettleItemEo> settleItemList = new ArrayList<SettleItemEo>();
        if (!orderNoExists) {
            List<OrderItemVo> items = orderMsg.getItemList();
            for (OrderItemVo itemVo : items) {
                String itemId = itemVo.getItemId();
                Long userId = orderMsg.getCustomerId();
                Long skuId = itemVo.getSkuId();
                Date orderTime = orderMsg.getPlaceTime();
                BigDecimal itemDeductAmt = itemVo.getRebateAmount() == null ? BigDecimal.ZERO : itemVo.getRebateAmount();
                BigDecimal itemSubTotle = itemVo.getSubTotal() == null ? BigDecimal.ZERO : itemVo.getSubTotal();
                PolicyEsDto policyEsDto = this.policyEsService.queryByCondition(Long.valueOf(itemId), skuId, userId, orderTime);
                if (policyEsDto != null) {
                    RebateCycleVo cycleVo;
                    Date settlementDate;
                    Long policyId = policyEsDto.getPolicyId();
                    PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(policyId);
                    Long accountRuleId = this.policyEsService.matchAccountRuleId(policyEsDto, itemId, String.valueOf(skuId));
                    PreSettlementEo preSettlementEo = this.queryItemPreSettlement(policyId, accountRuleId, userId, settlementDate = this.calcRebateSettleDate(policyEo, cycleVo = this.calcRebateCycle(policyEo, orderTime), orderTime));
                    if (preSettlementEo != null) {
                        BigDecimal curAddUpQty = preSettlementEo.getConsumeQty().add(BigDecimal.valueOf(itemVo.getItemNum().intValue()));
                        BigDecimal curAddUpAmt = preSettlementEo.getConsumeAmt().add(itemSubTotle);
                        BigDecimal newRebateAmt = this.policySettleRuleService.calcRebateAmt(preSettlementEo.getPolicyId(), preSettlementEo.getPolicyRuleId(), curAddUpQty, curAddUpAmt);
                        this.updAddUpAmt(preSettlementEo.getId(), itemVo.getItemNum(), itemSubTotle, newRebateAmt);
                    } else {
                        preSettlementEo = new PreSettlementEo();
                        preSettlementEo.setPolicyId(policyId);
                        preSettlementEo.setConsumeQty(BigDecimal.valueOf(itemVo.getItemNum().intValue()));
                        preSettlementEo.setConsumeAmt(itemSubTotle);
                        preSettlementEo.setCurPeriodStart(cycleVo.getCycleStart());
                        preSettlementEo.setCurPeriodEnd(cycleVo.getCycleEnd());
                        preSettlementEo.setCurSettleDate(settlementDate);
                        preSettlementEo.setSettlePeriodType("" + policyEo.getCycleType());
                        preSettlementEo.setPolicyRuleId(accountRuleId);
                        preSettlementEo.setInstanceId(orderMsg.getInstanceId());
                        preSettlementEo.setTenantId(orderMsg.getTenantId());
                        BigDecimal curRebateAmt = this.policySettleRuleService.calcRebateAmt(preSettlementEo.getPolicyId(), preSettlementEo.getPolicyRuleId(), preSettlementEo.getConsumeQty(), itemSubTotle.add(itemDeductAmt));
                        preSettlementEo.setSettleAmount(curRebateAmt);
                        this.setUpPreSettlementProps(preSettlementEo, orderMsg);
                        this.preSettlementDas.insert((BaseEo)preSettlementEo);
                    }
                    SettleItemEo settleItemEntity = new SettleItemEo();
                    settleItemEntity.setPreSettleId(preSettlementEo.getId());
                    settleItemEntity.setOrderNo(orderMsg.getOrderNo());
                    settleItemEntity.setOrderTime(orderTime);
                    settleItemEntity.setPolicyId(policyId);
                    settleItemEntity.setUserId(preSettlementEo.getUserId());
                    settleItemEntity.setUserName(preSettlementEo.getUserName());
                    settleItemEntity.setOrgId(orderMsg.getOrgInfoId());
                    settleItemEntity.setRetailPrice(itemVo.getItemPrice());
                    settleItemEntity.setSkuDeductAmt(itemDeductAmt);
                    settleItemEntity.setInstanceId(orderMsg.getInstanceId());
                    settleItemEntity.setTenantId(orderMsg.getTenantId());
                    this.setUpSettleItemProps(settleItemEntity, itemVo);
                    settleItemList.add(settleItemEntity);
                    continue;
                }
                logger.info("\u5546\u54c1\u6ca1\u6709\u6709\u6548\u7684\u8fd4\u5229\u653f\u7b56");
                SettleItemEo settleItemEntity = new SettleItemEo();
                this.setUpSettleItemProps(settleItemEntity, itemVo);
                settleItemEntity.setOrderNo(orderMsg.getOrderNo());
                settleItemEntity.setOrderTime(orderTime);
                settleItemEntity.setUserId(orderMsg.getCustomerId());
                settleItemEntity.setUserName(orderMsg.getCustomerName());
                settleItemEntity.setOrgId(orderMsg.getOrgInfoId());
                settleItemEntity.setRetailPrice(itemVo.getItemPrice());
                settleItemEntity.setSkuDeductAmt(itemDeductAmt);
                settleItemEntity.setInstanceId(orderMsg.getInstanceId());
                settleItemEntity.setTenantId(orderMsg.getTenantId());
                settleItemList.add(settleItemEntity);
            }
            this.settleItemService.batchSave(settleItemList);
        }
        return true;
    }

    private RebateCycleVo calcRebateCycle(PolicyEo policyEo, Date orderTime) {
        Object settleDate = null;
        Date policyStartDate = policyEo.getEffectTime();
        Date policyEndDate = policyEo.getFailureTime() == null ? DateUtil.getDateAfter(orderTime, 1825) : policyEo.getFailureTime();
        Integer cycleType = policyEo.getCycleType();
        RebateCycleCalcStrategy rebateCycleCalcStrategy = RebateCycleCalcFactory.getRebateCycleCalcStrategy("" + cycleType);
        RebateCycleVo cycleVo = rebateCycleCalcStrategy.findDateMapperRebateCycle(policyStartDate, policyEndDate, orderTime);
        return cycleVo;
    }

    private Date calcRebateSettleDate(PolicyEo policyEo, RebateCycleVo cycleVo, Date orderTime) {
        Date settleDate = null;
        Integer cycleType = policyEo.getCycleType();
        Integer cycleMonth = policyEo.getCycleMonth();
        Integer cycleDay = policyEo.getCycleDay();
        RebateCycleCalcStrategy rebateCycleCalcStrategy = RebateCycleCalcFactory.getRebateCycleCalcStrategy("" + cycleType);
        settleDate = rebateCycleCalcStrategy.calcSettleDate(cycleVo, cycleMonth, cycleDay);
        return settleDate;
    }

    private void setUpPreSettlementProps(PreSettlementEo preSettlementEo, OrderMsgVo orderMsg) {
        preSettlementEo.setUserType(orderMsg.getUserSrc() == null ? orderMsg.getUserSrc() : UserTypeEnum.CUSTOMER.toCode());
        preSettlementEo.setUserId(orderMsg.getCustomerId());
        preSettlementEo.setOrgName(orderMsg.getOrganizationName());
        preSettlementEo.setOrgId(orderMsg.getOrgInfoId());
        preSettlementEo.setUserName(orderMsg.getCustomerName());
    }

    private void setUpSettleItemProps(SettleItemEo settleItemEntity, OrderItemVo item) {
        settleItemEntity.setItemId(Long.valueOf(item.getItemId()));
        settleItemEntity.setItemName(item.getItemName());
        settleItemEntity.setItemSkuId(Long.valueOf(item.getSkuId()));
        settleItemEntity.setSkuCode(item.getSkuCode());
        settleItemEntity.setSkuName(item.getSkuName());
        settleItemEntity.setPurchaseQty(item.getItemNum());
        settleItemEntity.setSkuPaymentAmt(item.getSubTotal());
    }

    public boolean updAddUpAmt(Long id, Integer itemNum, BigDecimal payTotalAmount, BigDecimal newRebateAmt) {
        PreSettlementEo adjustEo = new PreSettlementEo();
        adjustEo.setId(id);
        adjustEo.setConsumeQty(BigDecimal.valueOf(itemNum.intValue()));
        adjustEo.setConsumeAmt(payTotalAmount);
        adjustEo.setSettleAmount(newRebateAmt);
        return this.preSettlementDas.incrConsumeQty(adjustEo) > 0;
    }

    public PreSettlementEo queryItemPreSettlement(Long policyId, Long policyRuleId, Long userId, Date settlementDate) {
        PreSettlementEo res = (PreSettlementEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.preSettlementDas.filter().eq((Object)"policy_id", (Object)policyId)).eq((Object)"policy_rule_id", (Object)policyRuleId)).eq((Object)"user_id", (Object)userId)).eq((Object)"cur_settle_date", (Object)settlementDate)).one();
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean reCalcPolicyRebate(RefundOrderMsgVo msg) {
        logger.info("\u5f00\u59cb\u6263\u51cf(\u9000\u8ba2\u5355)\u5546\u54c1\u653f\u7b56\u8fd4\u5229\uff1a={}", (Object)msg.getReturnNo());
        try {
            String returnNo = msg.getReturnNo();
            if (this.checkRefundOrderExists(returnNo)) {
                logger.info("\u9000\u6b3e\u5355={}\u5df2\u5b58\u5728\uff0c\u5df2\u6263\u51cf\u6210\u529f", (Object)msg.getRefundNo());
                return true;
            }
            if (!this.settleItemService.isOrderNoExists(msg.getOrderNo())) {
                logger.info("\u8ba2\u5355{}\u5546\u54c1\u6ca1\u6709\u53c2\u52a0\u653f\u7b56\u8fd4\u5229\uff0c\u4e0d\u7528\u6263\u51cf", (Object)msg.getOrderNo());
                return true;
            }
            String orderNo = msg.getOrderNo();
            Long userId = msg.getUserId();
            Date placeDate = msg.getPlaceDate();
            ArrayList<RefundItemEo> refundItemEoList = new ArrayList<RefundItemEo>();
            for (ReturnItemVo returnItemVo : msg.getReturnItemVoList()) {
                BalancePayReqDto nagitiveBalance;
                RebateCycleVo cycleVo;
                Date settlementDate;
                Long skuId;
                Long itemId = returnItemVo.getItemId();
                PolicyEsDto policyEsDto = this.policyEsService.queryByCondition(itemId, skuId = returnItemVo.getSkuSerial(), userId, placeDate);
                if (policyEsDto == null) continue;
                Long policyId = policyEsDto.getPolicyId();
                PolicyEo policyEo = (PolicyEo)this.policyDas.selectByPrimaryKey(policyId);
                Long accountRuleId = this.policyEsService.matchAccountRuleId(policyEsDto, String.valueOf(itemId), String.valueOf(skuId));
                PreSettlementEo preSettlementEo = this.queryItemPreSettlement(policyId, accountRuleId, userId, settlementDate = this.calcRebateSettleDate(policyEo, cycleVo = this.calcRebateCycle(policyEo, placeDate), placeDate));
                if (preSettlementEo == null) continue;
                BigDecimal returnNum = BigDecimal.valueOf(returnItemVo.getReturnNum().intValue());
                BigDecimal refundAmt = returnItemVo.getRefundAmount() == null ? BigDecimal.ZERO : returnItemVo.getRefundAmount();
                BigDecimal returnRebate = returnItemVo.getReturnRebate() == null ? BigDecimal.ZERO : returnItemVo.getReturnRebate();
                BigDecimal itemSubTotle = refundAmt.add(returnRebate);
                RefundItemEo curRefundItemEo = new RefundItemEo();
                this.setRefundItemProp(curRefundItemEo, returnItemVo, preSettlementEo);
                curRefundItemEo.setPolicyId(policyId);
                curRefundItemEo.setPreSettleId(preSettlementEo.getId());
                curRefundItemEo.setOrderTime(msg.getPlaceDate());
                curRefundItemEo.setRefundAuditTime(new Date());
                if (preSettlementEo.getRebateId() == null) {
                    this.updReturnQtyAndAmt(preSettlementEo, returnNum, itemSubTotle);
                    curRefundItemEo.setRebateCutType(Integer.valueOf(1));
                    curRefundItemEo.setRefundAfterSettle(Integer.valueOf(0));
                    refundItemEoList.add(curRefundItemEo);
                    continue;
                }
                BigDecimal rebateCutAmt = this.updReturnQtyAndAmtAfter(preSettlementEo, returnNum, itemSubTotle);
                curRefundItemEo.setRebateCutAmt(rebateCutAmt);
                curRefundItemEo.setRebateCutType(Integer.valueOf(2));
                curRefundItemEo.setRefundAfterSettle(Integer.valueOf(1));
                refundItemEoList.add(curRefundItemEo);
                if (rebateCutAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                Long rebateId = preSettlementEo.getRebateId();
                BalanceEo selectItemBalance = new BalanceEo();
                selectItemBalance.setUserId(userId);
                BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectOne((BaseEo)selectItemBalance);
                if (balanceEo == null) {
                    logger.error("\u7528\u6237={}\u8fd4\u5229\u4f59\u989d\u4e0d\u5b58\u5728\uff0c\u4e0d\u505a\u6263\u51cf", (Object)userId);
                    continue;
                }
                BigDecimal balanceAmt = balanceEo.getBalance();
                BigDecimal canCutAmt = BigDecimal.ZERO;
                BigDecimal leftCutAmt = BigDecimal.ZERO;
                if (balanceAmt.compareTo(rebateCutAmt) >= 0 && balanceAmt.compareTo(BigDecimal.ZERO) > 0) {
                    canCutAmt = rebateCutAmt;
                    leftCutAmt = BigDecimal.ZERO;
                } else if (balanceAmt.compareTo(rebateCutAmt) < 0 && balanceAmt.compareTo(BigDecimal.ZERO) > 0) {
                    canCutAmt = balanceAmt;
                    leftCutAmt = rebateCutAmt.subtract(balanceAmt);
                } else {
                    canCutAmt = BigDecimal.ZERO;
                    leftCutAmt = rebateCutAmt;
                }
                if (canCutAmt.compareTo(BigDecimal.ZERO) > 0) {
                    nagitiveBalance = new BalancePayReqDto();
                    nagitiveBalance.setChangeType(ChangeTypeEnum.REBATE_NEGATIVE.toCode());
                    nagitiveBalance.setUserId(userId);
                    nagitiveBalance.setOrderNo(orderNo);
                    nagitiveBalance.setBusinessNo(returnNo);
                    nagitiveBalance.setPayAmount(canCutAmt);
                    this.balanceService.useBalance(nagitiveBalance);
                }
                if (leftCutAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                nagitiveBalance = new BalanceNegativeReqDto();
                nagitiveBalance.setChangeType(ChangeTypeEnum.REBATE_NEGATIVE.toCode());
                nagitiveBalance.setUserId(userId);
                nagitiveBalance.setOrderNo(orderNo);
                nagitiveBalance.setBusinessNo(returnNo);
                nagitiveBalance.setPayAmount(leftCutAmt);
                this.balanceService.saveNegativeRebate((BalanceNegativeReqDto)nagitiveBalance, preSettlementEo);
            }
            if (!refundItemEoList.isEmpty()) {
                this.refundItemService.batchSave(refundItemEoList);
            }
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355\u9000\u6b3e\uff1a\u653f\u7b56\u8fd4\u5229\u6263\u51cf\u5f02\u5e38={}", e.getCause());
        }
        return true;
    }

    private void setRefundItemProp(RefundItemEo curRefundItemEo, ReturnItemVo returnItemVo, PreSettlementEo preSettlementEo) {
        CubeBeanUtils.copyProperties((Object)curRefundItemEo, (Object)((Object)returnItemVo), (String[])new String[0]);
        curRefundItemEo.setSkuId(returnItemVo.getSkuSerial());
        curRefundItemEo.setRefundQty(returnItemVo.getReturnNum());
        curRefundItemEo.setRefundAmt(returnItemVo.getRefundAmount());
        curRefundItemEo.setRefundRebateAmt(returnItemVo.getReturnRebate());
        curRefundItemEo.setRetailPrice(returnItemVo.getItemPrice());
        curRefundItemEo.setOrderNo(returnItemVo.getTradeNo());
        curRefundItemEo.setPurchaseQty(returnItemVo.getItemNum());
        curRefundItemEo.setRefundNo(returnItemVo.getReturnNo());
        if (preSettlementEo != null) {
            curRefundItemEo.setOrgId(preSettlementEo.getOrgId());
            curRefundItemEo.setOrgName(preSettlementEo.getOrgName());
            curRefundItemEo.setUserId(preSettlementEo.getUserId());
            curRefundItemEo.setUserName(preSettlementEo.getUserName());
            curRefundItemEo.setUserType(preSettlementEo.getUserType());
        }
    }

    private BigDecimal updReturnQtyAndAmtAfter(PreSettlementEo preSettlementEo, BigDecimal returnNum, BigDecimal itemSubTotle) {
        BigDecimal curAddUpReturnQtyAfter = preSettlementEo.getReturnQtyAfter().add(returnNum);
        BigDecimal curAddUpReturnAmtAfter = preSettlementEo.getReturnAmtAfter().add(itemSubTotle);
        BigDecimal curAddUpQty = preSettlementEo.getConsumeQty().subtract(preSettlementEo.getReturnQty()).subtract(curAddUpReturnQtyAfter);
        BigDecimal curAddUpAmt = preSettlementEo.getConsumeAmt().subtract(preSettlementEo.getReturnAmt()).subtract(curAddUpReturnAmtAfter);
        BigDecimal recalcSettleAmount = preSettlementEo.getRecalcSettleAmount() == null ? preSettlementEo.getSettleAmount() : preSettlementEo.getRecalcSettleAmount();
        BigDecimal newRebateAmt = this.policySettleRuleService.calcRebateAmt(preSettlementEo.getPolicyId(), preSettlementEo.getPolicyRuleId(), curAddUpQty, curAddUpAmt);
        BigDecimal rebateCutAmt = recalcSettleAmount.subtract(newRebateAmt);
        PreSettlementEo adjustEo = new PreSettlementEo();
        adjustEo.setId(preSettlementEo.getId());
        adjustEo.setReturnQtyAfter(returnNum);
        adjustEo.setReturnAmtAfter(itemSubTotle);
        adjustEo.setSettleAmount(newRebateAmt);
        this.preSettlementDas.incrReturnQtyAfter(adjustEo);
        return rebateCutAmt;
    }

    private BigDecimal updReturnQtyAndAmt(PreSettlementEo preSettlementEo, BigDecimal returnNum, BigDecimal itemSubTotle) {
        BigDecimal curAddUpReturnQty = preSettlementEo.getReturnQty().add(returnNum);
        BigDecimal curAddUpReturnAmt = preSettlementEo.getReturnAmt().add(itemSubTotle);
        BigDecimal curAddUpQty = preSettlementEo.getConsumeQty().subtract(curAddUpReturnQty);
        BigDecimal curAddUpAmt = preSettlementEo.getConsumeAmt().subtract(curAddUpReturnAmt);
        BigDecimal newRebateAmt = this.policySettleRuleService.calcRebateAmt(preSettlementEo.getPolicyId(), preSettlementEo.getPolicyRuleId(), curAddUpQty, curAddUpAmt);
        PreSettlementEo adjustEo = new PreSettlementEo();
        adjustEo.setId(preSettlementEo.getId());
        adjustEo.setReturnQty(returnNum);
        adjustEo.setReturnAmt(itemSubTotle);
        adjustEo.setSettleAmount(newRebateAmt);
        this.preSettlementDas.incrReturnQty(adjustEo);
        return newRebateAmt;
    }

    private boolean checkRefundOrderExists(String refundNo) {
        return this.refundItemService.checkRefundOrderExists(refundNo);
    }
}

